/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.AddMemberToSupertypeFixFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\u0016\u0010\u000b\u001a\u00020\u0001*\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\u000f"}, d2={"addMember", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "memberData", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/AddMemberToSupertypeFixFactory$MemberData;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "removeDefaultParameterValues", "copyAnnotationEntriesFrom", "member", "actionName", "", "intellij.kotlin.codeInsight.fixes"})
@SourceDebugExtension(value={"SMAP\nAddMemberToSupertypeFixFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddMemberToSupertypeFixFactory.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/AddMemberToSupertypeFixFactoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n1915#2,2:259\n1915#2,2:261\n*S KotlinDebug\n*F\n+ 1 AddMemberToSupertypeFixFactory.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/AddMemberToSupertypeFixFactoryKt\n*L\n228#1:259,2\n235#1:261,2\n*E\n"})
public final class AddMemberToSupertypeFixFactoryKt {
    private static final void addMember(Project project, KtCallableDeclaration element, AddMemberToSupertypeFixFactory.MemberData memberData, ModPsiUpdater updater2) {
        KtCallableDeclaration memberElement = (KtCallableDeclaration)new KtPsiFactory(project, false, 2, null).createDeclaration(memberData.getSourceCode());
        PsiElement psiElement = updater2.getWritable((PsiElement)memberData.getTargetClass());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getWritable(...)");
        KtClassBody classBody = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)((KtClassOrObject)psiElement));
        AddMemberToSupertypeFixFactoryKt.removeDefaultParameterValues(element);
        AddMemberToSupertypeFixFactoryKt.copyAnnotationEntriesFrom(memberElement, element);
        PsiElement psiElement2 = classBody.addBefore((PsiElement)memberElement, classBody.getRBrace());
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
        KtCallableDeclaration insertedMemberElement = (KtCallableDeclaration)psiElement2;
        ShortenUtilsKt.shortenReferences$default((KtElement)insertedMemberElement, null, null, null, 14, null);
        PsiElement psiElement3 = KtPsiUtilKt.modalityModifier((KtDeclaration)((KtDeclaration)insertedMemberElement));
        IElementType iElementType = psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null;
        KtModifierKeywordToken ktModifierKeywordToken = iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
        if (ktModifierKeywordToken == null) {
            return;
        }
        KtModifierKeywordToken modifierToken = ktModifierKeywordToken;
        if (Intrinsics.areEqual((Object)KotlinPsiModificationUtils.predictImplicitModality((KtDeclaration)insertedMemberElement), (Object)modifierToken)) {
            RemoveModifierFixBase.Companion.removeModifier((KtModifierListOwner)insertedMemberElement, modifierToken);
        }
    }

    private static final void removeDefaultParameterValues(KtCallableDeclaration $this$removeDefaultParameterValues) {
        List list2 = $this$removeDefaultParameterValues.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            KtExpression ktExpression = it.getDefaultValue();
            if (ktExpression != null) {
                ktExpression.delete();
            }
            PsiElement psiElement = it.getEqualsToken();
            if (psiElement == null) continue;
            psiElement.delete();
        }
    }

    private static final void copyAnnotationEntriesFrom(KtCallableDeclaration $this$copyAnnotationEntriesFrom, KtCallableDeclaration member) {
        block1: {
            Object object = member;
            if (object == null || (object = object.getAnnotationEntries()) == null || (object = CollectionsKt.reversed((Iterable)((Iterable)object))) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                $this$copyAnnotationEntriesFrom.addAnnotationEntry(it);
            }
        }
    }

    @Nls
    private static final String actionName(AddMemberToSupertypeFixFactory.MemberData memberData) {
        Object[] objectArray = new Object[]{memberData.getSignaturePreview(), String.valueOf(memberData.getTargetClass().getName())};
        return KotlinBundle.message((String)"fix.add.member.supertype.add.to", (Object[])objectArray);
    }

    public static final /* synthetic */ String access$actionName(AddMemberToSupertypeFixFactory.MemberData memberData) {
        return AddMemberToSupertypeFixFactoryKt.actionName(memberData);
    }

    public static final /* synthetic */ void access$addMember(Project project, KtCallableDeclaration element, AddMemberToSupertypeFixFactory.MemberData memberData, ModPsiUpdater updater2) {
        AddMemberToSupertypeFixFactoryKt.addMember(project, element, memberData, updater2);
    }
}

