/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.renderer.types.impl.KaTypeRendererForSource;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/AddTypeAnnotationToValueParameterFixFactory;", "", "<init>", "()V", "addTypeAnnotationToValueParameterFixFactory", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$ValueParameterWithoutExplicitType;", "getAddTypeAnnotationToValueParameterFixFactory", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "getTypeName", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "defaultValue", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "AddTypeAnnotationToValueParameterFix", "intellij.kotlin.codeInsight.fixes"})
public final class AddTypeAnnotationToValueParameterFixFactory {
    @NotNull
    public static final AddTypeAnnotationToValueParameterFixFactory INSTANCE = new AddTypeAnnotationToValueParameterFixFactory();
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ValueParameterWithoutExplicitType> addTypeAnnotationToValueParameterFixFactory = AddTypeAnnotationToValueParameterFixFactory::addTypeAnnotationToValueParameterFixFactory$lambda$0;

    private AddTypeAnnotationToValueParameterFixFactory() {
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ValueParameterWithoutExplicitType> getAddTypeAnnotationToValueParameterFixFactory() {
        return addTypeAnnotationToValueParameterFixFactory;
    }

    private final String getTypeName(KaSession $this$getTypeName, KtParameter element, KtExpression defaultValue) {
        KaType kaType = $this$getTypeName.getExpressionType(defaultValue);
        if (kaType == null) {
            return null;
        }
        KaType type2 = kaType;
        if ($this$getTypeName.isArrayOrPrimitiveArray(type2)) {
            if (element.hasModifier(KtTokens.VARARG_KEYWORD)) {
                KaType kaType2 = $this$getTypeName.getArrayElementType(type2);
                if (kaType2 == null) {
                    return null;
                }
                KaType elementType = kaType2;
                return this.getTypeName($this$getTypeName, elementType);
            }
            if (defaultValue instanceof KtCollectionLiteralExpression) {
                KaType elementType;
                KaType kaType3 = elementType = $this$getTypeName.getArrayElementType(type2);
                boolean bl = kaType3 != null ? $this$getTypeName.isPrimitive(kaType3) : false;
                if (bl) {
                    KaType kaType4 = elementType;
                    Intrinsics.checkNotNull((Object)kaType4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.types.KaClassType");
                    ClassId classId = ((KaClassType)kaType4).getClassId();
                    String arrayTypeName = classId.getShortClassName() + "Array";
                    return arrayTypeName;
                }
            }
        }
        return this.getTypeName($this$getTypeName, type2);
    }

    private final String getTypeName(KaSession $this$getTypeName, KaType type2) {
        String typeName = $this$getTypeName.render(type2, KaTypeRendererForSource.INSTANCE.getWITH_SHORT_NAMES(), Variance.IN_VARIANCE);
        return typeName;
    }

    private static final List addTypeAnnotationToValueParameterFixFactory$lambda$0(KaSession $this$ModCommandBased, KaFirDiagnostic.ValueParameterWithoutExplicitType diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$ModCommandBased, (String)"$this$ModCommandBased");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        KtParameter element = (KtParameter)diagnostic.getPsi();
        KtExpression ktExpression = element.getDefaultValue();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression defaultValue = ktExpression;
        String string = INSTANCE.getTypeName($this$ModCommandBased, element, defaultValue);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String elementContext = string;
        return CollectionsKt.listOf((Object)((Object)new AddTypeAnnotationToValueParameterFix(element, elementContext)));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/AddTypeAnnotationToValueParameterFixFactory$AddTypeAnnotationToValueParameterFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "element", "typeName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "intellij.kotlin.codeInsight.fixes"})
    private static final class AddTypeAnnotationToValueParameterFix
    extends PsiUpdateModCommandAction<KtParameter> {
        @NotNull
        private final String typeName;

        public AddTypeAnnotationToValueParameterFix(@NotNull KtParameter element, @NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            super((PsiElement)element);
            this.typeName = typeName;
        }

        protected void invoke(@NotNull ActionContext actionContext, @NotNull KtParameter element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            Project project = actionContext.project();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
            element.setTypeReference(new KtPsiFactory(project, false, 2, null).createType(this.typeName));
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.add.type.annotation.family", (Object[])new Object[0]);
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtParameter element) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Object[] objectArray = new Object[]{this.typeName, String.valueOf(element.getName())};
            String actionName = KotlinBundle.message((String)"fix.add.type.annotation.text", (Object[])objectArray);
            Presentation presentation = Presentation.of((String)actionName);
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
            return presentation;
        }
    }
}

