/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixFactory;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.ConvertClassToKClassFixFactoriesKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.ConvertClassToKClassFix;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ConvertClassToKClassFixFactories;", "", "<init>", "()V", "argumentTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$ArgumentTypeMismatch;", "getArgumentTypeMismatchFixFactory", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "returnTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$ReturnTypeMismatch;", "getReturnTypeMismatchFixFactory", "initializerTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$InitializerTypeMismatch;", "getInitializerTypeMismatchFixFactory", "assignmentTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$AssignmentTypeMismatch;", "getAssignmentTypeMismatchFixFactory", "createFixIfAvailable", "Lorg/jetbrains/kotlin/idea/quickfix/ConvertClassToKClassFix;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lcom/intellij/psi/PsiElement;", "expectedType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "intellij.kotlin.codeInsight.fixes"})
public final class ConvertClassToKClassFixFactories {
    @NotNull
    public static final ConvertClassToKClassFixFactories INSTANCE = new ConvertClassToKClassFixFactories();
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ArgumentTypeMismatch> argumentTypeMismatchFixFactory = ConvertClassToKClassFixFactories::argumentTypeMismatchFixFactory$lambda$0;
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ReturnTypeMismatch> returnTypeMismatchFixFactory = ConvertClassToKClassFixFactories::returnTypeMismatchFixFactory$lambda$0;
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.InitializerTypeMismatch> initializerTypeMismatchFixFactory = ConvertClassToKClassFixFactories::initializerTypeMismatchFixFactory$lambda$0;
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.AssignmentTypeMismatch> assignmentTypeMismatchFixFactory = ConvertClassToKClassFixFactories::assignmentTypeMismatchFixFactory$lambda$0;

    private ConvertClassToKClassFixFactories() {
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ArgumentTypeMismatch> getArgumentTypeMismatchFixFactory() {
        return argumentTypeMismatchFixFactory;
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ReturnTypeMismatch> getReturnTypeMismatchFixFactory() {
        return returnTypeMismatchFixFactory;
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.InitializerTypeMismatch> getInitializerTypeMismatchFixFactory() {
        return initializerTypeMismatchFixFactory;
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.AssignmentTypeMismatch> getAssignmentTypeMismatchFixFactory() {
        return assignmentTypeMismatchFixFactory;
    }

    private final ConvertClassToKClassFix createFixIfAvailable(KaSession $this$createFixIfAvailable, PsiElement element, KaType expectedType) {
        KtDotQualifiedExpression ktDotQualifiedExpression = element instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)element : null;
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression dotQualifiedExpression = ktDotQualifiedExpression;
        if (!ConvertClassToKClassFixFactoriesKt.isKClass($this$createFixIfAvailable, expectedType)) {
            return null;
        }
        KaType kaType = $this$createFixIfAvailable.getExpressionType((KtExpression)dotQualifiedExpression);
        if (kaType == null) {
            return null;
        }
        KaType expressionType = kaType;
        if (!ConvertClassToKClassFixFactoriesKt.isJavaClass($this$createFixIfAvailable, expressionType)) {
            return null;
        }
        Object[] objectArray = dotQualifiedExpression.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
        Object[] children = objectArray;
        if (children.length != 2) {
            return null;
        }
        Object object = ArraysKt.first((Object[])children);
        KtExpression ktExpression = object instanceof KtExpression ? (KtExpression)object : null;
        if (ktExpression == null) {
            return null;
        }
        KtExpression firstChild = ktExpression;
        KaType kaType2 = $this$createFixIfAvailable.getExpressionType(firstChild);
        if (kaType2 == null) {
            return null;
        }
        KaType firstChildType = kaType2;
        if (!KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$createFixIfAvailable, firstChildType, expectedType, null, 2, null)) {
            return null;
        }
        return new ConvertClassToKClassFix(dotQualifiedExpression);
    }

    private static final List argumentTypeMismatchFixFactory$lambda$0(KaSession $this$ModCommandBased, KaFirDiagnostic.ArgumentTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$ModCommandBased, (String)"$this$ModCommandBased");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($this$ModCommandBased, (PsiElement)diagnostic.getPsi(), diagnostic.getExpectedType())));
    }

    private static final List returnTypeMismatchFixFactory$lambda$0(KaSession $this$ModCommandBased, KaFirDiagnostic.ReturnTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$ModCommandBased, (String)"$this$ModCommandBased");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($this$ModCommandBased, (PsiElement)diagnostic.getPsi(), diagnostic.getExpectedType())));
    }

    private static final List initializerTypeMismatchFixFactory$lambda$0(KaSession $this$ModCommandBased, KaFirDiagnostic.InitializerTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$ModCommandBased, (String)"$this$ModCommandBased");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($this$ModCommandBased, (PsiElement)UtilsKt.getInitializer(diagnostic), diagnostic.getExpectedType())));
    }

    private static final List assignmentTypeMismatchFixFactory$lambda$0(KaSession $this$ModCommandBased, KaFirDiagnostic.AssignmentTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$ModCommandBased, (String)"$this$ModCommandBased");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($this$ModCommandBased, (PsiElement)UtilsKt.getExpression(diagnostic), diagnostic.getExpectedType())));
    }
}

