/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.renderer.types.impl.KaTypeRendererForSource;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixFactory;
import org.jetbrains.kotlin.idea.quickfix.ConvertToIsArrayOfCallFix;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ConvertToIsArrayOfCallFixFactory;", "", "<init>", "()V", "createQuickFix", "Lorg/jetbrains/kotlin/idea/quickfix/ConvertToIsArrayOfCallFix;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "cannotCheckForErased", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$CannotCheckForErased;", "getCannotCheckForErased", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "intellij.kotlin.codeInsight.fixes"})
public final class ConvertToIsArrayOfCallFixFactory {
    @NotNull
    public static final ConvertToIsArrayOfCallFixFactory INSTANCE = new ConvertToIsArrayOfCallFixFactory();
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.CannotCheckForErased> cannotCheckForErased = ConvertToIsArrayOfCallFixFactory::cannotCheckForErased$lambda$0;

    private ConvertToIsArrayOfCallFixFactory() {
    }

    private final ConvertToIsArrayOfCallFix createQuickFix(KaSession $this$createQuickFix, KtIsExpression isExpression, KaType type2) {
        if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)isExpression))) {
            return null;
        }
        KaType kaType = $this$createQuickFix.getArrayElementType(type2);
        if (kaType == null) {
            return null;
        }
        KaType arrayArgumentType = kaType;
        KtExpression ktExpression = isExpression.getLeftHandSide();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"getLeftHandSide(...)");
        KaType kaType2 = $this$createQuickFix.getExpressionType(ktExpression);
        if (kaType2 == null) {
            return null;
        }
        KaType lhsType = kaType2;
        boolean lhsIsNullable = $this$createQuickFix.isMarkedNullable(lhsType);
        boolean lhsIsArray = $this$createQuickFix.isArrayOrPrimitiveArray(lhsType);
        String arrayArgumentTypeText = $this$createQuickFix.render(arrayArgumentType, KaTypeRendererForSource.INSTANCE.getWITH_QUALIFIED_NAMES(), Variance.INVARIANT);
        return new ConvertToIsArrayOfCallFix(isExpression, lhsIsNullable, lhsIsArray, arrayArgumentTypeText);
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.CannotCheckForErased> getCannotCheckForErased() {
        return cannotCheckForErased;
    }

    private static final List cannotCheckForErased$lambda$0(KaSession $this$ModCommandBased, KaFirDiagnostic.CannotCheckForErased diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$ModCommandBased, (String)"$this$ModCommandBased");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = diagnostic.getPsi().getParent();
        KtIsExpression ktIsExpression = psiElement instanceof KtIsExpression ? (KtIsExpression)psiElement : null;
        if (ktIsExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtIsExpression isExpression = ktIsExpression;
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createQuickFix($this$ModCommandBased, isExpression, diagnostic.getType())));
    }
}

