/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixFactory;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/NoReturnValueFactory;", "", "<init>", "()V", "noReturnValue", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$ReturnValueNotUsed;", "getNoReturnValue", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "createQuickFix", "", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/NoReturnValueFactory$UnderscoreValueFix;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "findParentOrOuterMostParentheses", "Lcom/intellij/psi/PsiElement;", "isSuitableParent", "", "UnderscoreValueFix", "intellij.kotlin.codeInsight.fixes"})
public final class NoReturnValueFactory {
    @NotNull
    public static final NoReturnValueFactory INSTANCE = new NoReturnValueFactory();
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ReturnValueNotUsed> noReturnValue = NoReturnValueFactory::noReturnValue$lambda$0;

    private NoReturnValueFactory() {
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ReturnValueNotUsed> getNoReturnValue() {
        return noReturnValue;
    }

    private final List<UnderscoreValueFix> createQuickFix(KtElement element) {
        PsiElement psiElement = this.findParentOrOuterMostParentheses(element);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent = psiElement;
        if (!this.isSuitableParent(parent)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)((Object)new UnderscoreValueFix(element, (SmartPsiElementPointer<PsiElement>)SmartPointersKt.createSmartPointer((PsiElement)parent))));
    }

    private final PsiElement findParentOrOuterMostParentheses(KtElement element) {
        PsiElement parentOfParent;
        PsiElement parent = element.getParent();
        while ((parent instanceof KtParenthesizedExpression || parent instanceof KtBinaryExpression) && ((parentOfParent = ((KtExpressionImpl)parent).getParent()) instanceof KtParenthesizedExpression || parentOfParent instanceof KtBinaryExpression)) {
            parent = parentOfParent;
        }
        return parent;
    }

    private final boolean isSuitableParent(PsiElement element) {
        return element instanceof KtBlockExpression || element instanceof KtParenthesizedExpression || element instanceof KtBinaryExpression || element instanceof KtWhenEntry || element instanceof KtContainerNode;
    }

    private static final List noReturnValue$lambda$0(KaSession $this$ModCommandBased, KaFirDiagnostic.ReturnValueNotUsed diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$ModCommandBased, (String)"$this$ModCommandBased");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return INSTANCE.createQuickFix((KtElement)diagnostic.getPsi());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/NoReturnValueFactory$UnderscoreValueFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "parentPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "buildNewExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "parent", "intellij.kotlin.codeInsight.fixes"})
    @SourceDebugExtension(value={"SMAP\nNoReturnValueFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoReturnValueFactory.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/NoReturnValueFactory$UnderscoreValueFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
    private static final class UnderscoreValueFix
    extends PsiUpdateModCommandAction<KtElement> {
        @NotNull
        private final SmartPsiElementPointer<PsiElement> parentPointer;

        public UnderscoreValueFix(@NotNull KtElement element, @NotNull SmartPsiElementPointer<PsiElement> parentPointer) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(parentPointer, (String)"parentPointer");
            super((PsiElement)element);
            this.parentPointer = parentPointer;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"explicitly.ignore.return.value", (Object[])new Object[0]);
        }

        protected void invoke(@NotNull ActionContext context2, @NotNull KtElement element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            PsiElement psiElement = this.parentPointer.getElement();
            if (psiElement == null) {
                return;
            }
            PsiElement parent = psiElement;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            KtExpression newExpression2 = this.buildNewExpression(factory2, element, parent);
            PsiElement psiElement2 = parent;
            KtElement p0 = psiElement2 instanceof KtParenthesizedExpression || psiElement2 instanceof KtBinaryExpression ? (KtElement)parent : element;
            boolean bl = false;
            KtElement elementToReplace = (KtElement)updater2.getWritable((PsiElement)p0);
            elementToReplace.replace((PsiElement)newExpression2);
        }

        private final KtExpression buildNewExpression(KtPsiFactory factory2, KtElement element, PsiElement parent) {
            KtExpression ktExpression;
            String baseExpressionText = "val _ = " + element.getText();
            PsiElement psiElement = parent;
            if (psiElement instanceof KtBlockExpression) {
                ktExpression = (KtExpression)factory2.createDeclaration(baseExpressionText);
            } else if (psiElement instanceof KtParenthesizedExpression && !(((KtParenthesizedExpression)parent).getParent() instanceof KtContainerNode)) {
                ktExpression = (KtExpression)factory2.createDeclaration("val _ = " + ((KtParenthesizedExpression)parent).getText());
            } else if (psiElement instanceof KtBinaryExpression) {
                ktExpression = (KtExpression)factory2.createDeclaration("val _ = " + ((KtBinaryExpression)parent).getText());
            } else if (psiElement instanceof KtParenthesizedExpression || psiElement instanceof KtWhenEntry || psiElement instanceof KtContainerNode) {
                ktExpression = factory2.createExpression("{" + baseExpressionText + "}");
            } else {
                Object object = parent;
                throw new KotlinExceptionWithAttachments("Unknown parent class: " + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + ".").withPsiAttachment("element.kt", (PsiElement)element).withPsiAttachment("file.kt", (PsiElement)element.getContainingFile());
            }
            KtExpression newExpression2 = ktExpression;
            return newExpression2;
        }
    }
}

