/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.ChangeTypeQuickFixFactoriesKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.PrimitiveLiteralData;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0019\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"valueRanges", "", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lkotlin/ranges/LongRange;", "preparePrimitiveLiteral", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/PrimitiveLiteralData;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "toLong", "", "constValue", "", "(Ljava/lang/Object;)Ljava/lang/Long;", "intellij.kotlin.codeInsight.fixes"})
public final class WrongPrimitiveLiteralFixKt {
    @NotNull
    private static final Map<FqNameUnsafe, LongRange> valueRanges;

    private static final PrimitiveLiteralData preparePrimitiveLiteral(KaSession $this$preparePrimitiveLiteral, KtExpression element, KaType type2) {
        StringBuilder stringBuilder;
        KaClassSymbol kaClassSymbol = $this$preparePrimitiveLiteral.getExpandedSymbol(type2);
        FqNameUnsafe typeName = kaClassSymbol != null && (kaClassSymbol = kaClassSymbol.getClassId()) != null && (kaClassSymbol = kaClassSymbol.asSingleFqName()) != null ? kaClassSymbol.toUnsafe() : null;
        boolean expectedTypeIsFloat = $this$preparePrimitiveLiteral.isFloatType(type2);
        boolean expectedTypeIsDouble = $this$preparePrimitiveLiteral.isDoubleType(type2);
        boolean expectedTypeIsUnsigned = ChangeTypeQuickFixFactoriesKt.isUNumberType($this$preparePrimitiveLiteral, type2);
        KaConstantValue kaConstantValue = $this$preparePrimitiveLiteral.evaluate(element);
        Object constValue = kaConstantValue != null ? kaConstantValue.getValue() : null;
        StringBuilder $this$preparePrimitiveLiteral_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (expectedTypeIsFloat || expectedTypeIsDouble) {
            $this$preparePrimitiveLiteral_u24lambda_u240.append(constValue);
            if (expectedTypeIsFloat) {
                $this$preparePrimitiveLiteral_u24lambda_u240.append('F');
            } else if (!StringsKt.contains$default((CharSequence)$this$preparePrimitiveLiteral_u24lambda_u240, (char)'.', (boolean)false, (int)2, null)) {
                $this$preparePrimitiveLiteral_u24lambda_u240.append(".0");
            }
        } else if (expectedTypeIsUnsigned) {
            $this$preparePrimitiveLiteral_u24lambda_u240.append(constValue);
            $this$preparePrimitiveLiteral_u24lambda_u240.append('u');
        } else {
            if (constValue instanceof Float || constValue instanceof Double) {
                Long l = WrongPrimitiveLiteralFixKt.toLong(constValue);
                Intrinsics.checkNotNull((Object)l);
                v3 = $this$preparePrimitiveLiteral_u24lambda_u240.append(l);
            } else {
                String string = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                char[] cArray = new char[]{'l', 'L', 'u'};
                v3 = $this$preparePrimitiveLiteral_u24lambda_u240.append(StringsKt.trimEnd((String)string, (char[])cArray));
            }
            if ($this$preparePrimitiveLiteral.isLongType(type2)) {
                $this$preparePrimitiveLiteral_u24lambda_u240.append('L');
            }
        }
        String fixedExpression = stringBuilder.toString();
        return new PrimitiveLiteralData(typeName, expectedTypeIsFloat, expectedTypeIsDouble, expectedTypeIsUnsigned, constValue, fixedExpression);
    }

    private static final Long toLong(Object constValue) {
        Object object = constValue;
        return object instanceof Number ? Long.valueOf(((Number)constValue).longValue()) : (object instanceof UByte ? Long.valueOf((long)((UByte)constValue).unbox-impl() & 0xFFL) : (object instanceof UShort ? Long.valueOf((long)((UShort)constValue).unbox-impl() & 0xFFFFL) : (object instanceof UInt ? Long.valueOf((long)((UInt)constValue).unbox-impl() & 0xFFFFFFFFL) : (object instanceof ULong ? Long.valueOf(((ULong)constValue).unbox-impl()) : null))));
    }

    public static final /* synthetic */ PrimitiveLiteralData access$preparePrimitiveLiteral(KaSession $receiver, KtExpression element, KaType type2) {
        return WrongPrimitiveLiteralFixKt.preparePrimitiveLiteral($receiver, element, type2);
    }

    public static final /* synthetic */ Long access$toLong(Object constValue) {
        return WrongPrimitiveLiteralFixKt.toLong(constValue);
    }

    public static final /* synthetic */ Map access$getValueRanges$p() {
        return valueRanges;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardNames.FqNames._byte, (Object)new LongRange(-128L, 127L)), TuplesKt.to((Object)StandardNames.FqNames._short, (Object)new LongRange(-32768L, 32767L)), TuplesKt.to((Object)StandardNames.FqNames._int, (Object)new LongRange(Integer.MIN_VALUE, Integer.MAX_VALUE)), TuplesKt.to((Object)StandardNames.FqNames._long, (Object)new LongRange(Long.MIN_VALUE, Long.MAX_VALUE))};
        valueRanges = MapsKt.mapOf((Pair[])pairArray);
    }
}

