/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.generate;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.template.Template;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.testIntegration.createTest.TestGenerator;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.generate.KotlinGenerateTestSupportActionBase;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u00020\u000bH\u0096\u0080\u0004\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/generate/KotlinTestGenerator;", "Lcom/intellij/testIntegration/createTest/TestGenerator;", "<init>", "()V", "generateTest", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "d", "Lcom/intellij/testIntegration/createTest/CreateTestDialog;", "toString", "", "Companion", "intellij.kotlin.codeInsight"})
@SourceDebugExtension(value={"SMAP\nKotlinTestGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTestGenerator.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/generate/KotlinTestGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class KotlinTestGenerator
implements TestGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public PsiElement generateTest(@NotNull Project project, @NotNull CreateTestDialog d) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return (PsiElement)PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> KotlinTestGenerator.generateTest$lambda$0(project, d));
    }

    @NotNull
    public String toString() {
        return KotlinBundle.message((String)"intention.create.test.dialog.kotlin", (Object[])new Object[0]);
    }

    private static final KtClass generateTest$lambda$0$0(Project $project, CreateTestDialog $d) {
        try {
            String string;
            IdeDocumentHistory.getInstance((Project)$project).includeCurrentPlaceAsChangePlace();
            PsiElement psiElement = KotlinTestGenerator.Companion.createTestClass($d);
            KtClass ktClass = psiElement instanceof KtClass ? (KtClass)psiElement : null;
            if (ktClass == null) {
                return null;
            }
            KtClass targetClass = ktClass;
            TestFramework frameworkDescriptor = $d.getSelectedTestFrameworkDescriptor();
            String defaultSuperClass = frameworkDescriptor.getDefaultSuperClass();
            String it = string = $d.getSuperClassName();
            boolean bl = false;
            String string2 = !Comparing.strEqual((String)it, (String)defaultSuperClass) ? string : null;
            if (string2 != null) {
                String superClassName = string2;
                boolean bl2 = false;
                KotlinTestGenerator.Companion.addSuperClass(targetClass, $project, superClassName);
            }
            PsiFile psiFile = targetClass.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            KtClassBody ktClassBody = targetClass.getBody();
            if (ktClassBody == null || (ktClassBody = ktClassBody.getLBrace()) == null) {
                ktClassBody = (PsiElement)targetClass;
            }
            Editor editor = CodeInsightUtil.positionCursor((Project)$project, (PsiFile)file, (PsiElement)ktClassBody);
            if (editor == null) {
                return null;
            }
            Editor editor2 = editor;
            PsiClass psiClass = $d.getTargetClass();
            Intrinsics.checkNotNull((Object)frameworkDescriptor);
            Collection collection = $d.getSelectedMethods();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelectedMethods(...)");
            Companion.addTestMethods(editor2, targetClass, psiClass, frameworkDescriptor, collection, $d.shouldGeneratedBefore(), $d.shouldGeneratedAfter());
            return targetClass;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            String string = $d.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            KotlinTestGenerator.Companion.showErrorLater($project, string);
            return null;
        }
    }

    private static final PsiElement generateTest$lambda$0(Project $project, CreateTestDialog $d) {
        return (PsiElement)ApplicationUtilsKt.runWriteAction(() -> KotlinTestGenerator.generateTest$lambda$0$0($project, $d));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JH\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0015H\u0002JT\u0010%\u001a\u0004\u0018\u00010&2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010\u00152\u0010\u0010(\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00150)2\b\u0010*\u001a\u0004\u0018\u00010&H\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/generate/KotlinTestGenerator$Companion;", "", "<init>", "()V", "createTestClass", "Lcom/intellij/psi/PsiElement;", "d", "Lcom/intellij/testIntegration/createTest/CreateTestDialog;", "createTestClassFromCodeTemplate", "Lorg/jetbrains/kotlin/psi/KtElement;", "fileTemplateDescriptor", "Lcom/intellij/ide/fileTemplates/FileTemplateDescriptor;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "addSuperClass", "", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "project", "Lcom/intellij/openapi/project/Project;", "superClassName", "", "addTestMethods", "editor", "Lcom/intellij/openapi/editor/Editor;", "sourceClass", "Lcom/intellij/psi/PsiClass;", "descriptor", "Lcom/intellij/testIntegration/TestFramework;", "methods", "", "Lcom/intellij/refactoring/util/classMembers/MemberInfo;", "generateBefore", "", "generateAfter", "showErrorLater", "targetClassName", "generateMethod", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "name", "existingNames", "", "anchor", "intellij.kotlin.codeInsight"})
    @SourceDebugExtension(value={"SMAP\nKotlinTestGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTestGenerator.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/generate/KotlinTestGenerator$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1401#2,2:216\n296#3,2:218\n1391#3:221\n1480#3,5:222\n812#3,12:227\n1#4:220\n*S KotlinDebug\n*F\n+ 1 KotlinTestGenerator.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/generate/KotlinTestGenerator$Companion\n*L\n89#1:216,2\n100#1:218,2\n129#1:221\n129#1:222,5\n171#1:227,12\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiElement createTestClass(CreateTestDialog d) {
            KtFile ktFile2;
            List list2;
            boolean bl;
            TestFramework testFrameworkDescriptor = d.getSelectedTestFrameworkDescriptor();
            FileTemplateDescriptor fileTemplateDescriptor = TestIntegrationUtils.MethodKind.TEST_CLASS.getFileTemplateDescriptor(testFrameworkDescriptor);
            PsiDirectory targetDirectory = d.getTargetDirectory();
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory);
            String className = d.getClassName();
            KtFile targetFile = null;
            if (aPackage != null) {
                Object object;
                block7: {
                    GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((PsiDirectory)targetDirectory, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoryScope(...)");
                    GlobalSearchScope scope = globalSearchScope;
                    PsiFile[] psiFileArray = aPackage.getFiles(scope);
                    Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
                    Object[] $this$firstOrNull$iv = psiFileArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object object2 : $this$firstOrNull$iv) {
                        PsiFile file = (PsiFile)object2;
                        bl = false;
                        if (!(file instanceof KtFile && Intrinsics.areEqual((Object)((KtFile)file).getName(), (Object)(className + ".kt")))) continue;
                        object = object2;
                        break block7;
                    }
                    object = null;
                }
                list2 = object;
                KtFile ktFile3 = targetFile = list2 instanceof KtFile ? (KtFile)list2 : null;
            }
            if (targetFile == null && fileTemplateDescriptor != null) {
                Intrinsics.checkNotNull((Object)targetDirectory);
                KtElement element = this.createTestClassFromCodeTemplate(d, fileTemplateDescriptor, targetDirectory);
                if (element instanceof KtClass) {
                    return (PsiElement)element;
                }
                KtFile ktFile4 = targetFile = element instanceof KtFile ? (KtFile)element : null;
            }
            if ((ktFile2 = targetFile) != null && (list2 = ktFile2.getDeclarations()) != null) {
                Object v5;
                block8: {
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object t : $this$firstOrNull$iv) {
                        KtDeclaration it = (KtDeclaration)t;
                        bl = false;
                        if (!(it instanceof KtClass && Intrinsics.areEqual((Object)((KtClass)it).getName(), (Object)className))) continue;
                        v5 = t;
                        break block8;
                    }
                    v5 = null;
                }
                KtDeclaration ktDeclaration = v5;
                if (ktDeclaration != null) {
                    KtDeclaration it = ktDeclaration;
                    boolean bl2 = false;
                    return (PsiElement)it;
                }
            }
            return null;
        }

        private final KtElement createTestClassFromCodeTemplate(CreateTestDialog d, FileTemplateDescriptor fileTemplateDescriptor, PsiDirectory targetDirectory) {
            KtElement ktElement;
            String string = fileTemplateDescriptor.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String templateName = string;
            Project project = targetDirectory.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project2).getCodeTemplate(templateName);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getCodeTemplate(...)");
            FileTemplate fileTemplate2 = fileTemplate;
            Properties properties = FileTemplateManager.getInstance((Project)project2).getDefaultProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
            Properties defaultProperties = properties;
            Properties properties2 = new Properties(defaultProperties);
            properties2.setProperty("NAME", d.getClassName());
            PsiClass targetClass = d.getTargetClass();
            if (targetClass != null && targetClass.isValid()) {
                properties2.setProperty("CLASS_NAME", targetClass.getQualifiedName());
            }
            String fileName = d.getClassName() + ".kt";
            try {
                PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate2, (String)fileName, (Properties)properties2, (PsiDirectory)targetDirectory);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
                PsiElement createdFromTemplate = psiElement;
                ktElement = createdFromTemplate instanceof KtElement ? (KtElement)createdFromTemplate : null;
            }
            catch (Exception exception) {
                ktElement = null;
            }
            return ktElement;
        }

        /*
         * WARNING - void declaration
         */
        private final void addSuperClass(KtClass targetClass, Project project, String superClassName) {
            void $this$flatMapTo$iv$iv;
            List extendsList = targetClass.getSuperTypeListEntries();
            Iterable $this$flatMap$iv = extendsList;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv$iv;
                boolean bl = false;
                PsiReference[] psiReferenceArray = it.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                Iterable list$iv$iv = ArraysKt.toList((Object[])psiReferenceArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List referenceElements = (List)destination$iv$iv;
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            KtSuperTypeEntry superTypeEntry = psiFactory.createSuperTypeEntry(superClassName);
            if (referenceElements.isEmpty()) {
                KtSuperTypeListEntry superTypeListEntry = targetClass.addSuperTypeListEntry((KtSuperTypeListEntry)superTypeEntry);
                v1 = (PsiElement)ShortenUtilsKt.shortenReferences$default((KtElement)superTypeListEntry, null, null, null, 14, null);
            } else {
                Object e = referenceElements.get(0);
                Intrinsics.checkNotNull(e);
                v1 = ((PsiReference)e).getElement().replace((PsiElement)superTypeEntry);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addTestMethods(@NotNull Editor editor, @NotNull KtClass targetClass, @Nullable PsiClass sourceClass, @NotNull TestFramework descriptor2, @NotNull Collection<? extends MemberInfo> methods, boolean generateBefore, boolean generateAfter) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterator<? extends MemberInfo> iterator2;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            Set existingNames = new HashSet();
            KtNamedFunction anchor = null;
            if (generateBefore && descriptor2.findSetUpMethod((PsiElement)targetClass) == null) {
                PsiFile psiFile = targetClass.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                anchor = KotlinGenerateTestSupportActionBase.Companion.doGenerate$intellij_kotlin_codeInsight(editor, psiFile, (KtClassOrObject)targetClass, descriptor2, TestIntegrationUtils.MethodKind.SET_UP);
            }
            if (generateAfter && descriptor2.findTearDownMethod((PsiElement)targetClass) == null) {
                PsiFile psiFile = targetClass.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                anchor = KotlinGenerateTestSupportActionBase.Companion.doGenerate$intellij_kotlin_codeInsight(editor, psiFile, (KtClassOrObject)targetClass, descriptor2, TestIntegrationUtils.MethodKind.TEAR_DOWN);
            }
            Template template2 = TestIntegrationUtils.createTestMethodTemplate((TestIntegrationUtils.MethodKind)TestIntegrationUtils.MethodKind.TEST, (TestFramework)descriptor2, (PsiElement)((PsiElement)targetClass), (PsiClass)sourceClass, null, (boolean)true, (Set)existingNames);
            try {
                KtPsiFactory ktPsiFactory = KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)((PsiElement)targetClass), (boolean)false, (boolean)false, (int)6, null);
                String string = template2.getTemplateText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTemplateText(...)");
                String string2 = ktPsiFactory.createFunction(string).getName();
                if (string2 == null) {
                    string2 = "";
                }
                iterator2 = string2;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                iterator2 = "";
            }
            String prefix2 = iterator2;
            Iterable iterable = targetClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (KtNamedFunction ktNamedFunction : (List)destination$iv$iv) {
                String name2;
                if (ktNamedFunction.getName() == null) continue;
                existingNames.add(StringUtil.decapitalize((String)StringsKt.removePrefix((String)name2, (CharSequence)prefix2)));
            }
            for (MemberInfo memberInfo : methods) {
                anchor = this.generateMethod(descriptor2, targetClass, sourceClass, editor, ((PsiMember)memberInfo.getMember()).getName(), existingNames, anchor);
            }
        }

        private final void showErrorLater(Project project, String targetClassName) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.showErrorLater$lambda$0(project, targetClassName));
        }

        private final KtNamedFunction generateMethod(TestFramework descriptor2, KtClass targetClass, PsiClass sourceClass, Editor editor, String name2, Set<? super String> existingNames, KtNamedFunction anchor) {
            Project project = targetClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            KtNamedFunction dummyFunction = psiFactory.createFunction("fun dummy() = Unit");
            SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)CollectionsKt.firstOrNull((List)GenerateUtilsKt.insertMembersAfter$default(editor, (KtClassOrObject)targetClass, CollectionsKt.listOf((Object)dummyFunction), (PsiElement)anchor, null, 16, null));
            if (smartPsiElementPointer == null || (smartPsiElementPointer = (KtNamedFunction)smartPsiElementPointer.getElement()) == null) {
                return null;
            }
            SmartPsiElementPointer function = smartPsiElementPointer;
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            KtModifierList ktModifierList = function.getModifierList();
            TestIntegrationUtils.runTestMethodTemplate((TestIntegrationUtils.MethodKind)TestIntegrationUtils.MethodKind.TEST, (TestFramework)descriptor2, (Editor)editor, (PsiElement)((PsiElement)targetClass), (PsiClass)sourceClass, (PsiElement)((PsiElement)function), (PsiElement)((PsiElement)(ktModifierList != null ? (KtElementImplStub)ktModifierList : (KtElementImplStub)function)), (String)name2, (boolean)true, existingNames);
            return function;
        }

        private static final void showErrorLater$lambda$0(Project $project, String $targetClassName) {
            if ($project.isDisposed()) {
                return;
            }
            Object[] objectArray = new Object[]{$targetClassName};
            Messages.showErrorDialog((Project)$project, (String)KotlinBundle.message((String)"intention.error.cannot.create.class.message", (Object[])objectArray), (String)KotlinBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

