/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.hints.compilerPlugins.declaration;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u00020\u0003H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/compilerPlugins/declaration/CodeInlay;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "text", "", "ownAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;)V", "width", "", "getWidth", "()I", "height", "getHeight", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "withAlphaFactor", "Ljava/awt/Color;", "toString", "Companion", "intellij.kotlin.codeInsight"})
final class CodeInlay
extends BasePresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final TextAttributes ownAttributes;
    @NotNull
    private final Editor editor;
    @NotNull
    private final InlayTextMetrics textMetrics;
    public static final double ALPHA_FACTOR = 0.95;

    public CodeInlay(@NotNull String text, @NotNull TextAttributes ownAttributes, @NotNull Editor editor, @NotNull InlayTextMetrics textMetrics) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ownAttributes, (String)"ownAttributes");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textMetrics, (String)"textMetrics");
        this.text = text;
        this.ownAttributes = ownAttributes;
        this.editor = editor;
        this.textMetrics = textMetrics;
    }

    public int getWidth() {
        return this.textMetrics.getStringWidth(this.text);
    }

    public int getHeight() {
        return this.editor.getLineHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        TextAttributes attributesToUse = TextAttributes.merge((TextAttributes)this.ownAttributes, (TextAttributes)attributes);
        Object savedHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            Color color = attributesToUse.getForegroundColor();
            if (color == null) {
                throw new IllegalStateException("ForegroundColor cannot be null".toString());
            }
            Color foreground = color;
            InlayTextMetrics metric = this.textMetrics;
            Font font = metric.getFont();
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)true));
            g.setColor(this.withAlphaFactor(foreground));
            int fontGap = this.editor.getLineHeight() - this.textMetrics.getFontBaseline();
            int yCoordinate = this.editor.getLineHeight() - fontGap / 2;
            g.drawString(this.text, 0, yCoordinate);
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
        }
    }

    private final Color withAlphaFactor(Color $this$withAlphaFactor) {
        return new Color($this$withAlphaFactor.getRed(), $this$withAlphaFactor.getGreen(), $this$withAlphaFactor.getBlue(), (int)((double)$this$withAlphaFactor.getAlpha() * 0.95));
    }

    @NotNull
    public String toString() {
        return this.text;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/compilerPlugins/declaration/CodeInlay$Companion;", "", "<init>", "()V", "ALPHA_FACTOR", "", "intellij.kotlin.codeInsight"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

