/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.imports;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaResolverKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaImplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPackageSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocationKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolOrigin;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.ReferencedSymbolKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.ScopeUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.SymbolInfo;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\f\u001a\u0004\u0018\u00010\rR\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u0012R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0018\u001a\u00020\u0019R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR'\u0010\u0014\u001a\u00020\u00128BX\u0082\u0004b\u00020\u000e\u008a\u0001\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/ReferencedSymbol;", "", "reference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "<init>", "(Lorg/jetbrains/kotlin/idea/references/KtReference;Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;)V", "getReference", "()Lorg/jetbrains/kotlin/idea/references/KtReference;", "getSymbol", "()Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "computeImportableName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/name/FqName;", "isResolvedWithImport", "", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Z", "definitelyNotImported", "getDefinitelyNotImported$annotations", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "getDefinitelyNotImported", "toSymbolInfo", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/SymbolInfo;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/SymbolInfo;", "intellij.kotlin.codeInsight"})
public final class ReferencedSymbol {
    @NotNull
    private final KtReference reference;
    @NotNull
    private final KaSymbol symbol;

    public ReferencedSymbol(@NotNull KtReference reference, @NotNull KaSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.reference = reference;
        this.symbol = symbol;
    }

    @NotNull
    public final KtReference getReference() {
        return this.reference;
    }

    @NotNull
    public final KaSymbol getSymbol() {
        return this.symbol;
    }

    @Nullable
    public final FqName computeImportableName(@NotNull KaSession kaSession) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        return this.toSymbolInfo(kaSession).getImportableName();
    }

    public final boolean isResolvedWithImport(@NotNull KaSession kaSession) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        if (this.getDefinitelyNotImported(kaSession)) {
            return false;
        }
        boolean isNotAliased = CollectionsKt.contains((Iterable)this.reference.getResolvesByNames(), (Object)KaSymbolKt.getName(this.symbol));
        if (isNotAliased && ReferencedSymbolKt.access$isAccessibleAsMemberCallable(kaSession, this.symbol, this.reference.getElement())) {
            return false;
        }
        if (isNotAliased && ScopeUtilsKt.isAccessibleAsMemberClassifier(kaSession, this.symbol, this.reference.getElement())) {
            return false;
        }
        return ReferencedSymbolKt.access$canBeResolvedViaImport(kaSession, this.reference, this.symbol);
    }

    private final boolean getDefinitelyNotImported(KaSession kaSession) {
        return KaResolverKt.getUsesContextSensitiveResolution(kaSession, this.reference) ? true : (KaSymbolLocationKt.isLocal(this.symbol) ? true : (this.symbol.getOrigin() == KaSymbolOrigin.JS_DYNAMIC ? true : (this.symbol instanceof KaPackageSymbol ? true : (this.symbol instanceof KaReceiverParameterSymbol ? true : this.symbol instanceof KaTypeParameterSymbol))));
    }

    private static /* synthetic */ void getDefinitelyNotImported$annotations(KaSession kaSession) {
    }

    @NotNull
    public final SymbolInfo toSymbolInfo(@NotNull KaSession kaSession) {
        SymbolInfo symbolInfo;
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        KaSymbol kaSymbol = this.symbol;
        if (kaSymbol instanceof KaCallableSymbol) {
            KaImplicitReceiverValue dispatcherReceiver;
            KaReceiverValue kaReceiverValue = ReferencedSymbolKt.access$resolveDispatchReceiver(kaSession, this.reference.getElement());
            KaImplicitReceiverValue kaImplicitReceiverValue = dispatcherReceiver = kaReceiverValue instanceof KaImplicitReceiverValue ? (KaImplicitReceiverValue)kaReceiverValue : null;
            KaSymbol kaSymbol2 = kaImplicitReceiverValue != null ? kaImplicitReceiverValue.getSymbol() : null;
            KaClassLikeSymbol containingClassSymbol = kaSymbol2 instanceof KaClassLikeSymbol ? (KaClassLikeSymbol)kaSymbol2 : null;
            symbolInfo = SymbolInfo.Companion.create(kaSession, (KaCallableSymbol)this.symbol, containingClassSymbol);
        } else {
            symbolInfo = kaSymbol instanceof KaClassLikeSymbol ? SymbolInfo.Companion.create(kaSession, (KaClassLikeSymbol)this.symbol) : SymbolInfo.Companion.create(kaSession, this.symbol);
        }
        return symbolInfo;
    }
}

