/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaResolverKt;
import org.jetbrains.kotlin.analysis.api.components.KaTypeProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationCheckerKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.signatures.KaFunctionSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaStarTypeProjection;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.collections.ConvertCallChainIntoSequenceInspectionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConvertLambdaToReferenceUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.StandardKotlinNames;
import org.jetbrains.kotlin.idea.imports.ImportsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.AbstractSimplifiableCallChainInspectionKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.AbstractSimplifiableCallInspectionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0007 !\"#$%&B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u000b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0018\u00010\f*\u00020\u0010H\u0002R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J \u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0003*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Context;", "<init>", "()V", "conversions", "", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "getConversions", "()Ljava/util/List;", "findConversionsAndResolvedCall", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Lkotlin/Pair;", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "prepareContext", "Context", "Conversion", "FlatMapToFlattenConversion", "FilterToFilterNotNullConversion", "MapNotNullToFilterIsInstanceConversion", "FilterToFilterIsInstanceConversion", "SimplifyCallFix", "intellij.kotlin.codeInsight.inspections"})
public abstract class AbstractSimplifiableCallInspection
extends KotlinApplicableInspectionBase.Simple<KtExpression, Context> {
    @NotNull
    protected abstract List<Conversion> getConversions();

    private final Pair<List<Conversion>, KaFunctionCall<?>> findConversionsAndResolvedCall(KaSession kaSession, KtCallExpression $this$findConversionsAndResolvedCall) {
        List list2;
        Object object = $this$findConversionsAndResolvedCall.getCalleeExpression();
        if (object == null || (object = object.getText()) == null) {
            return null;
        }
        Object calleeText = object;
        KaLifetimeOwner kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)$this$findConversionsAndResolvedCall);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull(kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner resolvedCall = kaLifetimeOwner;
        List $this$findConversionsAndResolvedCall_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Conversion conversion : this.getConversions()) {
            if (!Intrinsics.areEqual((Object)conversion.getTargetShortName(), (Object)calleeText)) continue;
            CallableId callableId = ((KaCallableSymbol)KaCallKt.getSymbol((KaCallableMemberCall)resolvedCall)).getCallableId();
            if (!Intrinsics.areEqual((Object)(callableId != null ? callableId.asSingleFqName() : null), (Object)conversion.getTargetFqName())) continue;
            $this$findConversionsAndResolvedCall_u24lambda_u240.add(conversion);
        }
        List possibleConversions = CollectionsKt.build((List)list2);
        return TuplesKt.to((Object)possibleConversions, (Object)resolvedCall);
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[]{context2.getConversionName(), context2.getReplacementCall()};
        return KotlinBundle.message((String)"0.call.could.be.simplified.to.1", (Object[])objectArray);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtExpression> createQuickFix(@NotNull KtExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new SimplifyCallFix(context2);
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.callExpressionVisitor(arg_0 -> AbstractSimplifiableCallInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        Pair<List<Conversion>, KaFunctionCall<?>> pair = this.findConversionsAndResolvedCall($this$prepareContext, callExpression);
        if (pair == null) {
            return null;
        }
        Pair<List<Conversion>, KaFunctionCall<?>> pair2 = pair;
        List conversions = (List)pair2.component1();
        KaFunctionCall resolvedCall = (KaFunctionCall)pair2.component2();
        for (Conversion conversion : conversions) {
            if (!conversion.callChecker($this$prepareContext, resolvedCall)) continue;
            String string = conversion.analyze($this$prepareContext, callExpression);
            if (string == null) continue;
            String replacementCall = string;
            return new Context(conversion.getTargetShortName(), replacementCall, conversion.getReplacementFqName());
        }
        return null;
    }

    private static final Unit buildVisitor$lambda$0(AbstractSimplifiableCallInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        KtExpression ktExpression = callExpression.getCalleeExpression();
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression calleeExpression = ktExpression;
        this$0.visitTargetElement((KtElement)calleeExpression, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Context;", "", "conversionName", "", "replacementCall", "replacementFqName", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "getConversionName", "()Ljava/lang/String;", "getReplacementCall", "getReplacementFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "intellij.kotlin.codeInsight.inspections"})
    public static final class Context {
        @NotNull
        private final String conversionName;
        @NotNull
        private final String replacementCall;
        @NotNull
        private final FqName replacementFqName;

        public Context(@NotNull String conversionName, @NotNull String replacementCall, @NotNull FqName replacementFqName) {
            Intrinsics.checkNotNullParameter((Object)conversionName, (String)"conversionName");
            Intrinsics.checkNotNullParameter((Object)replacementCall, (String)"replacementCall");
            Intrinsics.checkNotNullParameter((Object)replacementFqName, (String)"replacementFqName");
            this.conversionName = conversionName;
            this.replacementCall = replacementCall;
            this.replacementFqName = replacementFqName;
        }

        @NotNull
        public final String getConversionName() {
            return this.conversionName;
        }

        @NotNull
        public final String getReplacementCall() {
            return this.replacementCall;
        }

        @NotNull
        public final FqName getReplacementFqName() {
            return this.replacementFqName;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b$\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H&R\u00020\u000fj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u00020\u000fj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "", "targetFqName", "Lorg/jetbrains/kotlin/name/FqName;", "replacementFqName", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)V", "getTargetFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getReplacementFqName", "targetShortName", "", "getTargetShortName", "()Ljava/lang/String;", "analyze", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "callChecker", "", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;)Z", "intellij.kotlin.codeInsight.inspections"})
    protected static abstract class Conversion {
        @NotNull
        private final FqName targetFqName;
        @NotNull
        private final FqName replacementFqName;
        @NotNull
        private final String targetShortName;

        public Conversion(@NotNull FqName targetFqName, @NotNull FqName replacementFqName) {
            Intrinsics.checkNotNullParameter((Object)targetFqName, (String)"targetFqName");
            Intrinsics.checkNotNullParameter((Object)replacementFqName, (String)"replacementFqName");
            this.targetFqName = targetFqName;
            this.replacementFqName = replacementFqName;
            String string = this.targetFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            this.targetShortName = string;
        }

        @NotNull
        public final FqName getTargetFqName() {
            return this.targetFqName;
        }

        @NotNull
        public final FqName getReplacementFqName() {
            return this.replacementFqName;
        }

        @NotNull
        public final String getTargetShortName() {
            return this.targetShortName;
        }

        @Nullable
        public abstract String analyze(@NotNull KaSession var1, @NotNull KtCallExpression var2);

        public boolean callChecker(@NotNull KaSession kaSession, @NotNull KaFunctionCall<?> resolvedCall) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
            return true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u00020\tj\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ%\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u00020\tj\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$FilterToFilterIsInstanceConversion;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "targetFqName", "Lorg/jetbrains/kotlin/name/FqName;", "replacementFqName", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)V", "analyze", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "callChecker", "", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;)Z", "intellij.kotlin.codeInsight.inspections"})
    @SourceDebugExtension(value={"SMAP\nAbstractSimplifiableCallInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSimplifiableCallInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$FilterToFilterIsInstanceConversion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
    protected static final class FilterToFilterIsInstanceConversion
    extends Conversion {
        public FilterToFilterIsInstanceConversion(@NotNull FqName targetFqName, @NotNull FqName replacementFqName) {
            Intrinsics.checkNotNullParameter((Object)targetFqName, (String)"targetFqName");
            Intrinsics.checkNotNullParameter((Object)replacementFqName, (String)"replacementFqName");
            super(targetFqName, replacementFqName);
        }

        public /* synthetic */ FilterToFilterIsInstanceConversion(FqName fqName2, FqName fqName3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                fqName2 = StandardKotlinNames.Collections.filter;
            }
            if ((n & 2) != 0) {
                fqName3 = StandardKotlinNames.Collections.filterIsInstance;
            }
            this(fqName2, fqName3);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        @Nullable
        public String analyze(@NotNull KaSession var1_1, @NotNull KtCallExpression callExpression) {
            block10: {
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$context-KaSession");
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                v0 = AbstractSimplifiableCallInspectionKt.access$singleLambdaExpression(callExpression);
                if (v0 == null) {
                    return null;
                }
                lambdaExpression = v0;
                v1 = AbstractSimplifiableCallInspectionKt.singleLambdaParameterName(lambdaExpression);
                if (v1 == null) {
                    return null;
                }
                lambdaParameterName = v1;
                v2 = ConvertLambdaToReferenceUtils.INSTANCE.singleStatementOrNull(lambdaExpression);
                if (v2 == null) {
                    return null;
                }
                statement = v2;
                if (!(statement instanceof KtIsExpression)) {
                    return null;
                }
                if (((KtIsExpression)statement).isNegated()) {
                    return null;
                }
                v3 = ((KtIsExpression)statement).getLeftHandSide();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getLeftHandSide(...)");
                if (!AbstractSimplifiableCallInspectionKt.access$isNameReferenceTo(v3, lambdaParameterName)) {
                    return null;
                }
                v4 = ((KtIsExpression)statement).getTypeReference();
                if (v4 == null) {
                    return null;
                }
                rightTypeReference = v4;
                rightType = KaTypeProviderKt.getType(var1_1, rightTypeReference);
                v5 = KaResolverKt.resolveToCall(var1_1, (KtElement)callExpression);
                v6 /* !! */  = resolvedCall = v5 != null ? KaCallInfoKt.successfulFunctionCallOrNull(v5) : null;
                if (resolvedCall == null) break block10;
                var11_9 = ((KaFunctionSignature)resolvedCall.getPartiallyAppliedSymbol().getSignature()).getReturnType();
                v7 = var10_10 = var11_9 instanceof KaClassType != false ? (KaClassType)var11_9 : null;
                if (var10_10 == null || (var11_9 = var10_10.getTypeArguments()) == null || (var12_11 = (KaTypeProjection)CollectionsKt.singleOrNull((List)var11_9)) == null) ** GOTO lbl-1000
                it = var14_12 = var12_11;
                $i$a$-takeIf-AbstractSimplifiableCallInspection$FilterToFilterIsInstanceConversion$analyze$resultingElementType$1 = false;
                v8 = var13_15 = it instanceof KaStarTypeProjection == false != false ? var14_12 : null;
                if (var13_15 != null) {
                    v9 = var13_15.getType();
                } else lbl-1000:
                // 2 sources

                {
                    v9 = resultingElementType = null;
                }
                if (resultingElementType != null && !KaTypeRelationCheckerKt.isSubtypeOf$default(var1_1, rightType, resultingElementType, null, 4, null)) {
                    return null;
                }
            }
            return "filterIsInstance<" + rightTypeReference.getText() + ">()";
        }

        @Override
        public boolean callChecker(@NotNull KaSession kaSession, @NotNull KaFunctionCall<?> resolvedCall) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
            return !AbstractSimplifiableCallChainInspectionKt.isCalledOnMapExtensionReceiver(kaSession, (KaCallableMemberCall)resolvedCall);
        }

        public FilterToFilterIsInstanceConversion() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u00020\tj\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ%\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u00020\tj\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$FilterToFilterNotNullConversion;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "targetFqName", "Lorg/jetbrains/kotlin/name/FqName;", "replacementFqName", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)V", "analyze", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "callChecker", "", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;)Z", "intellij.kotlin.codeInsight.inspections"})
    protected static final class FilterToFilterNotNullConversion
    extends Conversion {
        public FilterToFilterNotNullConversion(@NotNull FqName targetFqName, @NotNull FqName replacementFqName) {
            Intrinsics.checkNotNullParameter((Object)targetFqName, (String)"targetFqName");
            Intrinsics.checkNotNullParameter((Object)replacementFqName, (String)"replacementFqName");
            super(targetFqName, replacementFqName);
        }

        public /* synthetic */ FilterToFilterNotNullConversion(FqName fqName2, FqName fqName3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                fqName2 = StandardKotlinNames.Collections.filter;
            }
            if ((n & 2) != 0) {
                fqName3 = StandardKotlinNames.Collections.filterNotNull;
            }
            this(fqName2, fqName3);
        }

        @Override
        @Nullable
        public String analyze(@NotNull KaSession kaSession, @NotNull KtCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            KtLambdaExpression ktLambdaExpression = AbstractSimplifiableCallInspectionKt.access$singleLambdaExpression(callExpression);
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression lambdaExpression = ktLambdaExpression;
            String string = AbstractSimplifiableCallInspectionKt.singleLambdaParameterName(lambdaExpression);
            if (string == null) {
                return null;
            }
            String lambdaParameterName = string;
            KtExpression ktExpression = ConvertLambdaToReferenceUtils.INSTANCE.singleStatementOrNull(lambdaExpression);
            if (ktExpression == null) {
                return null;
            }
            KtExpression statement = ktExpression;
            if (!(statement instanceof KtBinaryExpression)) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)((KtBinaryExpression)statement).getOperationToken(), (Object)KtTokens.EXCLEQ) && !Intrinsics.areEqual((Object)((KtBinaryExpression)statement).getOperationToken(), (Object)KtTokens.EXCLEQEQEQ)) {
                return null;
            }
            KtExpression ktExpression2 = ((KtBinaryExpression)statement).getLeft();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression left = ktExpression2;
            KtExpression ktExpression3 = ((KtBinaryExpression)statement).getRight();
            if (ktExpression3 == null) {
                return null;
            }
            KtExpression right = ktExpression3;
            if (AbstractSimplifiableCallInspectionKt.access$isNameReferenceTo(left, lambdaParameterName) && AbstractSimplifiableCallInspectionKt.access$isNull(right) || AbstractSimplifiableCallInspectionKt.access$isNameReferenceTo(right, lambdaParameterName) && AbstractSimplifiableCallInspectionKt.access$isNull(left)) {
                return "filterNotNull()";
            }
            return null;
        }

        @Override
        public boolean callChecker(@NotNull KaSession kaSession, @NotNull KaFunctionCall<?> resolvedCall) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
            return !AbstractSimplifiableCallChainInspectionKt.isCalledOnMapExtensionReceiver(kaSession, (KaCallableMemberCall)resolvedCall);
        }

        public FilterToFilterNotNullConversion() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$FlatMapToFlattenConversion;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "<init>", "()V", "analyze", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "intellij.kotlin.codeInsight.inspections"})
    protected static final class FlatMapToFlattenConversion
    extends Conversion {
        public FlatMapToFlattenConversion() {
            super(StandardKotlinNames.Collections.flatMap, StandardKotlinNames.Collections.flatten);
        }

        @Override
        @Nullable
        public String analyze(@NotNull KaSession kaSession, @NotNull KtCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            KtLambdaExpression ktLambdaExpression = AbstractSimplifiableCallInspectionKt.access$singleLambdaExpression(callExpression);
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression lambdaExpression = ktLambdaExpression;
            if (!AbstractSimplifiableCallInspectionKt.isIdentityLambda(lambdaExpression)) {
                return null;
            }
            KaLifetimeOwner kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)callExpression);
            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null || (kaLifetimeOwner = kaLifetimeOwner.getPartiallyAppliedSymbol()) == null) {
                return null;
            }
            KaLifetimeOwner resolvedCallSymbol = kaLifetimeOwner;
            KaReceiverValue kaReceiverValue = resolvedCallSymbol.getDispatchReceiver();
            if (kaReceiverValue == null && (kaReceiverValue = resolvedCallSymbol.getExtensionReceiver()) == null) {
                return null;
            }
            KaReceiverValue receiver2 = kaReceiverValue;
            KaType receiverType = receiver2.getType();
            if (AbstractSimplifiableCallInspectionKt.access$isPrimitiveArray(kaSession, receiverType)) {
                return null;
            }
            KaClassType kaClassType = receiverType instanceof KaClassType ? (KaClassType)receiverType : null;
            List<KaTypeProjection> typeArguments2 = kaClassType != null ? kaClassType.getTypeArguments() : null;
            List<KaTypeProjection> list2 = typeArguments2;
            if (list2 == null || (list2 = (KaTypeProjection)CollectionsKt.singleOrNull(list2)) == null || (list2 = list2.getType()) == null) {
                return null;
            }
            List<KaTypeProjection> receiverTypeArgument = list2;
            if (AbstractSimplifiableCallInspectionKt.access$isArray(kaSession, receiverType) ? !AbstractSimplifiableCallInspectionKt.access$isArray(kaSession, (KaType)((Object)receiverTypeArgument)) : !ConvertCallChainIntoSequenceInspectionKt.isIterable(kaSession, (KaType)((Object)receiverTypeArgument))) {
                return null;
            }
            return "flatten()";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u00020\tj\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ%\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u00020\tj\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$MapNotNullToFilterIsInstanceConversion;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "targetFqName", "Lorg/jetbrains/kotlin/name/FqName;", "replacementFqName", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)V", "analyze", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "callChecker", "", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;)Z", "intellij.kotlin.codeInsight.inspections"})
    protected static final class MapNotNullToFilterIsInstanceConversion
    extends Conversion {
        public MapNotNullToFilterIsInstanceConversion(@NotNull FqName targetFqName, @NotNull FqName replacementFqName) {
            Intrinsics.checkNotNullParameter((Object)targetFqName, (String)"targetFqName");
            Intrinsics.checkNotNullParameter((Object)replacementFqName, (String)"replacementFqName");
            super(targetFqName, replacementFqName);
        }

        public /* synthetic */ MapNotNullToFilterIsInstanceConversion(FqName fqName2, FqName fqName3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                fqName2 = new FqName("kotlin.collections.mapNotNull");
            }
            if ((n & 2) != 0) {
                fqName3 = StandardKotlinNames.Collections.filterIsInstance;
            }
            this(fqName2, fqName3);
        }

        @Override
        @Nullable
        public String analyze(@NotNull KaSession kaSession, @NotNull KtCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            KtLambdaExpression ktLambdaExpression = AbstractSimplifiableCallInspectionKt.access$singleLambdaExpression(callExpression);
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression lambdaExpression = ktLambdaExpression;
            String lambdaParameterName = AbstractSimplifiableCallInspectionKt.singleLambdaParameterName(lambdaExpression);
            KtExpression ktExpression = ConvertLambdaToReferenceUtils.INSTANCE.singleStatementOrNull(lambdaExpression);
            if (ktExpression == null) {
                return null;
            }
            KtExpression statement = ktExpression;
            if (!(statement instanceof KtBinaryExpressionWithTypeRHS)) {
                return null;
            }
            KtExpression ktExpression2 = ((KtBinaryExpressionWithTypeRHS)statement).getLeft();
            KtReferenceExpression ktReferenceExpression = ktExpression2 instanceof KtReferenceExpression ? (KtReferenceExpression)ktExpression2 : null;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression lhs = ktReferenceExpression;
            Object[] objectArray = new String[]{"it", lambdaParameterName};
            if (!CollectionsKt.listOf((Object[])objectArray).contains(lhs.getText())) {
                return null;
            }
            KtTypeReference ktTypeReference = ((KtBinaryExpressionWithTypeRHS)statement).getRight();
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference rightTypeReference = ktTypeReference;
            return "filterIsInstance<" + rightTypeReference.getText() + ">()";
        }

        @Override
        public boolean callChecker(@NotNull KaSession kaSession, @NotNull KaFunctionCall<?> resolvedCall) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
            return !AbstractSimplifiableCallChainInspectionKt.isCalledOnMapExtensionReceiver(kaSession, (KaCallableMemberCall)resolvedCall);
        }

        public MapNotNullToFilterIsInstanceConversion() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$SimplifyCallFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Context;", "<init>", "(Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Context;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Context;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.kotlin.codeInsight.inspections"})
    private static final class SimplifyCallFix
    extends KotlinModCommandQuickFix<KtExpression> {
        @NotNull
        private final Context context;

        public SimplifyCallFix(@NotNull Context context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.context.getConversionName(), this.context.getReplacementCall()};
            return KotlinBundle.message((String)"simplify.call.fix.text", (Object[])objectArray);
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull KtExpression element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtFile ktFile2 = element.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            KtFile containingFile = ktFile2;
            PsiElement psiElement = element.getParent();
            KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression = ktCallExpression;
            callExpression.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression(this.context.getReplacementCall()));
            ImportsKt.addImportFor(containingFile, this.context.getReplacementFqName());
        }
    }
}

