/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J*\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0002JT\u0010\u0018\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001526\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00110\u001aH\u0002JT\u0010\u001f\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u001526\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00110\u001aH\u0002JT\u0010\"\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u001526\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u001c\u0010+\u001a\u00020\u000b*\u00020\u000f2\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010\r\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0003H\u0014J\u0018\u00102\u001a\u0002032\u0006\u0010\r\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0003H\u0014J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020\u0002052\u0006\u0010\r\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0003H\u0014\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AddVarianceModifierInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "Lorg/jetbrains/kotlin/types/Variance;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicableByPsi", "element", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "analyzeConstructorUsage", "", "classSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol;", "typeParameterSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol;", "onContravariantUsage", "Lkotlin/Function0;", "analyzeMemberUsage", "onUsage", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "contravariant", "covariant", "analyzePropertyUsage", "property", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol;", "analyzeFunctionUsage", "function", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "isPublicApi", "visibility", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbolVisibility;", "determineVarianceSuggestion", "contravariantUsage", "covariantUsage", "typeReferencesTypeParameter", "typeParameter", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "getProblemDescription", "", "context", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "AddVarianceFix", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nAddVarianceModifierInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddVarianceModifierInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AddVarianceModifierInspection\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n184#2,2:148\n1342#2,2:152\n1915#3,2:150\n1807#3,3:154\n1807#3,2:157\n1809#3:160\n1#4:159\n*S KotlinDebug\n*F\n+ 1 AddVarianceModifierInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AddVarianceModifierInspection\n*L\n55#1:148,2\n68#1:152,2\n56#1:150,2\n97#1:154,3\n122#1:157,2\n122#1:160\n*E\n"})
public final class AddVarianceModifierInspection
extends KotlinApplicableInspectionBase.Simple<KtTypeParameter, Variance> {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ AddVarianceModifierInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitTypeParameter(KtTypeParameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                AddVarianceModifierInspection.access$visitTargetElement(this.this$0, parameter, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtTypeParameter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getVariance() == Variance.INVARIANT;
    }

    @Override
    @Nullable
    public Variance prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtTypeParameter element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KaSymbol kaSymbol = $this$prepareContext.getContainingSymbol($this$prepareContext.getSymbol(element));
        KaNamedClassSymbol kaNamedClassSymbol = kaSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaSymbol : null;
        if (kaNamedClassSymbol == null) {
            return null;
        }
        KaNamedClassSymbol classSymbol = kaNamedClassSymbol;
        KaTypeParameterSymbol typeParameterSymbol = $this$prepareContext.getSymbol(element);
        Ref.BooleanRef usedInContravariantPosition = new Ref.BooleanRef();
        Ref.BooleanRef usedInCovariantPosition = new Ref.BooleanRef();
        this.analyzeConstructorUsage($this$prepareContext, classSymbol, typeParameterSymbol, (Function0<Unit>)((Function0)() -> AddVarianceModifierInspection.prepareContext$lambda$0(usedInContravariantPosition)));
        this.analyzeMemberUsage($this$prepareContext, classSymbol, typeParameterSymbol, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> AddVarianceModifierInspection.prepareContext$lambda$1(usedInContravariantPosition, usedInCovariantPosition, arg_0, arg_1)));
        return this.determineVarianceSuggestion(usedInContravariantPosition.element, usedInCovariantPosition.element);
    }

    private final void analyzeConstructorUsage(KaSession $this$analyzeConstructorUsage, KaNamedClassSymbol classSymbol, KaTypeParameterSymbol typeParameterSymbol, Function0<Unit> onContravariantUsage) {
        block3: {
            KaConstructorSymbol primaryConstructor;
            Object object;
            Object v0;
            block2: {
                Sequence<KaConstructorSymbol> $this$firstOrNull$iv = $this$analyzeConstructorUsage.getDeclaredMemberScope(classSymbol).getConstructors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KaConstructorSymbol it = (KaConstructorSymbol)element$iv;
                    boolean bl = false;
                    if (!it.isPrimary()) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((object = (primaryConstructor = (KaConstructorSymbol)v0)) == null || (object = ((KaFunctionSymbol)object).getValueParameters()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KaValueParameterSymbol param = (KaValueParameterSymbol)element$iv;
                boolean bl = false;
                if (!this.typeReferencesTypeParameter($this$analyzeConstructorUsage, typeParameterSymbol, param.getReturnType())) continue;
                onContravariantUsage.invoke();
            }
        }
    }

    private final void analyzeMemberUsage(KaSession $this$analyzeMemberUsage, KaNamedClassSymbol classSymbol, KaTypeParameterSymbol typeParameterSymbol, Function2<? super Boolean, ? super Boolean, Unit> onUsage) {
        Sequence<KaCallableSymbol> $this$forEach$iv = $this$analyzeMemberUsage.getDeclaredMemberScope(classSymbol).getCallables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KaCallableSymbol callable = (KaCallableSymbol)element$iv;
            boolean bl = false;
            KaCallableSymbol kaCallableSymbol = callable;
            if (kaCallableSymbol instanceof KaPropertySymbol) {
                this.analyzePropertyUsage($this$analyzeMemberUsage, (KaPropertySymbol)callable, typeParameterSymbol, onUsage);
                continue;
            }
            if (!(kaCallableSymbol instanceof KaFunctionSymbol)) continue;
            this.analyzeFunctionUsage($this$analyzeMemberUsage, (KaFunctionSymbol)callable, typeParameterSymbol, onUsage);
        }
    }

    private final void analyzePropertyUsage(KaSession $this$analyzePropertyUsage, KaPropertySymbol property, KaTypeParameterSymbol typeParameterSymbol, Function2<? super Boolean, ? super Boolean, Unit> onUsage) {
        if (!this.isPublicApi(property.getVisibility())) {
            return;
        }
        if (!this.typeReferencesTypeParameter($this$analyzePropertyUsage, typeParameterSymbol, property.getReturnType())) {
            return;
        }
        boolean isMutable = property.getSetter() != null;
        onUsage.invoke((Object)isMutable, (Object)true);
    }

    private final void analyzeFunctionUsage(KaSession $this$analyzeFunctionUsage, KaFunctionSymbol function, KaTypeParameterSymbol typeParameterSymbol, Function2<? super Boolean, ? super Boolean, Unit> onUsage) {
        boolean usedInParameters;
        boolean usedInReturnType;
        block5: {
            if (!this.isPublicApi(function.getVisibility())) {
                return;
            }
            usedInReturnType = this.typeReferencesTypeParameter($this$analyzeFunctionUsage, typeParameterSymbol, function.getReturnType());
            Iterable $this$any$iv = function.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KaValueParameterSymbol param = (KaValueParameterSymbol)element$iv;
                    boolean bl = false;
                    if (!this.typeReferencesTypeParameter($this$analyzeFunctionUsage, typeParameterSymbol, param.getReturnType())) continue;
                    v0 = true;
                    break block5;
                }
                v0 = usedInParameters = false;
            }
        }
        if (usedInReturnType || usedInParameters) {
            onUsage.invoke((Object)usedInParameters, (Object)usedInReturnType);
        }
    }

    private final boolean isPublicApi(KaSymbolVisibility visibility2) {
        return visibility2 == KaSymbolVisibility.PUBLIC || visibility2 == KaSymbolVisibility.INTERNAL;
    }

    private final Variance determineVarianceSuggestion(boolean contravariantUsage, boolean covariantUsage) {
        return contravariantUsage && covariantUsage ? null : (contravariantUsage ? Variance.IN_VARIANCE : (covariantUsage ? Variance.OUT_VARIANCE : null));
    }

    private final boolean typeReferencesTypeParameter(KaSession $this$typeReferencesTypeParameter, KaTypeParameterSymbol typeParameter, KaType type2) {
        boolean bl;
        block9: {
            KaType kaType = type2;
            if (kaType instanceof KaTypeParameterType) {
                bl = Intrinsics.areEqual((Object)((KaTypeParameterType)type2).getSymbol(), (Object)typeParameter);
            } else if (kaType instanceof KaClassType) {
                Iterable $this$any$iv = ((KaClassType)type2).getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        KaTypeProjection arg = (KaTypeProjection)element$iv;
                        boolean bl3 = false;
                        if (arg.getType() != null) {
                            KaType it;
                            boolean bl4 = false;
                            bl2 = this.typeReferencesTypeParameter($this$typeReferencesTypeParameter, typeParameter, it);
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtTypeParameter element, @NotNull Variance context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[]{context2};
        return KotlinBundle.message((String)"type.parameter.can.have.0.variance", (Object[])objectArray);
    }

    @Override
    @NotNull
    protected ProblemHighlightType getProblemHighlightType(@NotNull KtTypeParameter element, @NotNull Variance context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtTypeParameter> createQuickFix(@NotNull KtTypeParameter element, @NotNull Variance context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new AddVarianceFix(context2);
    }

    private static final Unit prepareContext$lambda$0(Ref.BooleanRef $usedInContravariantPosition) {
        $usedInContravariantPosition.element = true;
        return Unit.INSTANCE;
    }

    private static final Unit prepareContext$lambda$1(Ref.BooleanRef $usedInContravariantPosition, Ref.BooleanRef $usedInCovariantPosition, boolean contravariant, boolean covariant) {
        $usedInContravariantPosition.element = $usedInContravariantPosition.element || contravariant;
        $usedInCovariantPosition.element = $usedInCovariantPosition.element || covariant;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$visitTargetElement(AddVarianceModifierInspection $this, KtTypeParameter element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AddVarianceModifierInspection$AddVarianceFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "<init>", "(Lorg/jetbrains/kotlin/types/Variance;)V", "getVariance", "()Lorg/jetbrains/kotlin/types/Variance;", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.kotlin.codeInsight.inspections"})
    private static final class AddVarianceFix
    extends KotlinModCommandQuickFix<KtTypeParameter> {
        @NotNull
        private final Variance variance;

        public AddVarianceFix(@NotNull Variance variance) {
            Intrinsics.checkNotNullParameter((Object)variance, (String)"variance");
            this.variance = variance;
        }

        @NotNull
        public final Variance getVariance() {
            return this.variance;
        }

        @Override
        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.variance};
            return KotlinBundle.message((String)"add.variance.fix.text", (Object[])objectArray);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"add.variance.fix.family.name", (Object[])new Object[0]);
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull KtTypeParameter element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)element;
            KtModifierKeywordToken ktModifierKeywordToken = this.variance == Variance.IN_VARIANCE ? KtTokens.IN_KEYWORD : KtTokens.OUT_KEYWORD;
            Intrinsics.checkNotNull((Object)ktModifierKeywordToken);
            AddRemoveModifierKt.addModifier((KtModifierListOwner)ktModifierListOwner, (KtModifierKeywordToken)ktModifierKeywordToken);
        }
    }
}

