/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.applicators.ApplicabilityRanges;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorInfo;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorUtils;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithReturnType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/CanBePrimaryConstructorPropertyInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/MovePropertyToConstructorInfo;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getProblemDescription", "", "element", "context", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "isApplicableByPsi", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "intellij.kotlin.codeInsight.inspections"})
public final class CanBePrimaryConstructorPropertyInspection
extends KotlinApplicableInspectionBase.Simple<KtProperty, MovePropertyToConstructorInfo> {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ CanBePrimaryConstructorPropertyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitProperty(KtProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                CanBePrimaryConstructorPropertyInspection.access$visitTargetElement(this.this$0, property, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtProperty element, @NotNull MovePropertyToConstructorInfo context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[1];
        String string = element.getName();
        if (string == null) {
            string = "???";
        }
        objectArray[0] = string;
        return KotlinBundle.message((String)"property.is.explicitly.assigned.to.parameter.0.can", (Object[])objectArray);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ApplicabilityRanges.INSTANCE.declarationName((KtNamedDeclaration)element);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return MovePropertyToConstructorUtils.INSTANCE.isMovableToConstructorByPsi(element);
    }

    @Override
    @Nullable
    public MovePropertyToConstructorInfo prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtProperty element) {
        boolean isMergeableType;
        KaType kaType;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getInitializer();
        if (ktExpression == null) {
            return null;
        }
        KtExpression initializer2 = ktExpression;
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)initializer2));
        KaSymbol kaSymbol = ktReference != null ? $this$prepareContext.resolveToSymbol(ktReference) : null;
        KaValueParameterSymbol kaValueParameterSymbol = kaSymbol instanceof KaValueParameterSymbol ? (KaValueParameterSymbol)kaSymbol : null;
        if (kaValueParameterSymbol == null) {
            return null;
        }
        KaValueParameterSymbol paramSymbol = kaValueParameterSymbol;
        if (!Intrinsics.areEqual((Object)element.getNameAsName(), (Object)paramSymbol.getName())) {
            return null;
        }
        KaType propertyType = $this$prepareContext.getReturnType((KtDeclarationWithReturnType)element);
        boolean bl = paramSymbol.isVararg() ? ((kaType = $this$prepareContext.getArrayElementType(propertyType)) != null ? KaTypeRelationChecker.semanticallyEquals$default($this$prepareContext, kaType, paramSymbol.getReturnType(), null, 2, null) : false) : (isMergeableType = KaTypeRelationChecker.semanticallyEquals$default($this$prepareContext, propertyType, paramSymbol.getReturnType(), null, 2, null));
        if (!isMergeableType) {
            return null;
        }
        return MovePropertyToConstructorInfo.Companion.create$default(MovePropertyToConstructorInfo.Companion, $this$prepareContext, element, null, 4, null);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtProperty> createQuickFix(@NotNull KtProperty element, @NotNull MovePropertyToConstructorInfo context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtProperty>(context2){
            final /* synthetic */ MovePropertyToConstructorInfo $context;
            {
                this.$context = $context;
            }

            public String getFamilyName() {
                return KotlinBundle.message((String)"inspection.can.be.primary.constructor.property.display.name", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtProperty element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                MovePropertyToConstructorUtils.INSTANCE.moveToConstructor(element, this.$context.toWritable(updater2));
            }
        };
    }

    public static final /* synthetic */ void access$visitTargetElement(CanBePrimaryConstructorPropertyInspection $this, KtProperty element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }
}

