/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertPathToExplicitCollectionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "isPlus", "", "<init>", "(Z)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.kotlin.codeInsight.inspections"})
final class ConvertPathToExplicitCollectionFix
extends KotlinModCommandQuickFix<KtExpression>
implements LowPriorityAction {
    private final boolean isPlus;

    public ConvertPathToExplicitCollectionFix(boolean isPlus) {
        this.isPlus = isPlus;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.path.to.explicit.collection", (Object[])new Object[0]);
    }

    @Override
    protected void applyFix(@NotNull Project project, @NotNull KtExpression element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        String functionName = this.isPlus ? "toList" : "toSet";
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        KtExpression ktExpression = element;
        if (ktExpression instanceof KtBinaryExpression) {
            KtExpression ktExpression2 = ((KtBinaryExpression)element).getRight();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression right = ktExpression2;
            Object[] objectArray = new Object[]{right};
            KtExpression newCall2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0." + functionName + "()"), (Object[])objectArray, (boolean)false, (int)4, null);
            right.replace((PsiElement)newCall2);
        } else if (ktExpression instanceof KtCallExpression) {
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)((KtCallExpression)element).getValueArguments());
            if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                return;
            }
            KtValueArgument argument2 = ktValueArgument;
            Object[] objectArray = new Object[]{argument2};
            KtExpression newCall3 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0." + functionName + "()"), (Object[])objectArray, (boolean)false, (int)4, null);
            argument2.replace((PsiElement)newCall3);
        }
    }
}

