/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ScopeFunctionConversionInspectionKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.utils.SyntaxTransformationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0004H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H$J\u001c\u0010\u0014\u001a\u00020\u000b*\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H$R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "counterpartName", "", "<init>", "(Ljava/lang/String;)V", "getCounterpartName", "()Ljava/lang/String;", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "postprocessLambda", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "analyzeLambda", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "replacements", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection;", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nScopeFunctionConversionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionFix\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,570:1\n30#2,2:571\n36#3,15:573\n1#4:588\n73#5:589\n*S KotlinDebug\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionFix\n*L\n181#1:571,2\n181#1:573,15\n218#1:589\n*E\n"})
public abstract class ConvertScopeFunctionFix
extends KotlinModCommandQuickFix<KtNameReferenceExpression> {
    @NotNull
    private final String counterpartName;

    public ConvertScopeFunctionFix(@NotNull String counterpartName) {
        Intrinsics.checkNotNullParameter((Object)counterpartName, (String)"counterpartName");
        this.counterpartName = counterpartName;
    }

    @NotNull
    protected final String getCounterpartName() {
        return this.counterpartName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.counterpartName};
        return KotlinBundle.message((String)"convert.scope.function.fix.family.name", (Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void applyFix(@NotNull Project project, @NotNull KtNameReferenceExpression element, @NotNull ModPsiUpdater updater2) {
        block23: {
            KtLambdaArgument newLambda;
            Object object;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            PsiElement psiElement = element.getParent();
            KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression = ktCallExpression;
            String originalCalleeName = element.getReferencedName();
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)callExpression.getLambdaArguments());
            if (ktLambdaArgument == null) {
                return;
            }
            KtLambdaArgument lambda2 = ktLambdaArgument;
            KtLambdaExpression ktLambdaExpression = lambda2.getLambdaExpression();
            if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null) {
                return;
            }
            KtLambdaExpression functionLiteral = ktLambdaExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            ReplacementCollection replacements = new ReplacementCollection(project);
            KtElement useSiteElement$iv = (KtElement)lambda2;
            boolean $i$f$analyze = false;
            Project project2 = useSiteElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
            KtElement useSiteElement$iv$iv = useSiteElement$iv;
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            try {
                Unit unit;
                Object lock$iv$iv;
                Object object2 = lock$iv$iv = new Object();
                synchronized (object2) {
                    boolean bl = false;
                    KaSession $this$applyFix_u24lambda_u240 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    this.analyzeLambda($this$applyFix_u24lambda_u240, lambda2, replacements);
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable$iv$iv) {
                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                throw new KotlinNothingValueException();
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
            KtParameterList ktParameterList = functionLiteral.getValueParameterList();
            if (ktParameterList != null) {
                ktParameterList.delete();
            }
            PsiElement psiElement2 = functionLiteral.getArrow();
            if (psiElement2 != null) {
                psiElement2.delete();
            }
            if (Intrinsics.areEqual((Object)originalCalleeName, (Object)"with")) {
                if (SyntaxTransformationUtilsKt.applyFromWithConversion(callExpression, element, this.counterpartName, factory2)) {
                    replacements.apply();
                    object = lambda2;
                } else {
                    object = null;
                }
            } else if (Intrinsics.areEqual((Object)this.counterpartName, (Object)"with")) {
                replacements.apply();
                KtCallExpression replacedElement = SyntaxTransformationUtilsKt.applyToWithConversion(element, this.counterpartName, lambda2, factory2);
                Object object3 = replacedElement;
                object = object3 != null && (object3 = object3.getLambdaArguments()) != null ? (KtLambdaArgument)CollectionsKt.firstOrNull((List)object3) : null;
            } else {
                KtExpression ktExpression = factory2.createExpression(this.counterpartName);
                Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
                element.replace((PsiElement)((KtNameReferenceExpression)ktExpression));
                replacements.apply();
                object = lambda2;
            }
            KtLambdaArgument ktLambdaArgument2 = newLambda = object;
            if (ktLambdaArgument2 != null) {
                KtLambdaArgument it = ktLambdaArgument2;
                boolean bl = false;
                this.postprocessLambda(it);
            }
            if (!replacements.isNotEmpty() || replacements.getElementToRename() == null) break block23;
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                PsiElement psiElement3 = replacements.getElementToRename();
                if (psiElement3 != null) {
                    ScopeFunctionConversionInspectionKt.access$startInPlaceRename(psiElement3);
                }
            }
        }
    }

    protected abstract void postprocessLambda(@NotNull KtLambdaArgument var1);

    protected abstract void analyzeLambda(@NotNull KaSession var1, @NotNull KtLambdaArgument var2, @NotNull ReplacementCollection var3);
}

