/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.ShortenOptions;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ConvertScopeFunctionFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ReceiverToParameterVisitor;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.utils.ParameterNameUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.utils.ScopeFunctionUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionToParameter;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionFix;", "counterpartName", "", "<init>", "(Ljava/lang/String;)V", "analyzeLambda", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "replacements", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection;", "postprocessLambda", "intellij.kotlin.codeInsight.inspections"})
public final class ConvertScopeFunctionToParameter
extends ConvertScopeFunctionFix {
    public ConvertScopeFunctionToParameter(@NotNull String counterpartName) {
        Intrinsics.checkNotNullParameter((Object)counterpartName, (String)"counterpartName");
        super(counterpartName);
    }

    @Override
    protected void analyzeLambda(@NotNull KaSession $this$analyzeLambda, @NotNull KtLambdaArgument lambda2, @NotNull ReplacementCollection replacements) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$analyzeLambda, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        Project project = lambda2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        KtLambdaExpression ktLambdaExpression = lambda2.getLambdaExpression();
        KtFunctionLiteral functionLiteral = ktLambdaExpression != null ? ktLambdaExpression.getFunctionLiteral() : null;
        Object object = functionLiteral;
        boolean bl = object != null && (object = object.getValueParameters()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            List list2 = functionLiteral.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            string = ((KtParameter)CollectionsKt.first((List)list2)).getName();
            if (string == null) {
                String string2 = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
            }
        } else if (ScopeFunctionUtilsKt.usesExplicitParameter(this.getCounterpartName()) && ParameterNameUtilsKt.hasImplicitItConflicts($this$analyzeLambda, lambda2)) {
            String uniqueName2 = ParameterNameUtilsKt.findUniqueParameterName($this$analyzeLambda, lambda2);
            replacements.setCreateParameter((Function1<? super KtPsiFactory, ? extends PsiElement>)((Function1)arg_0 -> ConvertScopeFunctionToParameter.analyzeLambda$lambda$0(functionLiteral, uniqueName2, arg_0)));
            string = uniqueName2;
        } else {
            String string3 = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
        }
        String parameterName2 = string;
        ReceiverToParameterVisitor visitor2 = new ReceiverToParameterVisitor(functionLiteral, replacements, parameterName2, factory2, $this$analyzeLambda);
        lambda2.accept((PsiElementVisitor)visitor2);
    }

    @Override
    protected void postprocessLambda(@NotNull KtLambdaArgument lambda2) {
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        ShortenUtilsKt.shortenReferences$default((KtElement)lambda2, new ShortenOptions(false, true), null, null, 12, null);
    }

    private static final PsiElement analyzeLambda$lambda$0(KtFunctionLiteral $functionLiteral, String $uniqueName, KtPsiFactory ktPsiFactory) {
        KtParameter ktParameter;
        Intrinsics.checkNotNullParameter((Object)ktPsiFactory, (String)"<this>");
        KtFunctionLiteral ktFunctionLiteral = $functionLiteral;
        KtParameterList lambdaParameterList = ktFunctionLiteral != null ? KtPsiUtilKt.getOrCreateParameterList((KtFunctionLiteral)ktFunctionLiteral) : null;
        List list2 = ktPsiFactory.createLambdaParameterList($uniqueName).getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        KtParameter parameterToAdd = (KtParameter)CollectionsKt.first((List)list2);
        KtParameterList ktParameterList = lambdaParameterList;
        if (ktParameterList != null) {
            List list3 = lambdaParameterList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getParameters(...)");
            ktParameter = ktParameterList.addParameterBefore(parameterToAdd, (KtParameter)CollectionsKt.firstOrNull((List)list3));
        } else {
            ktParameter = null;
        }
        return (PsiElement)ktParameter;
    }
}

