/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.ShortenOptions;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ConvertScopeFunctionFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ParameterToReceiverVisitor;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.utils.ParameterNameUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.utils.ScopeFunctionUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionToReceiver;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertScopeFunctionFix;", "counterpartName", "", "<init>", "(Ljava/lang/String;)V", "analyzeLambda", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "replacements", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection;", "postprocessLambda", "intellij.kotlin.codeInsight.inspections"})
public final class ConvertScopeFunctionToReceiver
extends ConvertScopeFunctionFix {
    public ConvertScopeFunctionToReceiver(@NotNull String counterpartName) {
        Intrinsics.checkNotNullParameter((Object)counterpartName, (String)"counterpartName");
        super(counterpartName);
    }

    @Override
    protected void analyzeLambda(@NotNull KaSession $this$analyzeLambda, @NotNull KtLambdaArgument lambda2, @NotNull ReplacementCollection replacements) {
        Intrinsics.checkNotNullParameter((Object)$this$analyzeLambda, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        if (ScopeFunctionUtilsKt.usesExplicitParameter(this.getCounterpartName()) && ParameterNameUtilsKt.hasImplicitItConflicts($this$analyzeLambda, lambda2)) {
            ParameterNameUtilsKt.findUniqueParameterName($this$analyzeLambda, lambda2);
        } else {
            String string = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier();
            Intrinsics.checkNotNull((Object)string);
        }
        KtLambdaExpression ktLambdaExpression = lambda2.getLambdaExpression();
        KtFunctionLiteral functionLiteral = ktLambdaExpression != null ? ktLambdaExpression.getFunctionLiteral() : null;
        ParameterToReceiverVisitor visitor2 = new ParameterToReceiverVisitor(functionLiteral, replacements, $this$analyzeLambda);
        lambda2.accept((PsiElementVisitor)visitor2);
    }

    @Override
    protected void postprocessLambda(@NotNull KtLambdaArgument lambda2) {
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        ShortenUtilsKt.shortenReferences$default((KtElement)lambda2, new ShortenOptions(true, true), null, null, 12, null);
    }
}

