/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Iterator;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.ArgumentNameCommentInfo;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.JavaArgumentNameCommentUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/InconsistentCommentForJavaParameterInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "CorrectNamesInCommentsToJavaCallArgumentsFix", "intellij.kotlin.codeInsight.inspections"})
public final class InconsistentCommentForJavaParameterInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder2){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitCallExpression(KtCallExpression callExpression) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                this.check((KtCallElement)callExpression);
            }

            public void visitSuperTypeCallEntry(KtSuperTypeCallEntry call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.check((KtCallElement)call);
            }

            public void visitConstructorDelegationCall(KtConstructorDelegationCall call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.check((KtCallElement)call);
            }

            public void visitAnnotationEntry(KtAnnotationEntry annotationEntry) {
                Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
                this.check((KtCallElement)annotationEntry);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final void check(KtCallElement $this$check) {
                void this_$iv$iv;
                void useSiteElement$iv;
                if (!JavaArgumentNameCommentUtilsKt.hasArgumentNameComments($this$check)) {
                    return;
                }
                KtElement ktElement = (KtElement)$this$check;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                void useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)useSiteElement$iv$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        Map<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> map2;
                        Map<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> expectedNameComments;
                        block12: {
                            boolean bl = false;
                            KaSession $this$check_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (JavaArgumentNameCommentUtilsKt.getArgumentNameComments($this$check_u24lambda_u240, $this$check) != null) break block12;
                            return;
                        }
                        Map<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> $this$forEach$iv = expectedNameComments = map2;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo>> iterator2 = $this$forEach$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            KtValueArgument actualComment;
                            Map.Entry<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> element$iv;
                            Map.Entry<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> entry = element$iv = iterator2.next();
                            boolean bl = false;
                            SmartPsiElementPointer<KtValueArgument> argumentPointer = entry.getKey();
                            ArgumentNameCommentInfo expected = entry.getValue();
                            KtValueArgument ktValueArgument = (KtValueArgument)argumentPointer.getElement();
                            if (ktValueArgument == null) continue;
                            if ((ktValueArgument = JavaArgumentNameCommentUtilsKt.getBlockCommentWithName(ktValueArgument)) == null || JavaArgumentNameCommentUtilsKt.isExpectedArgumentNameComment((PsiComment)(actualComment = ktValueArgument), expected)) continue;
                            PsiElement psiElement = (PsiElement)actualComment;
                            Object[] objectArray = new Object[1];
                            Intrinsics.checkNotNullExpressionValue((Object)expected.getArgumentName().asString(), (String)"asString(...)");
                            String string = KotlinBundle.message((String)"inspection.message.inconsistent.parameter.name.for.0", (Object[])objectArray);
                            objectArray = new LocalQuickFix[]{new CorrectNamesInCommentsToJavaCallArgumentsFix(expected.getComment())};
                            problemsHolder.registerProblem(psiElement, string, (LocalQuickFix[])objectArray);
                        }
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                }
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/InconsistentCommentForJavaParameterInspection$CorrectNamesInCommentsToJavaCallArgumentsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "commentedParameterName", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.kotlin.codeInsight.inspections"})
    private static final class CorrectNamesInCommentsToJavaCallArgumentsFix
    implements LocalQuickFix {
        @NotNull
        private final String commentedParameterName;

        public CorrectNamesInCommentsToJavaCallArgumentsFix(@NotNull String commentedParameterName) {
            Intrinsics.checkNotNullParameter((Object)commentedParameterName, (String)"commentedParameterName");
            this.commentedParameterName = commentedParameterName;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"intention.name.use.correct.parameter.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            PsiComment psiComment = psiElement instanceof PsiComment ? (PsiComment)psiElement : null;
            if (psiComment == null) {
                return;
            }
            PsiComment comment = psiComment;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            comment.replace((PsiElement)factory2.createComment(this.commentedParameterName));
        }
    }
}

