/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u00152\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0016J#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/MoveLambdaOutsideParenthesesInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "", "<init>", "()V", "getProblemDescription", "", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/Unit;)Ljava/lang/String;", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/Unit;)Lcom/intellij/codeInspection/ProblemHighlightType;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Lkotlin/Unit;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "intellij.kotlin.codeInsight.inspections"})
public final class MoveLambdaOutsideParenthesesInspection
extends KotlinApplicableInspectionBase.Simple<KtCallExpression, Unit> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtCallExpression element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[]{KotlinCommonRefactoringUtilKt.isComplexCallWithLambdaArgument(element) ? 0 : 1};
        return KotlinBundle.message((String)"lambda.argument.0.be.moved.out", (Object[])objectArray);
    }

    @Override
    @NotNull
    protected ProblemHighlightType getProblemHighlightType(@NotNull KtCallExpression element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinCommonRefactoringUtilKt.isComplexCallWithLambdaArgument(element) ? ProblemHighlightType.INFORMATION : super.getProblemHighlightType((KtElement)element, context2);
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ MoveLambdaOutsideParenthesesInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitCallExpression(KtCallExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                MoveLambdaOutsideParenthesesInspection.access$visitTargetElement(this.this$0, expression, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return !KotlinCommonRefactoringUtilKt.canMoveLambdaOutsideParentheses($this$prepareContext, element, false) ? null : Unit.INSTANCE;
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtCallExpression> createQuickFix(@NotNull KtCallExpression element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtCallExpression>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"move.lambda.argument.out.of.parentheses", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtCallExpression element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses(element, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)updater2){

                    public final void invoke(int p0) {
                        ((ModPsiUpdater)this.receiver).moveCaretTo(p0);
                    }
                }));
            }
        };
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtLambdaExpression ktLambdaExpression = KotlinCommonRefactoringUtilKt.getLastLambdaExpression(element);
        TextRange textRange = ktLambdaExpression != null && (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) != null && (ktLambdaExpression = ktLambdaExpression.getLBrace()) != null ? TextRangeUtilsKt.textRangeIn((PsiElement)ktLambdaExpression, (PsiElement)element) : null;
        return CollectionsKt.listOfNotNull(textRange);
    }

    public static final /* synthetic */ void access$visitTargetElement(MoveLambdaOutsideParenthesesInspection $this, KtCallExpression element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }
}

