/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.utils.ScopeFunctionUtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReceiverToParameterVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "replacements", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection;", "parameterName", "", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtPsiFactory;Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nScopeFunctionConversionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReceiverToParameterVisitor\n+ 2 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,570:1\n99#2:571\n1#3:572\n*S KotlinDebug\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReceiverToParameterVisitor\n*L\n267#1:571\n*E\n"})
final class ReceiverToParameterVisitor
extends KtTreeVisitorVoid {
    @Nullable
    private final KtFunctionLiteral functionLiteral;
    @NotNull
    private final ReplacementCollection replacements;
    @NotNull
    private final String parameterName;
    @NotNull
    private final KtPsiFactory factory;
    @NotNull
    private final KaSession session;

    public ReceiverToParameterVisitor(@Nullable KtFunctionLiteral functionLiteral, @NotNull ReplacementCollection replacements, @NotNull String parameterName2, @NotNull KtPsiFactory factory2, @NotNull KaSession session2) {
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.functionLiteral = functionLiteral;
        this.replacements = replacements;
        this.parameterName = parameterName2;
        this.factory = factory2;
        this.session = session2;
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        block13: {
            PsiElement parent;
            block12: {
                KaCallableMemberCall kaCallableMemberCall;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitSimpleNameExpression(expression);
                if (expression instanceof KtOperationReferenceExpression) {
                    return;
                }
                KaSession $this$visitSimpleNameExpression_u24lambda_u240 = this.session;
                boolean bl = false;
                KaCallInfo kaCallInfo = $this$visitSimpleNameExpression_u24lambda_u240.resolveToCall((KtElement)expression);
                if (kaCallInfo != null) {
                    KaCallInfo $this$successfulCallOrNull$iv = kaCallInfo;
                    boolean $i$f$successfulCallOrNull = false;
                    KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                    KaCall kaCall = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
                    if (!(kaCall instanceof KaCallableMemberCall)) {
                        kaCall = null;
                    }
                    kaCallableMemberCall = (KaCallableMemberCall)((KaCall)((KaCallableMemberCall)kaCall));
                } else {
                    kaCallableMemberCall = null;
                }
                if (kaCallableMemberCall == null) {
                    return;
                }
                KaCallableMemberCall resolvedCall = kaCallableMemberCall;
                KaReceiverValue dispatchReceiver = resolvedCall.getPartiallyAppliedSymbol().getDispatchReceiver();
                KaReceiverValue extensionReceiver = resolvedCall.getPartiallyAppliedSymbol().getExtensionReceiver();
                KaSession $this$visitSimpleNameExpression_u24lambda_u241 = this.session;
                boolean bl2 = false;
                if (ScopeFunctionUtilsKt.isReceiverFromFunctionLiteral($this$visitSimpleNameExpression_u24lambda_u241, dispatchReceiver, this.functionLiteral)) break block12;
                KaSession $this$visitSimpleNameExpression_u24lambda_u242 = this.session;
                boolean bl3 = false;
                if (!ScopeFunctionUtilsKt.isReceiverFromFunctionLiteral($this$visitSimpleNameExpression_u24lambda_u242, extensionReceiver, this.functionLiteral)) break block13;
            }
            if ((parent = expression.getParent()) instanceof KtCallExpression && Intrinsics.areEqual((Object)expression, (Object)((KtCallExpression)parent).getCalleeExpression())) {
                PsiElement psiElement = ((KtCallExpression)parent).getParent();
                KtQualifiedExpression ktQualifiedExpression = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
                if (!((ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null) instanceof KtThisExpression)) {
                    this.replacements.add(parent, (arg_0, arg_1) -> ReceiverToParameterVisitor.visitSimpleNameExpression$lambda$3(this, arg_0, arg_1));
                }
            } else if (!(parent instanceof KtQualifiedExpression) || !(((KtQualifiedExpression)parent).getReceiverExpression() instanceof KtThisExpression)) {
                String referencedName = expression.getReferencedName();
                this.replacements.add((PsiElement)expression, (arg_0, arg_1) -> ReceiverToParameterVisitor.visitSimpleNameExpression$lambda$4(this, referencedName, arg_0, arg_1));
            }
        }
    }

    public void visitThisExpression(@NotNull KtThisExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtReferenceExpression ktReferenceExpression = expression.getInstanceReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"getInstanceReference(...)");
        if (Intrinsics.areEqual((Object)ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression).resolve(), (Object)this.functionLiteral)) {
            this.replacements.add((PsiElement)expression, (arg_0, arg_1) -> ReceiverToParameterVisitor.visitThisExpression$lambda$0(this, arg_0, arg_1));
        }
    }

    private static final PsiElement visitSimpleNameExpression$lambda$3(ReceiverToParameterVisitor this$0, KtPsiFactory $this$add, KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[]{this$0.parameterName, element};
        return (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)this$0.factory, (String)"$0.$1", (Object[])objectArray, (boolean)false, (int)4, null);
    }

    private static final PsiElement visitSimpleNameExpression$lambda$4(ReceiverToParameterVisitor this$0, String $referencedName, KtPsiFactory $this$add, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PsiElement)$this$add.createExpression(this$0.parameterName + "." + $referencedName);
    }

    private static final PsiElement visitThisExpression$lambda$0(ReceiverToParameterVisitor this$0, KtPsiFactory $this$add, KtThisExpression it) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PsiElement)$this$add.createExpression(this$0.parameterName);
    }
}

