/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.KotlinInlineAnonymousFunctionProcessor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantLambdaOrAnonymousFunctionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "", "<init>", "()V", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lkotlin/Unit;)Ljava/lang/String;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isApplicableByPsi", "", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "RedundantLambdaOrAnonymousFunctionFix", "intellij.kotlin.codeInsight.inspections"})
public final class RedundantLambdaOrAnonymousFunctionInspection
extends KotlinApplicableInspectionBase.Simple<KtFunction, Unit> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtFunction element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return element instanceof KtNamedFunction ? KotlinBundle.message((String)"inspection.redundant.anonymous.function.description", (Object[])new Object[0]) : KotlinBundle.message((String)"inspection.redundant.lambda.description", (Object[])new Object[0]);
    }

    @Override
    public void prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtFunction element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtFunction element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.hasBody() && KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(element) != null;
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ RedundantLambdaOrAnonymousFunctionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitLambdaExpression(KtLambdaExpression lambdaExpression) {
                Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
                KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
                RedundantLambdaOrAnonymousFunctionInspection.access$visitTargetElement(this.this$0, (KtFunction)ktFunctionLiteral, this.$holder, this.$isOnTheFly);
            }

            public void visitNamedFunction(KtNamedFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                RedundantLambdaOrAnonymousFunctionInspection.access$visitTargetElement(this.this$0, (KtFunction)function, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtFunction> createQuickFix(@NotNull KtFunction element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new RedundantLambdaOrAnonymousFunctionFix();
    }

    public static final /* synthetic */ void access$visitTargetElement(RedundantLambdaOrAnonymousFunctionInspection $this, KtFunction element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantLambdaOrAnonymousFunctionInspection$RedundantLambdaOrAnonymousFunctionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.kotlin.codeInsight.inspections"})
    private static final class RedundantLambdaOrAnonymousFunctionFix
    extends KotlinModCommandQuickFix<KtFunction> {
        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"inspection.redundant.lambda.or.anonymous.function.fix", (Object[])new Object[0]);
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull KtFunction element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtExpression ktExpression = KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(element);
            if (ktExpression == null) {
                return;
            }
            KtExpression call = ktExpression;
            KotlinInlineAnonymousFunctionProcessor.Companion.performRefactoring(call, EditorUtilsKt.findExistingEditor((PsiElement)element));
        }
    }
}

