/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.RemoveRedundantSpreadOperatorInspectionKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RemoveRedundantSpreadOperatorInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtValueArgument;Lkotlin/Unit;)Ljava/lang/String;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtValueArgument;)Lkotlin/Unit;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtValueArgument;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nRemoveRedundantSpreadOperatorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveRedundantSpreadOperatorInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RemoveRedundantSpreadOperatorInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ContextProvider.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicable/ContextProviderKt\n*L\n1#1,124:1\n249#2:125\n363#3,7:126\n48#4:133\n*S KotlinDebug\n*F\n+ 1 RemoveRedundantSpreadOperatorInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RemoveRedundantSpreadOperatorInspection\n*L\n58#1:125\n59#1:126,7\n76#1:133\n*E\n"})
public final class RemoveRedundantSpreadOperatorInspection
extends KotlinApplicableInspectionBase.Simple<KtValueArgument, Unit> {
    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.valueArgumentVisitor(arg_0 -> RemoveRedundantSpreadOperatorInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtValueArgument element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"remove.redundant.spread.operator.quickfix.text", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtValueArgument element) {
        int n;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        LeafPsiElement leafPsiElement = element.getSpreadElement();
        if (leafPsiElement == null) {
            return CollectionsKt.emptyList();
        }
        LeafPsiElement spreadElement = leafPsiElement;
        if (element.isNamed()) {
            return CollectionsKt.emptyList();
        }
        KtExpression ktExpression = element.getArgumentExpression();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression argumentExpression = ktExpression;
        int argumentOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
        int startOffset = spreadElement.getStartOffset() - argumentOffset;
        KtExpression ktExpression2 = argumentExpression;
        if (ktExpression2 instanceof KtCallExpression) {
            KtExpression ktExpression3 = ((KtCallExpression)argumentExpression).getCalleeExpression();
            Intrinsics.checkNotNull((Object)ktExpression3);
            n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktExpression3)) - argumentOffset;
        } else if (ktExpression2 instanceof KtCollectionLiteralExpression) {
            n = startOffset + 1;
        } else {
            return CollectionsKt.emptyList();
        }
        int endOffset = n;
        return CollectionsKt.listOf((Object)new TextRange(startOffset, endOffset));
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtValueArgument element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression argumentExpression = element.getArgumentExpression();
        if (argumentExpression instanceof KtCallExpression) {
            int n;
            KtCallExpression call;
            block11: {
                if (!AnalysisUtilsKt.isArrayOfFunction($this$prepareContext, (KtCallExpression)argumentExpression)) {
                    return null;
                }
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
                boolean $i$f$getStrictParentOfType = false;
                KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
                if (ktCallExpression == null) {
                    return null;
                }
                call = ktCallExpression;
                List $this$indexOfFirst$iv = call.getValueArguments();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    KtValueArgument it = (KtValueArgument)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)element)) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int argumentIndex = n;
            PsiElement index$iv = call.copy();
            KtCallExpression ktCallExpression = index$iv instanceof KtCallExpression ? (KtCallExpression)index$iv : null;
            if (ktCallExpression == null || (ktCallExpression = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktCallExpression))) == null) {
                return null;
            }
            KtCallExpression callCopyPointer = ktCallExpression;
            Object object = (KtCallExpression)callCopyPointer.getElement();
            if (object == null || (object = object.getValueArgumentList()) == null || (object = object.getArguments()) == null || (object = (KtValueArgument)CollectionsKt.getOrNull((List)object, (int)argumentIndex)) == null) {
                return null;
            }
            Object elementCopy = object;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RemoveRedundantSpreadOperatorInspectionKt.access$removeRedundantSpreadOperator(project, (KtValueArgument)elementCopy);
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, 2, null);
            KtCallExpression ktCallExpression2 = (KtCallExpression)callCopyPointer.getElement();
            if (ktCallExpression2 == null) {
                return null;
            }
            String string = ktCallExpression2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            KtExpression ktExpression = ktPsiFactory.createExpressionCodeFragment(string, (PsiElement)element).getContentElement();
            KtCallExpression ktCallExpression3 = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (ktCallExpression3 == null) {
                return null;
            }
            KtCallExpression newCall2 = ktCallExpression3;
            PsiElement psiElement = RemoveRedundantSpreadOperatorInspectionKt.access$resolveCallToPsiElement((KtExpression)call);
            if (psiElement == null) {
                return null;
            }
            PsiElement oldTarget = psiElement;
            bl = Intrinsics.areEqual((Object)oldTarget, (Object)RemoveRedundantSpreadOperatorInspectionKt.access$resolveCallToPsiElement((KtExpression)newCall2));
        } else {
            bl = argumentExpression instanceof KtCollectionLiteralExpression;
        }
        boolean $this$asUnit$iv = bl;
        boolean $i$f$getAsUnit = false;
        return $this$asUnit$iv ? Unit.INSTANCE : null;
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtValueArgument> createQuickFix(@NotNull KtValueArgument element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtValueArgument>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"remove.redundant.spread.operator.quickfix.text", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtValueArgument element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                RemoveRedundantSpreadOperatorInspectionKt.access$removeRedundantSpreadOperator(project, element);
            }
        };
    }

    private static final Unit buildVisitor$lambda$0(RemoveRedundantSpreadOperatorInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtValueArgument it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }
}

