/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections.coroutines;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaResolverKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines.CoroutinesIds;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.AbstractSimplifiableCallInspection;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.AbstractSimplifiableCallInspectionKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.coroutines.SimplifiableFlowCallInspectionKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/coroutines/SimplifiableFlowCallInspection;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection;", "<init>", "()V", "conversions", "", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "getConversions", "()Ljava/util/List;", "FlowFlatMapToFlattenConversion", "intellij.kotlin.codeInsight.inspections"})
public final class SimplifiableFlowCallInspection
extends AbstractSimplifiableCallInspection {
    @Override
    @NotNull
    protected List<AbstractSimplifiableCallInspection.Conversion> getConversions() {
        Object[] objectArray = new AbstractSimplifiableCallInspection.Conversion[]{new FlowFlatMapToFlattenConversion(CoroutinesIds.Flows.INSTANCE.getFlatMapMerge(), CoroutinesIds.Flows.INSTANCE.getFlattenMerge()), new FlowFlatMapToFlattenConversion(CoroutinesIds.Flows.INSTANCE.getFlatMapConcat(), CoroutinesIds.Flows.INSTANCE.getFlattenConcat()), new AbstractSimplifiableCallInspection.FilterToFilterNotNullConversion(CoroutinesIds.Flows.INSTANCE.getFilter().asSingleFqName(), CoroutinesIds.Flows.INSTANCE.getFilterNotNull().asSingleFqName()), new AbstractSimplifiableCallInspection.FilterToFilterIsInstanceConversion(CoroutinesIds.Flows.INSTANCE.getFilter().asSingleFqName(), CoroutinesIds.Flows.INSTANCE.getFilterIsInstance().asSingleFqName())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u00020\tj\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/coroutines/SimplifiableFlowCallInspection$FlowFlatMapToFlattenConversion;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/AbstractSimplifiableCallInspection$Conversion;", "targetFqName", "Lorg/jetbrains/kotlin/name/CallableId;", "replacementFqName", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;Lorg/jetbrains/kotlin/name/CallableId;)V", "analyze", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "intellij.kotlin.codeInsight.inspections"})
    private static final class FlowFlatMapToFlattenConversion
    extends AbstractSimplifiableCallInspection.Conversion {
        public FlowFlatMapToFlattenConversion(@NotNull CallableId targetFqName, @NotNull CallableId replacementFqName) {
            Intrinsics.checkNotNullParameter((Object)targetFqName, (String)"targetFqName");
            Intrinsics.checkNotNullParameter((Object)replacementFqName, (String)"replacementFqName");
            super(targetFqName.asSingleFqName(), replacementFqName.asSingleFqName());
        }

        @Override
        @Nullable
        public String analyze(@NotNull KaSession kaSession, @NotNull KtCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            KaLifetimeOwner kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)callExpression);
            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull(kaLifetimeOwner)) == null) {
                return null;
            }
            KaLifetimeOwner functionCall = kaLifetimeOwner;
            KtExpression ktExpression = SimplifiableFlowCallInspectionKt.access$findArgumentExpressionByParameterName((KaFunctionCall)functionCall, CoroutinesIds.ParameterNames.INSTANCE.getTransform());
            KtLambdaExpression ktLambdaExpression = ktExpression instanceof KtLambdaExpression ? (KtLambdaExpression)ktExpression : null;
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression transformArgument = ktLambdaExpression;
            if (!AbstractSimplifiableCallInspectionKt.isIdentityLambda(transformArgument)) {
                return null;
            }
            KtExpression ktExpression2 = SimplifiableFlowCallInspectionKt.access$findArgumentExpressionByParameterName((KaFunctionCall)functionCall, CoroutinesIds.ParameterNames.INSTANCE.getConcurrency());
            ktExpression = ktExpression2 != null ? ktExpression2.getParent() : null;
            KtValueArgument concurrencyValueArgument = ktExpression instanceof KtValueArgument ? (KtValueArgument)ktExpression : null;
            Name name2 = this.getReplacementFqName().shortName();
            KtValueArgument ktValueArgument = concurrencyValueArgument;
            String string = ktValueArgument != null ? ktValueArgument.getText() : null;
            if (string == null) {
                string = "";
            }
            return name2 + "(" + string + ")";
        }
    }
}

