/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections.utils;

import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaExplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaImplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.k2.refactoring.UtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a \u0010\u0013\u001a\u00020\r*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0019"}, d2={"counterpartNames", "", "", "", "getCounterpartNames", "()Ljava/util/Map;", "implicitThisFunctions", "", "getImplicitThisFunctions", "()Ljava/util/Set;", "explicitParameterFunctions", "getExplicitParameterFunctions", "usesImplicitThis", "", "functionName", "usesExplicitParameter", "isSimpleLambdaParameterCase", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isReceiverFromFunctionLiteral", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "receiver", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "intellij.kotlin.codeInsight.inspections"})
public final class ScopeFunctionUtilsKt {
    @NotNull
    private static final Map<String, Object> counterpartNames;
    @NotNull
    private static final Set<String> implicitThisFunctions;
    @NotNull
    private static final Set<String> explicitParameterFunctions;

    @NotNull
    public static final Map<String, Object> getCounterpartNames() {
        return counterpartNames;
    }

    @NotNull
    public static final Set<String> getImplicitThisFunctions() {
        return implicitThisFunctions;
    }

    @NotNull
    public static final Set<String> getExplicitParameterFunctions() {
        return explicitParameterFunctions;
    }

    public static final boolean usesImplicitThis(@NotNull String functionName) {
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        return implicitThisFunctions.contains(functionName);
    }

    public static final boolean usesExplicitParameter(@NotNull String functionName) {
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        return explicitParameterFunctions.contains(functionName);
    }

    public static final boolean isSimpleLambdaParameterCase(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        List list2 = lambdaExpression.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        List parameters2 = list2;
        if (parameters2.size() != 1) {
            return false;
        }
        KtParameter parameter = (KtParameter)CollectionsKt.first((List)parameters2);
        if (parameter.getDestructuringDeclaration() != null) {
            return false;
        }
        KtBlockExpression ktBlockExpression = lambdaExpression.getBodyExpression();
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        Ref.BooleanRef isSimple = new Ref.BooleanRef();
        isSimple.element = true;
        bodyExpression.accept((PsiElementVisitor)new KtTreeVisitorVoid(isSimple, parameter){
            final /* synthetic */ Ref.BooleanRef $isSimple;
            final /* synthetic */ KtParameter $parameter;
            {
                this.$isSimple = $isSimple;
                this.$parameter = $parameter;
            }

            public void visitLambdaExpression(KtLambdaExpression lambdaExpression) {
                Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
                super.visitLambdaExpression(lambdaExpression);
                this.$isSimple.element = false;
            }

            /*
             * WARNING - void declaration
             */
            public void visitStringTemplateExpression(KtStringTemplateExpression expression) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitStringTemplateExpression(expression);
                KtStringTemplateEntry[] ktStringTemplateEntryArray = expression.getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
                Object[] objectArray = ktStringTemplateEntryArray;
                KtParameter ktParameter = this.$parameter;
                Ref.BooleanRef booleanRef = this.$isSimple;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    KtExpression receiver2;
                    KtExpression expr;
                    KtStringTemplateEntry entry = (KtStringTemplateEntry)element$iv;
                    boolean bl = false;
                    if (!(entry instanceof KtStringTemplateEntryWithExpression) || !((expr = ((KtStringTemplateEntryWithExpression)entry).getExpression()) instanceof KtDotQualifiedExpression) || !((receiver2 = ((KtDotQualifiedExpression)expr).getReceiverExpression()) instanceof KtSimpleNameExpression) || !Intrinsics.areEqual((Object)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)receiver2)).resolve(), (Object)ktParameter)) continue;
                    booleanRef.element = false;
                }
            }
        });
        return isSimple.element;
    }

    public static final boolean isReceiverFromFunctionLiteral(@NotNull KaSession $this$isReceiverFromFunctionLiteral, @Nullable KaReceiverValue receiver2, @Nullable KtFunctionLiteral functionLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$isReceiverFromFunctionLiteral, (String)"<this>");
        if (receiver2 instanceof KaExplicitReceiverValue) {
            KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)((KaExplicitReceiverValue)receiver2).getExpression()));
            return Intrinsics.areEqual((Object)(ktReference != null ? ktReference.resolve() : null), (Object)functionLiteral);
        }
        if (receiver2 instanceof KaImplicitReceiverValue) {
            KaSymbol kaSymbol = UtilsKt.getThisReceiverOwner($this$isReceiverFromFunctionLiteral, receiver2);
            return Intrinsics.areEqual((Object)(kaSymbol != null ? kaSymbol.getPsi() : null), (Object)functionLiteral);
        }
        return false;
    }

    static {
        Object[] objectArray = new Pair[5];
        objectArray[0] = TuplesKt.to((Object)"apply", (Object)"also");
        Object[] objectArray2 = new String[]{"with", "let"};
        objectArray[1] = TuplesKt.to((Object)"run", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[2] = TuplesKt.to((Object)"also", (Object)"apply");
        objectArray2 = new String[]{"run", "with"};
        objectArray[3] = TuplesKt.to((Object)"let", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"run", "let"};
        objectArray[4] = TuplesKt.to((Object)"with", (Object)CollectionsKt.listOf((Object[])objectArray2));
        counterpartNames = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"with", "run", "apply"};
        implicitThisFunctions = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"let", "also"};
        explicitParameterFunctions = SetsKt.setOf((Object[])objectArray);
    }
}

