/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ConvertMemberToExtensionIntention;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ConvertMemberToExtensionIntentionKt;
import org.jetbrains.kotlin.idea.quickfix.BodySelectionType;
import org.jetbrains.kotlin.idea.quickfix.ConvertMemberToExtensionUtilsKt;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertMemberToExtensionIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "isApplicable", "", "element", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "startInWriteAction", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getBodyForSelection", "Lorg/jetbrains/kotlin/psi/KtExpression;", "extension", "bodyTypeToSelect", "Lorg/jetbrains/kotlin/idea/quickfix/BodySelectionType;", "askIfExpectedIsAllowed", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nConvertMemberToExtensionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertMemberToExtensionIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertMemberToExtensionIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,132:1\n1#2:133\n128#3,2:134\n*S KotlinDebug\n*F\n+ 1 ConvertMemberToExtensionIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertMemberToExtensionIntention\n*L\n88#1:134,2\n*E\n"})
public final class ConvertMemberToExtensionIntention
extends SelfTargetingRangeIntention<KtCallableDeclaration>
implements LowPriorityAction {
    public ConvertMemberToExtensionIntention() {
        super(KtCallableDeclaration.class, KotlinBundle.messagePointer((String)"convert.member.to.extension", (Object[])new Object[0]), null, 4, null);
    }

    private final boolean isApplicable(KtCallableDeclaration element) {
        PsiElement psiElement = element.getParent();
        KtClassBody ktClassBody = psiElement instanceof KtClassBody ? (KtClassBody)psiElement : null;
        if (ktClassBody == null) {
            return false;
        }
        KtClassBody classBody = ktClassBody;
        PsiElement psiElement2 = classBody.getParent();
        KtClassOrObject ktClassOrObject = psiElement2 instanceof KtClassOrObject ? (KtClassOrObject)psiElement2 : null;
        if (ktClassOrObject == null) {
            return false;
        }
        KtClassOrObject parentClass = ktClassOrObject;
        if (parentClass.isLocal()) {
            return false;
        }
        if (parentClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)parentClass).isCompanion()) {
            return false;
        }
        KtClass ktClass = parentClass instanceof KtClass ? (KtClass)parentClass : null;
        boolean bl = ktClass != null ? KotlinPsiUtilsKt.isFunInterface(ktClass) : false;
        if (bl && !KtPsiUtilKt.hasBody((KtDeclaration)((KtDeclaration)element))) {
            return false;
        }
        if (element.getReceiverTypeReference() != null) {
            return false;
        }
        if (element.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        psiElement = element;
        return !(psiElement instanceof KtProperty ? ((KtProperty)element).hasInitializer() || ((KtProperty)element).hasDelegate() : psiElement instanceof KtSecondaryConstructor);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtCallableDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement;
        if (!this.isApplicable(element)) {
            return null;
        }
        return nameIdentifier.getTextRange();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtCallableDeclaration element, @Nullable Editor editor) {
        Set actualsForExpect;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element)) {
            return;
        }
        boolean allowExpected = false;
        allowExpected = true;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Set set = actualsForExpect = (Set)ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"progress.title.searching.for.expected.actual", (Object[])new Object[0]), () -> ConvertMemberToExtensionIntention.applyTo$lambda$0(element));
        if (set != null) {
            Set it = set;
            boolean bl = false;
            if (it.isEmpty()) {
                allowExpected = this.askIfExpectedIsAllowed();
            }
        }
        Pair<KtCallableDeclaration, BodySelectionType> pair = ConvertMemberToExtensionUtilsKt.convertMemberToExtensionAndPrepareBodySelection(element, allowExpected, (Function2<? super KtFile, ? super FqName, ? extends KtImportDirective>)((Function2)applyTo.2.INSTANCE));
        KtCallableDeclaration extension = (KtCallableDeclaration)pair.component1();
        BodySelectionType bodyTypeToSelect = (BodySelectionType)((Object)pair.component2());
        ActionsKt.runWriteAction(() -> ConvertMemberToExtensionIntention.applyTo$lambda$2(editor, extension, bodyTypeToSelect, this));
    }

    private final KtExpression getBodyForSelection(KtCallableDeclaration extension, BodySelectionType bodyTypeToSelect) {
        return switch (WhenMappings.$EnumSwitchMapping$0[bodyTypeToSelect.ordinal()]) {
            case 1 -> {
                KtFunction v0 = extension instanceof KtFunction ? (KtFunction)extension : null;
                if (v0 != null) {
                    KtFunction it = v0;
                    boolean $i$a$-let-ConvertMemberToExtensionIntention$getBodyForSelection$1 = false;
                    yield ConvertMemberToExtensionIntention.getBodyForSelection$selectBody(extension, (KtDeclarationWithBody)it);
                }
                yield null;
            }
            case 2 -> {
                KtProperty v2 = extension instanceof KtProperty ? (KtProperty)extension : null;
                if (v2 != null && (v2 = v2.getGetter()) != null) {
                    KtProperty it = v2;
                    boolean $i$a$-let-ConvertMemberToExtensionIntention$getBodyForSelection$2 = false;
                    yield ConvertMemberToExtensionIntention.getBodyForSelection$selectBody(extension, (KtDeclarationWithBody)it);
                }
                yield null;
            }
            case 3 -> {
                KtProperty v3 = extension instanceof KtProperty ? (KtProperty)extension : null;
                if (v3 != null && (v3 = v3.getSetter()) != null) {
                    KtProperty it = v3;
                    boolean $i$a$-let-ConvertMemberToExtensionIntention$getBodyForSelection$3 = false;
                    yield ConvertMemberToExtensionIntention.getBodyForSelection$selectBody(extension, (KtDeclarationWithBody)it);
                }
                yield null;
            }
            default -> null;
        };
    }

    private final boolean askIfExpectedIsAllowed() {
        return Messages.showYesNoDialog((String)KotlinBundle.message((String)"do.you.want.to.make.new.extension.an.expected.declaration", (Object[])new Object[0]), (String)this.getText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static final Set applyTo$lambda$0(KtCallableDeclaration $element) {
        KtDeclaration ktDeclaration = ExpectActualUtils.INSTANCE.liftToExpect((KtDeclaration)$element);
        return ktDeclaration != null ? ExpectActualUtils.actualsForExpect$default(ExpectActualUtils.INSTANCE, ktDeclaration, null, 1, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Editor applyTo$lambda$2(Editor $editor, KtCallableDeclaration $extension, BodySelectionType $bodyTypeToSelect, ConvertMemberToExtensionIntention this$0) {
        Editor editor;
        Editor editor2 = $editor;
        if (editor2 != null) {
            Editor editor3;
            Editor $this$applyTo_u24lambda_u242_u240 = editor3 = editor2;
            boolean bl = false;
            GenerateUtilsKt.unblockDocument($this$applyTo_u24lambda_u242_u240);
            if ($extension.isValid()) {
                if ($bodyTypeToSelect != BodySelectionType.NOTHING) {
                    KtExpression bodyToSelect = this$0.getBodyForSelection($extension, $bodyTypeToSelect);
                    if (bodyToSelect != null) {
                        PsiElement lastSibling;
                        PsiElement psiElement;
                        TextRange range2 = bodyToSelect.getTextRange();
                        GenerateUtilsKt.moveCaret($this$applyTo_u24lambda_u242_u240, range2.getStartOffset(), ScrollType.CENTER);
                        PsiElement parent = bodyToSelect.getParent();
                        if (parent instanceof KtBlockExpression) {
                            Sequence sequence;
                            PsiElement psiElement2 = ((KtBlockExpression)parent).getRBrace();
                            if (psiElement2 != null && (sequence = PsiUtilsKt.siblings((PsiElement)psiElement2, (boolean)false, (boolean)false)) != null) {
                                Object element$iv2;
                                block13: {
                                    void $this$first$iv;
                                    Sequence sequence2 = sequence;
                                    boolean $i$f$first = false;
                                    for (Object element$iv2 : $this$first$iv) {
                                        PsiElement it = (PsiElement)element$iv2;
                                        boolean bl2 = false;
                                        if (!(!(it instanceof PsiWhiteSpace))) continue;
                                        break block13;
                                    }
                                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                                }
                                psiElement = (PsiElement)element$iv2;
                            } else {
                                psiElement = null;
                            }
                        } else {
                            psiElement = (PsiElement)SequencesKt.lastOrNull((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)bodyToSelect), (boolean)true, (boolean)false));
                        }
                        PsiElement psiElement3 = lastSibling = psiElement;
                        int endOffset = psiElement3 != null ? PsiUtilsKt.getEndOffset((PsiElement)psiElement3) : range2.getEndOffset();
                        $this$applyTo_u24lambda_u242_u240.getSelectionModel().setSelection(range2.getStartOffset(), endOffset);
                    } else {
                        ConvertMemberToExtensionIntentionKt.access$getLOG$p().error("Extension created with new method body but this body was not found after document commit. Extension text: \"" + $extension.getText() + "\"");
                        GenerateUtilsKt.moveCaret($this$applyTo_u24lambda_u242_u240, $extension.getTextOffset(), ScrollType.CENTER);
                    }
                } else {
                    GenerateUtilsKt.moveCaret($this$applyTo_u24lambda_u242_u240, $extension.getTextOffset(), ScrollType.CENTER);
                }
            } else {
                ConvertMemberToExtensionIntentionKt.access$getLOG$p().error("Extension invalidated during document commit. Extension text \"" + $extension.getText() + "\"");
            }
            editor = editor3;
        } else {
            editor = null;
        }
        return editor;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtExpression getBodyForSelection$selectBody(KtCallableDeclaration $extension, KtDeclarationWithBody declaration) {
        Object object;
        if (!declaration.hasBody()) {
            return (KtExpression)$extension;
        }
        KtExpression ktExpression = declaration.getBodyExpression();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            object = it instanceof KtBlockExpression ? (KtBlockExpression)it : null;
            if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.singleOrNull((List)object)) == null) {
                void var2_2;
                object = var2_2;
            }
        } else {
            object = null;
        }
        return object;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BodySelectionType.values().length];
            try {
                nArray[BodySelectionType.FUNCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BodySelectionType.GETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BodySelectionType.SETTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

