/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeProjection;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertUnsafeCastCallToUnsafeCastIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertUnsafeCastCallToUnsafeCastIntention$Context;", "<init>", "()V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Context", "intellij.kotlin.codeInsight.intentions"})
public final class ConvertUnsafeCastCallToUnsafeCastIntention
extends KotlinApplicableModCommandAction<KtDotQualifiedExpression, Context> {
    public ConvertUnsafeCastCallToUnsafeCastIntention() {
        super(Reflection.getOrCreateKotlinClass(KtDotQualifiedExpression.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.to.unsafe.cast", (Object[])new Object[0]);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Context context3 = (Context)this.getElementContext(context2, (KtElement)element);
        if (context3 == null) {
            return null;
        }
        Context elementContext = context3;
        Object[] objectArray = new Object[]{elementContext.getReceiverText(), elementContext.getTypeText()};
        return Presentation.of((String)KotlinBundle.message((String)"convert.to.0.as.1", (Object[])objectArray));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!JsPlatformKt.isJs((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)element))) {
            return false;
        }
        KtExpression ktExpression = element.getSelectorExpression();
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression2 = callExpression.getCalleeExpression();
        return Intrinsics.areEqual((Object)(ktExpression2 != null ? ktExpression2.getText() : null), (Object)"unsafeCast");
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtDotQualifiedExpression element) {
        String fqName2;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getSelectorExpression();
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        KaLifetimeOwner kaLifetimeOwner = $this$prepareContext.resolveToCall((KtElement)callExpression);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner call = kaLifetimeOwner;
        Object s = KaPartiallyAppliedSymbolKt.getSymbol(call.getPartiallyAppliedSymbol());
        Object object = s instanceof KaCallableSymbol ? s : null;
        if (object == null) {
            return null;
        }
        Object callableSymbol = object;
        FqName fqName3 = $this$prepareContext.getImportableFqName((KaSymbol)callableSymbol);
        String string = fqName2 = fqName3 != null ? fqName3.asString() : null;
        if (!Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.js.unsafeCast")) {
            return null;
        }
        KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull((List)callExpression.getTypeArguments());
        if (ktTypeProjection == null) {
            return null;
        }
        KtTypeProjection typeArgument = ktTypeProjection;
        String string2 = element.getReceiverExpression().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = typeArgument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return new Context(string2, string3);
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtDotQualifiedExpression element, @NotNull Context elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] objectArray = new Object[]{element.getReceiverExpression(), elementContext.getTypeText()};
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0 as $1", (Object[])objectArray, (boolean)false, (int)4, null);
        element.replace((PsiElement)newExpression2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertUnsafeCastCallToUnsafeCastIntention$Context;", "", "receiverText", "", "typeText", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getReceiverText", "()Ljava/lang/String;", "getTypeText", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.kotlin.codeInsight.intentions"})
    public static final class Context {
        @NotNull
        private final String receiverText;
        @NotNull
        private final String typeText;

        public Context(@NotNull String receiverText, @NotNull String typeText) {
            Intrinsics.checkNotNullParameter((Object)receiverText, (String)"receiverText");
            Intrinsics.checkNotNullParameter((Object)typeText, (String)"typeText");
            this.receiverText = receiverText;
            this.typeText = typeText;
        }

        @NotNull
        public final String getReceiverText() {
            return this.receiverText;
        }

        @NotNull
        public final String getTypeText() {
            return this.typeText;
        }

        @NotNull
        public final String component1() {
            return this.receiverText;
        }

        @NotNull
        public final String component2() {
            return this.typeText;
        }

        @NotNull
        public final Context copy(@NotNull String receiverText, @NotNull String typeText) {
            Intrinsics.checkNotNullParameter((Object)receiverText, (String)"receiverText");
            Intrinsics.checkNotNullParameter((Object)typeText, (String)"typeText");
            return new Context(receiverText, typeText);
        }

        public static /* synthetic */ Context copy$default(Context context2, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = context2.receiverText;
            }
            if ((n & 2) != 0) {
                string2 = context2.typeText;
            }
            return context2.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Context(receiverText=" + this.receiverText + ", typeText=" + this.typeText + ")";
        }

        public int hashCode() {
            int result2 = this.receiverText.hashCode();
            result2 = result2 * 31 + this.typeText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            if (!Intrinsics.areEqual((Object)this.receiverText, (Object)context2.receiverText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.typeText, (Object)context2.typeText);
        }
    }
}

