/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveOperationDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveSourceDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveDialog;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J0\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ExtractDeclarationFromCurrentFileIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "startInWriteAction", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "showRefactoringDialog", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Lcom/intellij/psi/PsiFile;", "callBack", "Lcom/intellij/refactoring/move/MoveCallback;", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nExtractDeclarationFromCurrentFileIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractDeclarationFromCurrentFileIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ExtractDeclarationFromCurrentFileIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,118:1\n1#2:119\n73#3:120\n*S KotlinDebug\n*F\n+ 1 ExtractDeclarationFromCurrentFileIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ExtractDeclarationFromCurrentFileIntention\n*L\n81#1:120\n*E\n"})
public final class ExtractDeclarationFromCurrentFileIntention
extends SelfTargetingRangeIntention<KtClassOrObject>
implements LowPriorityAction {
    public ExtractDeclarationFromCurrentFileIntention() {
        super(KtClassOrObject.class, KotlinBundle.messagePointer((String)"intention.extract.declarations.from.file.text", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getName() == null) {
            return null;
        }
        if (!(element.getParent() instanceof KtFile)) {
            return null;
        }
        if (element.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return null;
        }
        KtFile $this$applicabilityRange_u24lambda_u240 = element.getContainingKtFile();
        boolean bl = false;
        boolean bl2 = $this$applicabilityRange_u24lambda_u240.getDeclarations().size() == 1 || $this$applicabilityRange_u24lambda_u240.getContainingDirectory() == null;
        if (bl2) {
            return null;
        }
        Object[] objectArray = element;
        if (objectArray instanceof KtClass) {
            n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
        } else if (objectArray instanceof KtObjectDeclaration) {
            PsiElement psiElement = ((KtObjectDeclaration)element).getObjectKeyword();
            n = psiElement != null ? Integer.valueOf(PsiUtilsKt.getStartOffset((PsiElement)psiElement)) : null;
        } else {
            return null;
        }
        if (n == null) {
            return null;
        }
        int startOffset = n;
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            return null;
        }
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)psiElement);
        objectArray = new Object[]{String.valueOf(element.getName()), 0};
        this.setTextGetter(KotlinBundle.messagePointer((String)"intention.extract.declarations.from.file.text.details", (Object[])objectArray));
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            boolean $i$a$-requireNotNull-ExtractDeclarationFromCurrentFileIntention$applyTo$22 = false;
            String $i$a$-requireNotNull-ExtractDeclarationFromCurrentFileIntention$applyTo$22 = "This intention requires an editor";
            throw new IllegalArgumentException($i$a$-requireNotNull-ExtractDeclarationFromCurrentFileIntention$applyTo$22.toString());
        }
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile containingFile = ktFile2;
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        int originalOffset = editor.getCaretModel().getOffset() - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
        PsiDirectory psiDirectory = containingFile.getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        FqName packageName = containingFile.getPackageFqName();
        String targetFileName = element.getName() + ".kt";
        PsiFile targetFile = directory.findFile(targetFileName);
        MoveCallback moveCallBack2 = () -> ExtractDeclarationFromCurrentFileIntention.applyTo$lambda$1(directory, targetFileName, project2, originalOffset);
        if (targetFile != null) {
            boolean $i$f$isUnitTestMode2 = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Object[] $i$f$isUnitTestMode2 = new Object[]{targetFileName};
                throw new CommonRefactoringUtil.RefactoringErrorHintException(RefactoringBundle.message((String)"file.already.exist", (Object[])$i$f$isUnitTestMode2));
            }
            this.showRefactoringDialog(project2, editor, element, targetFile, moveCallBack2);
            return;
        }
        K2MoveDescriptor.Declarations moveDescriptor = new K2MoveDescriptor.Declarations(project2, new K2MoveSourceDescriptor.ElementSource(SetsKt.setOf((Object)element)), new K2MoveTargetDescriptor.File(targetFileName, packageName, directory, false, 8, null));
        new K2MoveOperationDescriptor.Declarations(project2, CollectionsKt.listOf((Object)moveDescriptor), false, false, true, false, moveCallBack2).refactoringProcessor().run();
    }

    private final void showRefactoringDialog(Project project, Editor editor, KtClassOrObject element, PsiFile targetFile, MoveCallback callBack2) {
        KtClassOrObject[] ktClassOrObjectArray = new KtClassOrObject[]{element};
        K2MoveModel k2MoveModel = K2MoveModel.Companion.create((PsiElement[])ktClassOrObjectArray, (PsiElement)targetFile, editor, callBack2);
        if (k2MoveModel == null) {
            return;
        }
        K2MoveModel model2 = k2MoveModel;
        K2MoveDialog dialog2 = new K2MoveDialog(project, model2);
        dialog2.show();
    }

    private static final void applyTo$lambda$1(PsiDirectory $directory, String $targetFileName, Project $project, int $originalOffset) {
        block0: {
            PsiFile psiFile = $directory.findFile($targetFileName);
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile newFile = (KtFile)psiFile;
            KtDeclaration newDeclaration = (KtDeclaration)CollectionsKt.first((List)newFile.getDeclarations());
            NavigationUtil.activateFileWithPsiElement$default((PsiElement)((PsiElement)newFile), (boolean)false, (int)2, null);
            Editor editor = FileEditorManager.getInstance((Project)$project).getSelectedTextEditor();
            if (editor == null) break block0;
            GenerateUtilsKt.moveCaret$default(editor, PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)newDeclaration)) + $originalOffset, null, 2, null);
        }
    }
}

