/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.symbols.KaFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocationKt;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ImportAllMembersIntentionKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ImportMemberIntentionKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportMemberIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportMemberIntention$Context;", "<init>", "()V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Context", "intellij.kotlin.codeInsight.intentions"})
public final class ImportMemberIntention
extends KotlinApplicableModCommandAction<KtElement, Context> {
    public ImportMemberIntention() {
        super(Reflection.getOrCreateKotlinClass(KtElement.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"add.import.for.member", (Object[])new Object[0]);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Context context3 = (Context)this.getElementContext(context2, element);
        if (context3 == null) {
            return null;
        }
        FqName fqName2 = context3.component1();
        Object[] objectArray = new Object[]{fqName2.asString()};
        return Presentation.of((String)KotlinBundle.message((String)"add.import.for.0", (Object[])objectArray)).withPriority(PriorityAction.Priority.HIGH);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtDotQualifiedExpression && !KtPsiUtilKt.isInImportDirective((KtExpression)((KtExpression)element)) || element instanceof KtUserType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtElement element) {
        Context context2;
        KaSymbol kaSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtReference ktReference = ImportAllMembersIntentionKt.getActualReference(element);
        if (ktReference == null) {
            return null;
        }
        KtReference reference = ktReference;
        KaNamedClassSymbol kaNamedClassSymbol = AnalysisUtilsKt.resolveCompanionObjectShortReferenceToContainingClassSymbol($this$prepareContext, reference);
        if (kaNamedClassSymbol != null) {
            kaSymbol = kaNamedClassSymbol;
        } else {
            kaSymbol = $this$prepareContext.resolveToSymbol(reference);
            if (kaSymbol == null) {
                return null;
            }
        }
        KaSymbol symbol = kaSymbol;
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        Context context3 = ImportMemberIntentionKt.access$computeContext($this$prepareContext, file, symbol);
        if (context3 == null) return null;
        Context it = context2 = context3;
        boolean bl = false;
        if (KaSymbolLocationKt.isTopLevel(symbol)) {
            boolean bl2;
            KaFileSymbol kaFileSymbol = $this$prepareContext.getContainingFile(symbol);
            if (kaFileSymbol != null) {
                if (ImportMemberIntentionKt.access$isInSamePackage(kaFileSymbol, file)) {
                    return null;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return null;
            }
        }
        boolean bl3 = false;
        if (bl3) return null;
        Context context4 = context2;
        return context4;
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtElement element, @NotNull Context elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        ShortenUtilsKt.invokeShortening(elementContext.getShortenCommand());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportMemberIntention$Context;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "shortenCommand", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getShortenCommand", "()Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.codeInsight.intentions"})
    public static final class Context {
        @NotNull
        private final FqName fqName;
        @NotNull
        private final ShortenCommand shortenCommand;

        public Context(@NotNull FqName fqName2, @NotNull ShortenCommand shortenCommand) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)shortenCommand, (String)"shortenCommand");
            this.fqName = fqName2;
            this.shortenCommand = shortenCommand;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final ShortenCommand getShortenCommand() {
            return this.shortenCommand;
        }

        @NotNull
        public final FqName component1() {
            return this.fqName;
        }

        @NotNull
        public final ShortenCommand component2() {
            return this.shortenCommand;
        }

        @NotNull
        public final Context copy(@NotNull FqName fqName2, @NotNull ShortenCommand shortenCommand) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)shortenCommand, (String)"shortenCommand");
            return new Context(fqName2, shortenCommand);
        }

        public static /* synthetic */ Context copy$default(Context context2, FqName fqName2, ShortenCommand shortenCommand, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = context2.fqName;
            }
            if ((n & 2) != 0) {
                shortenCommand = context2.shortenCommand;
            }
            return context2.copy(fqName2, shortenCommand);
        }

        @NotNull
        public String toString() {
            return "Context(fqName=" + this.fqName + ", shortenCommand=" + this.shortenCommand + ")";
        }

        public int hashCode() {
            int result2 = this.fqName.hashCode();
            result2 = result2 * 31 + this.shortenCommand.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            if (!Intrinsics.areEqual((Object)this.fqName, (Object)context2.fqName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.shortenCommand, (Object)context2.shortenCommand);
        }
    }
}

