/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.util.RedundantExplicitTypeArgumentsUtilKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u0003*\u00020\u00112\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0002J\r\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ReplaceTypeArgumentWithUnderscoreIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "", "<init>", "()V", "invoke", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "element", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtTypeProjection;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtTypeProjection;)Lkotlin/Unit;", "replaceWithUnderscore", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nReplaceTypeArgumentWithUnderscoreIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceTypeArgumentWithUnderscoreIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ReplaceTypeArgumentWithUnderscoreIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1807#2,3:53\n*S KotlinDebug\n*F\n+ 1 ReplaceTypeArgumentWithUnderscoreIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ReplaceTypeArgumentWithUnderscoreIntention\n*L\n35#1:53,3\n*E\n"})
public final class ReplaceTypeArgumentWithUnderscoreIntention
extends KotlinApplicableModCommandAction<KtTypeProjection, Unit> {
    public ReplaceTypeArgumentWithUnderscoreIntention() {
        super(Reflection.getOrCreateKotlinClass(KtTypeProjection.class));
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtTypeProjection element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        this.replaceWithUnderscore(element);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtTypeProjection element) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element).supportsFeature(LanguageFeature.PartiallySpecifiedTypeArguments)) {
                return false;
            }
            KtTypeReference ktTypeReference = element.getTypeReference();
            boolean bl2 = ktTypeReference != null ? ktTypeReference.isPlaceholder() : false;
            if (bl2) {
                return false;
            }
            PsiElement psiElement = element.getParent();
            KtTypeArgumentList ktTypeArgumentList = psiElement instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement : null;
            if (ktTypeArgumentList == null) {
                return false;
            }
            KtTypeArgumentList typeArgumentList = ktTypeArgumentList;
            List list2 = typeArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getArguments(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtTypeProjection it = (KtTypeProjection)element$iv;
                    boolean bl3 = false;
                    KtTypeReference ktTypeReference2 = it.getTypeReference();
                    boolean bl4 = ktTypeReference2 != null ? KotlinPsiUtilsKt.isAnnotatedDeep(ktTypeReference2) : false;
                    if (!bl4) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return !bl;
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtTypeProjection element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtTypeArgumentList ktTypeArgumentList = psiElement instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement : null;
        if (ktTypeArgumentList == null) {
            return null;
        }
        KtTypeArgumentList typeArgumentList = ktTypeArgumentList;
        PsiElement psiElement2 = typeArgumentList.getParent();
        KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        if (!RedundantExplicitTypeArgumentsUtilKt.canBeReplacedWithUnderscore($this$prepareContext, element, callExpression)) {
            return null;
        }
        return Unit.INSTANCE;
    }

    private final void replaceWithUnderscore(KtTypeProjection element) {
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtTypeProjection newTypeProjection = new KtPsiFactory(project, false, 2, null).createTypeArgument("_");
        element.replace((PsiElement)newTypeProjection);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.with.underscore", (Object[])new Object[0]);
    }
}

