/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaRenderer;
import org.jetbrains.kotlin.analysis.api.types.KaErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u00132\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/SplitPropertyDeclarationIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/SplitPropertyDeclarationIntention$Context;", "<init>", "()V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Context", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nSplitPropertyDeclarationIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitPropertyDeclarationIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/SplitPropertyDeclarationIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class SplitPropertyDeclarationIntention
extends KotlinApplicableModCommandAction<KtProperty, Context> {
    public SplitPropertyDeclarationIntention() {
        super(Reflection.getOrCreateKotlinClass(KtProperty.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"split.property.declaration", (Object[])new Object[0]);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.LOW);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"withPriority(...)");
        return presentation;
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getInitializer();
        Intrinsics.checkNotNull((Object)ktExpression);
        return CollectionsKt.listOf((Object)new TextRange(0, ktExpression.getStartOffsetInParent()));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.isLocal() || element.getParent() instanceof KtWhenExpression) {
            return false;
        }
        return element.getInitializer() != null;
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element.getInitializer();
        if (object == null || (object = $this$prepareContext.getExpressionType((KtExpression)object)) == null) {
            return null;
        }
        Object ktType2 = object;
        return new Context(ktType2 instanceof KaErrorType ? null : KaRenderer.render$default($this$prepareContext, (KaType)ktType2, null, Variance.OUT_VARIANCE, 1, null));
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty element, @NotNull Context elementContext, @NotNull ModPsiUpdater updater2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            PsiElement parent = element.getParent();
            KtExpression ktExpression = element.getInitializer();
            if (ktExpression == null) {
                return;
            }
            KtExpression initializer2 = ktExpression;
            String explicitTypeToSet = element.getTypeReference() != null ? null : elementContext.getPropertyType();
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)element.getNameAsName());
            objectArray[1] = initializer2;
            parent.addAfter((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 = $1", (Object[])objectArray, (boolean)false, (int)4, null), (PsiElement)element);
            parent.addAfter(psiFactory.createNewLine(), (PsiElement)element);
            element.setInitializer(null);
            if (explicitTypeToSet == null) break block2;
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KtTypeReference typeReference = new KtPsiFactory(project2, false, 2, null).createType(explicitTypeToSet);
            KtTypeReference ktTypeReference = element.setTypeReference(typeReference);
            if (ktTypeReference != null) {
                KtTypeReference it = ktTypeReference;
                boolean bl = false;
                ShortenUtilsKt.shortenReferences$default((KtElement)it, null, null, null, 14, null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/SplitPropertyDeclarationIntention$Context;", "", "propertyType", "", "<init>", "(Ljava/lang/String;)V", "getPropertyType", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.kotlin.codeInsight.intentions"})
    public static final class Context {
        @Nullable
        private final String propertyType;

        public Context(@Nullable String propertyType) {
            this.propertyType = propertyType;
        }

        @Nullable
        public final String getPropertyType() {
            return this.propertyType;
        }

        @Nullable
        public final String component1() {
            return this.propertyType;
        }

        @NotNull
        public final Context copy(@Nullable String propertyType) {
            return new Context(propertyType);
        }

        public static /* synthetic */ Context copy$default(Context context2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = context2.propertyType;
            }
            return context2.copy(string);
        }

        @NotNull
        public String toString() {
            return "Context(propertyType=" + this.propertyType + ")";
        }

        public int hashCode() {
            return this.propertyType == null ? 0 : this.propertyType.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            return Intrinsics.areEqual((Object)this.propertyType, (Object)context2.propertyType);
        }
    }
}

