/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.inline;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.J2KInlineCache;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.JavaToKotlinInlineHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractCrossLanguageInlineHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineRefactoringFUSCollector;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.UsageReplacementStrategy;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/inline/JavaToKotlinInlineHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractCrossLanguageInlineHandler;", "<init>", "()V", "prepareReference", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "reference", "Lcom/intellij/psi/PsiReference;", "referenced", "performInline", "", "usage", "Lcom/intellij/usageView/UsageInfo;", "Companion", "intellij.kotlin.refactorings"})
public final class JavaToKotlinInlineHandler
extends AbstractCrossLanguageInlineHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    public MultiMap<PsiElement, String> prepareReference(@NotNull PsiReference reference, @NotNull PsiElement referenced) {
        String string;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement referenceElement = psiElement;
        if (Intrinsics.areEqual((Object)referenceElement.getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
            KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
            KotlinInlineRefactoringFUSCollector.INSTANCE.log(referenced, (Language)kotlinLanguage, true);
        }
        PsiMember psiMember = JavaToKotlinInlineHandlerKt.access$getJavaMemberToInline(referenced);
        if (psiMember == null) {
            return super.prepareReference(reference, referenced);
        }
        PsiMember javaMemberToInline = psiMember;
        String string2 = JavaToKotlinInlineHandlerKt.access$validate(javaMemberToInline, referenceElement);
        if (string2 != null) {
            String error = string2;
            boolean bl = false;
            return AbstractCrossLanguageInlineHandler.Companion.createMultiMapWithSingleConflict(referenceElement, error);
        }
        try {
            UsageReplacementStrategy strategy = J2KInlineCache.Companion.findOrCreateUsageReplacementStrategy$intellij_kotlin_refactorings(javaMemberToInline, referenceElement);
            string = strategy == null ? KotlinBundle.message((String)"failed.to.create.a.wrapper.for.inlining.to.kotlin", (Object[])new Object[0]) : null;
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
            string = e.getMessage();
        }
        string2 = string;
        if (string2 != null) {
            String error = string2;
            boolean bl = false;
            return AbstractCrossLanguageInlineHandler.Companion.createMultiMapWithSingleConflict(referenceElement, error);
        }
        MultiMap multiMap = MultiMap.empty();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
        return multiMap;
    }

    @Override
    public void performInline(@NotNull UsageInfo usage, @NotNull PsiElement referenced) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
            KtReferenceExpression ktReferenceExpression = JavaToKotlinInlineHandlerKt.access$unwrapUsage(usage);
            if (ktReferenceExpression == null) {
                JavaToKotlinInlineHandler $this$performInline_u24lambda_u240 = this;
                boolean bl = false;
                LOG.error("Kotlin usage in " + usage + " not found (element " + usage.getElement());
                return;
            }
            KtReferenceExpression unwrappedUsage = ktReferenceExpression;
            KtReferenceExpression unwrappedElement = JavaToKotlinInlineHandlerKt.access$unwrapElement(unwrappedUsage, referenced);
            UsageReplacementStrategy usageReplacementStrategy = J2KInlineCache.Companion.findUsageReplacementStrategy(referenced, false);
            if (usageReplacementStrategy == null) {
                JavaToKotlinInlineHandler $this$performInline_u24lambda_u241 = this;
                boolean bl = false;
                LOG.error("Can't find strategy for " + Reflection.getOrCreateKotlinClass(unwrappedElement.getClass()) + " (" + JavaPsiUtils.getKotlinFqName((PsiElement)unwrappedElement) + ") => " + unwrappedElement.getText());
                return;
            }
            UsageReplacementStrategy replacementStrategy = usageReplacementStrategy;
            Function0<KtElement> function0 = replacementStrategy.createReplacer(unwrappedElement);
            if (function0 == null) break block2;
            KtElement cfr_ignored_0 = (KtElement)function0.invoke();
        }
    }

    static {
        Logger logger = Logger.getInstance(JavaToKotlinInlineHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/inline/JavaToKotlinInlineHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.kotlin.refactorings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

