/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.processor.conflict;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\t*\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"checkImplicitPackagePrefixConflict", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "targetDir", "Lcom/intellij/psi/PsiDirectory;", "targetPkg", "Lorg/jetbrains/kotlin/name/FqName;", "firstKtFileInSourceRootWithPrefix", "Lorg/jetbrains/kotlin/psi/KtFile;", "prefix", "toKtFileIfItsPackageHasPrefix", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.refactorings.move"})
@SourceDebugExtension(value={"SMAP\nimplicitPackagePrefixConflict.kt\nKotlin\n*S Kotlin\n*F\n+ 1 implicitPackagePrefixConflict.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/conflict/ImplicitPackagePrefixConflictKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class ImplicitPackagePrefixConflictKt {
    @NotNull
    public static final MultiMap<PsiElement, String> checkImplicitPackagePrefixConflict(@NotNull PsiDirectory targetDir, @NotNull FqName targetPkg) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)targetPkg, (String)"targetPkg");
        MultiMap conflicts = new MultiMap();
        FqName fqName2 = PackageUtilsKt.getImplicitPackagePrefix(targetDir);
        if (fqName2 == null) {
            return conflicts;
        }
        FqName implicitPrefix = fqName2;
        if (!targetPkg.startsWith(implicitPrefix)) {
            KtFile ktFile2 = ImplicitPackagePrefixConflictKt.firstKtFileInSourceRootWithPrefix(targetDir, implicitPrefix);
            if (ktFile2 == null) {
                return conflicts;
            }
            KtFile referenceFile = ktFile2;
            KtPackageDirective ktPackageDirective = referenceFile.getPackageDirective();
            if (ktPackageDirective == null) {
                return conflicts;
            }
            KtPackageDirective packageDirectiveInReferenceFile = ktPackageDirective;
            Object[] objectArray = new Object[]{targetPkg.asString(), implicitPrefix.asString()};
            conflicts.putValue((Object)packageDirectiveInReferenceFile, (Object)KotlinBundle.message((String)"the.package.0.does.not.match.the.implicit.prefix.1", (Object[])objectArray));
        }
        return conflicts;
    }

    private static final KtFile firstKtFileInSourceRootWithPrefix(PsiDirectory $this$firstKtFileInSourceRootWithPrefix, FqName prefix2) {
        VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$this$firstKtFileInSourceRootWithPrefix);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile sourceRoot = virtualFile;
        Module module = ProjectFileIndex.getInstance((Project)$this$firstKtFileInSourceRootWithPrefix.getProject()).getModuleForFile(sourceRoot);
        if (module == null) {
            return null;
        }
        Module containingModule = module;
        Ref.ObjectRef file = new Ref.ObjectRef();
        FileTypeIndex.processFiles((FileType)((FileType)KotlinFileType.INSTANCE), arg_0 -> ImplicitPackagePrefixConflictKt.firstKtFileInSourceRootWithPrefix$lambda$0(prefix2, $this$firstKtFileInSourceRootWithPrefix, file, arg_0), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)containingModule));
        return (KtFile)file.element;
    }

    private static final KtFile toKtFileIfItsPackageHasPrefix(VirtualFile $this$toKtFileIfItsPackageHasPrefix, FqName prefix2, Project project) {
        KtFile ktFile2;
        KtFile ktFile3;
        CharSequence charSequence = $this$toKtFileIfItsPackageHasPrefix.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        if (!StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)"kt", (boolean)false, (int)2, null)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile($this$toKtFileIfItsPackageHasPrefix);
        KtFile ktFile4 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile4 == null) {
            return null;
        }
        KtFile it = ktFile3 = (ktFile2 = ktFile4);
        boolean bl = false;
        KtPackageDirective ktPackageDirective = it.getPackageDirective();
        return (ktPackageDirective != null && (ktPackageDirective = ktPackageDirective.getFqName()) != null ? ktPackageDirective.startsWith(prefix2) : false) ? ktFile3 : null;
    }

    private static final boolean firstKtFileInSourceRootWithPrefix$lambda$0(FqName $prefix, PsiDirectory $this_firstKtFileInSourceRootWithPrefix, Ref.ObjectRef $file, VirtualFile vFile) {
        boolean bl;
        Intrinsics.checkNotNull((Object)vFile);
        Project project = $this_firstKtFileInSourceRootWithPrefix.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtFile ktFile2 = ImplicitPackagePrefixConflictKt.toKtFileIfItsPackageHasPrefix(vFile, $prefix, project);
        if (ktFile2 != null) {
            $file.element = ktFile2;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }
}

