/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.platform.backend.observation.Observation;
import com.intellij.platform.util.progress.ContextKt;
import com.intellij.platform.util.progress.SequentialProgressReporter;
import com.intellij.platform.util.progress.SequentialProgressReporterHandle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.plugin.KotlinCompilerVersionProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.AutoConfigurationSettings;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ChangedConfiguratorFiles;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.maven.KotlinMavenAutoConfigurationNotificationHolder;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.MavenModulesRelationshipKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;
import org.jetbrains.kotlin.idea.quickfix.AbstractChangeFeatureSupportLevelFix;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingConfigurationError;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 `2\u00020\u0001:\u0001`B+\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190#H\u0016J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190#H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010'\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010-\u001a\u00020\u0005H\u0016J\u0016\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020\u0003H\u0014J\u0010\u00102\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H$J\u0010\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0003H$J \u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u0019H$J\u0018\u00109\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H$J(\u0010<\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;2\u0006\u0010?\u001a\u00020@H\u0016J \u0010A\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;H\u0002J*\u0010B\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;2\b\u0010?\u001a\u0004\u0018\u00010@H\u0002J*\u0010C\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010D\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010:\u001a\u0004\u0018\u00010;H\u0014J8\u0010E\u001a\u00020!2\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u0002082\u0006\u0010F\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u0005H\u0004J4\u0010H\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010I\u001a\u0004\u0018\u00010\u00032\b\u0010J\u001a\u0004\u0018\u00010\u00032\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u0005H\u0016J0\u0010N\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0017J(\u0010W\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[2\u0006\u0010M\u001a\u00020\u0005H\u0016J,\u0010\\\u001a\u0004\u0018\u00010P2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[2\b\b\u0001\u0010]\u001a\u00020\u0003H\u0002J\u0014\u0010^\u001a\u00020\u0005*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010_\u001a\u00020\u0005*\u00020\u0014H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006a"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "testArtifactId", "", "addJunit", "", "name", "presentableText", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPresentableText", "canRunAutoConfig", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleSourceRootGroup;", "logErrorAndReturnBrokenStatus", "project", "Lcom/intellij/openapi/project/Project;", "error", "Lorg/jetbrains/kotlin/idea/statistics/KotlinJ2KOnboardingConfigurationError;", "isApplicable", "module", "Lcom/intellij/openapi/module/Module;", "checkPluginConfiguration", "psi", "Lcom/intellij/psi/xml/XmlFile;", "hasKotlinPlugin", "pom", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "configure", "", "excludeModules", "", "configureAndGetConfiguredModules", "", "queueSyncIfNeeded", "queueSyncAndWaitForProjectToBeConfigured", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateAutoConfigSettings", "Lorg/jetbrains/kotlin/idea/configuration/AutoConfigurationSettings;", "(Lcom/intellij/openapi/module/Module;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateAutoConfigSettingsReadAction", "isAutoConfigurationEnabled", "runAutoConfig", "settings", "(Lorg/jetbrains/kotlin/idea/configuration/AutoConfigurationSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMinimumSupportedVersion", "isKotlinModule", "isRelevantGoal", "goalName", "createExecutions", "pomFile", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getStdlibArtifactId", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "configureModule", "file", "Lcom/intellij/psi/PsiFile;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configureModuleSilently", "changePomFile", "configurePlugin", "plugin", "createExecution", "executionId", "isTest", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "forTests", "addLibraryDependency", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "changeMavenFeatureConfiguration", "messageTitle", "isMavenSyncPending", "isMavenSyncInProgress", "Companion", "intellij.kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nKotlinMavenConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMavenConfigurator.kt\norg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 steps.kt\ncom/intellij/platform/util/progress/StepsKt\n*L\n1#1,516:1\n1#2:517\n1807#3,3:518\n1807#3,2:521\n1807#3,3:523\n1809#3:526\n31#4,3:527\n*S KotlinDebug\n*F\n+ 1 KotlinMavenConfigurator.kt\norg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator\n*L\n131#1:518,3\n141#1:521,2\n142#1:523,3\n141#1:526\n231#1:527,3\n*E\n"})
public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String testArtifactId;
    private final boolean addJunit;
    @NotNull
    private final String name;
    @NotNull
    private final String presentableText;
    @NotNull
    public static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    public static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    @NotNull
    public static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";

    protected KotlinMavenConfigurator(@Nullable String testArtifactId, boolean addJunit, @NotNull String name2, @NotNull String presentableText) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)presentableText, (String)"presentableText");
        this.testArtifactId = testArtifactId;
        this.addJunit = addJunit;
        this.name = name2;
        this.presentableText = presentableText;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    @Override
    public boolean canRunAutoConfig() {
        return this.isAutoConfigurationEnabled();
    }

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
        Module module = moduleSourceRootGroup.getBaseModule();
        if (BuildSystemTypeKt.getBuildSystemType(module) != BuildSystemType.Maven) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        PsiFile psi = (PsiFile)ActionsKt.runReadAction(() -> KotlinMavenConfigurator.getStatus$lambda$0(module));
        if (psi == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.logErrorAndReturnBrokenStatus(project, KotlinJ2KOnboardingConfigurationError.NO_POM_FILE);
        }
        if (!psi.isValid()) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.logErrorAndReturnBrokenStatus(project, KotlinJ2KOnboardingConfigurationError.PSI_FOR_POM_IS_NOT_VALID);
        }
        if (!(psi instanceof XmlFile)) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.logErrorAndReturnBrokenStatus(project, KotlinJ2KOnboardingConfigurationError.POM_IS_NOT_XML);
        }
        if (((XmlFile)psi).getVirtualFile() == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.logErrorAndReturnBrokenStatus(project, KotlinJ2KOnboardingConfigurationError.VIRTUAL_FILE_DOESNT_EXIST_FOR_PSI_FILE);
        }
        if (this.isKotlinModule(module)) {
            return (ConfigureKotlinStatus)((Object)ActionsKt.runReadAction(() -> KotlinMavenConfigurator.getStatus$lambda$1(this, module, psi)));
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    private final ConfigureKotlinStatus logErrorAndReturnBrokenStatus(Project project, KotlinJ2KOnboardingConfigurationError error) {
        KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed(project, error);
        return ConfigureKotlinStatus.BROKEN;
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return BuildSystemTypeKt.getBuildSystemType(module) == BuildSystemType.Maven;
    }

    @NotNull
    protected ConfigureKotlinStatus checkPluginConfiguration(@NotNull Module module, @NotNull XmlFile psi) {
        boolean bl;
        block14: {
            Object v3;
            block12: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi);
                if (pomFile == null) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                PomFile pom = pomFile;
                if (this.hasKotlinPlugin(pom)) {
                    return ConfigureKotlinStatus.CONFIGURED;
                }
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project2);
                MavenProject mavenProject = mavenProjectsManager.findProject(module);
                if (mavenProject == null) {
                    return this.logErrorAndReturnBrokenStatus(project2, KotlinJ2KOnboardingConfigurationError.MAVEN_PROJECT_FOR_MODULE_NOT_FOUND);
                }
                MavenProject mavenProject2 = mavenProject;
                MavenId kotlinPluginId = org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.kotlinPluginId$default(Companion, null, 1, null);
                Iterable iterable = mavenProject2.getPlugins();
                Iterator iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    MavenPlugin it = (MavenPlugin)t;
                    boolean bl2 = false;
                    if (!it.getMavenId().equals(kotlinPluginId.getGroupId(), kotlinPluginId.getArtifactId())) continue;
                    v3 = t;
                    break block12;
                }
                v3 = null;
            }
            MavenPlugin mavenPlugin = v3;
            if (mavenPlugin == null) {
                return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
            }
            MavenPlugin kotlinPlugin = mavenPlugin;
            List list2 = kotlinPlugin.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExecutions(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block13: {
                        MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv;
                        boolean bl4 = false;
                        List list3 = it.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getGoals(...)");
                        Iterable $this$any$iv2 = list3;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String p0 = (String)element$iv2;
                                boolean bl5 = false;
                                if (!this.isRelevantGoal(p0)) continue;
                                bl3 = true;
                                break block13;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    protected final boolean hasKotlinPlugin(@NotNull PomFile pom) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
            MavenDomPlugin mavenDomPlugin = pom.findPlugin(org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.kotlinPluginId$default(Companion, null, 1, null));
            if (mavenDomPlugin == null) {
                return false;
            }
            MavenDomPlugin plugin = mavenDomPlugin;
            List list2 = plugin.getExecutions().getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExecutions(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        MavenDomPluginExecution execution = (MavenDomPluginExecution)element$iv;
                        boolean bl3 = false;
                        List list3 = execution.getGoals().getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getGoals(...)");
                        Iterable $this$any$iv2 = list3;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                MavenDomGoal it = (MavenDomGoal)element$iv2;
                                boolean bl4 = false;
                                String string = it.getStringValue();
                                if (string == null) {
                                    string = "";
                                }
                                if (!this.isRelevantGoal(string)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void configure(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        this.configureAndGetConfiguredModules(project, excludeModules);
    }

    @NotNull
    public Set<Module> configureAndGetConfiguredModules(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules, this.getMinimumSupportedVersion());
        if (dialog2.getModulesToConfigure().isEmpty()) {
            return SetsKt.emptySet();
        }
        dialog2.show();
        if (!dialog2.isOK()) {
            return SetsKt.emptySet();
        }
        String string = dialog2.getKotlinVersion();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String kotlinVersion = string;
        KotlinJ2KOnboardingFUSCollector.INSTANCE.logChosenKotlinVersion(project, kotlinVersion);
        KotlinJ2KOnboardingFUSCollector.logStartConfigureKt$default(KotlinJ2KOnboardingFUSCollector.INSTANCE, project, false, 2, null);
        Set configuredModules = new LinkedHashSet();
        ApplicationUtilsKt.executeWriteCommand(project, KotlinMavenBundle.message("configure.title", new Object[0]), (Function0<Unit>)((Function0)() -> KotlinMavenConfigurator.configureAndGetConfiguredModules$lambda$0(project, dialog2, this, kotlinVersion, configuredModules)));
        return configuredModules;
    }

    @Override
    public void queueSyncIfNeeded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinProjectConfigurationService.Companion.getInstance(project).queueSync();
    }

    @Override
    @Nullable
    public Object queueSyncAndWaitForProjectToBeConfigured(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        return KotlinMavenConfigurator.queueSyncAndWaitForProjectToBeConfigured$suspendImpl(this, project, $completion);
    }

    static /* synthetic */ Object queueSyncAndWaitForProjectToBeConfigured$suspendImpl(KotlinMavenConfigurator $this, Project project, Continuation<? super Unit> $completion) {
        $this.queueSyncIfNeeded(project);
        Object object = Observation.awaitConfiguration$default((Observation)Observation.INSTANCE, (Project)project, null, $completion, (int)2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object calculateAutoConfigSettings(@NotNull Module module, @NotNull Continuation<? super AutoConfigurationSettings> $completion) {
        return KotlinMavenConfigurator.calculateAutoConfigSettings$suspendImpl(this, module, $completion);
    }

    static /* synthetic */ Object calculateAutoConfigSettings$suspendImpl(KotlinMavenConfigurator $this, Module module, Continuation<? super AutoConfigurationSettings> $completion) {
        return CoroutinesKt.readAction(() -> KotlinMavenConfigurator.calculateAutoConfigSettings$lambda$0($this, module), $completion);
    }

    private final AutoConfigurationSettings calculateAutoConfigSettingsReadAction(Module module) {
        if (!this.isAutoConfigurationEnabled()) {
            return null;
        }
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootGroupUtils.toModuleGroup(module);
        ConfigureKotlinStatus status = this.getStatus(moduleGroup);
        if (status != ConfigureKotlinStatus.CAN_BE_CONFIGURED) {
            return null;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (this.isMavenSyncPending(project2, module) || this.isMavenSyncInProgress(project2)) {
            return null;
        }
        if (ConfigureKotlinInProjectUtilsKt.hasKotlinPluginEnabled(module)) {
            return null;
        }
        IdeKotlinVersion ideKotlinVersion = KotlinCompilerVersionProvider.Companion.getVersion(module);
        if (ideKotlinVersion == null) {
            ideKotlinVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        }
        IdeKotlinVersion compilerVersionFromSettings = ideKotlinVersion;
        Module baseModule = moduleGroup.getBaseModule();
        return new AutoConfigurationSettings(baseModule, compilerVersionFromSettings);
    }

    @Override
    public boolean isAutoConfigurationEnabled() {
        return Registry.Companion.is("kotlin.configuration.maven.autoConfig.enabled", true);
    }

    @Override
    @Nullable
    public Object runAutoConfig(@NotNull AutoConfigurationSettings settings2, @NotNull Continuation<? super Unit> $completion) {
        return KotlinMavenConfigurator.runAutoConfig$suspendImpl(this, settings2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object runAutoConfig$suspendImpl(KotlinMavenConfigurator $this, AutoConfigurationSettings settings, Continuation<? super Unit> $completion) {
        if (!($completion instanceof runAutoConfig.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ KotlinMavenConfigurator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinMavenConfigurator.runAutoConfig$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                module = settings.getModule();
                v0 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                project = v0;
                KotlinJ2KOnboardingFUSCollector.INSTANCE.logStartConfigureKt(project, true);
                size$iv = 100;
                $i$f$reportSequentialProgress = 0;
                $continuation.L$0 = $this;
                $continuation.L$1 = settings;
                $continuation.L$2 = module;
                $continuation.L$3 = project;
                $continuation.I$0 = size$iv;
                $continuation.I$1 = $i$f$reportSequentialProgress;
                $continuation.label = 1;
                v1 = ContextKt.internalCurrentStepAsSequential((int)size$iv, (Continuation)$continuation);
                if (v1 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl40
            }
            case 1: {
                $i$f$reportSequentialProgress = $continuation.I$1;
                size$iv = $continuation.I$0;
                project = (Project)$continuation.L$3;
                module = (Module)$continuation.L$2;
                settings = (AutoConfigurationSettings)$continuation.L$1;
                $this = (KotlinMavenConfigurator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                var7_14 = (AutoCloseable)v1;
                var8_15 = null;
                it$iv = (SequentialProgressReporterHandle)var7_14;
                $i$a$-use-StepsKt$reportSequentialProgress$2$iv = 0;
                reporter = it$iv.getReporter();
                $i$a$-reportSequentialProgress$default-KotlinMavenConfigurator$runAutoConfig$2 = 0;
                reporter.nextStep(30, KotlinProjectConfigurationBundle.message("step.configure.kotlin.preparing", new Object[0]));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)settings);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)module);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$4 = var7_14;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)it$iv);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)reporter);
                $continuation.I$0 = size$iv;
                $continuation.I$1 = $i$f$reportSequentialProgress;
                $continuation.I$2 = $i$a$-use-StepsKt$reportSequentialProgress$2$iv;
                $continuation.I$3 = $i$a$-reportSequentialProgress$default-KotlinMavenConfigurator$runAutoConfig$2;
                $continuation.label = 2;
                v2 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, runAutoConfig$lambda$0$0(com.intellij.openapi.project.Project com.intellij.openapi.module.Module com.intellij.platform.util.progress.SequentialProgressReporter org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator org.jetbrains.kotlin.idea.configuration.AutoConfigurationSettings ), ()Lkotlin/Unit;)((Project)project, (Module)module, (SequentialProgressReporter)reporter, (KotlinMavenConfigurator)$this, (AutoConfigurationSettings)settings), (Continuation)$continuation);
                ** if (v2 != var15_5) goto lbl64
lbl63:
                // 1 sources

                return var15_5;
lbl64:
                // 1 sources

                ** GOTO lbl82
            }
            case 2: {
                $i$a$-reportSequentialProgress$default-KotlinMavenConfigurator$runAutoConfig$2 = $continuation.I$3;
                $i$a$-use-StepsKt$reportSequentialProgress$2$iv = $continuation.I$2;
                $i$f$reportSequentialProgress = $continuation.I$1;
                size$iv = $continuation.I$0;
                reporter = (SequentialProgressReporter)$continuation.L$6;
                it$iv = (SequentialProgressReporterHandle)$continuation.L$5;
                var8_15 = null;
                var7_14 = (AutoCloseable)$continuation.L$4;
                project = (Project)$continuation.L$3;
                module = (Module)$continuation.L$2;
                settings = (AutoConfigurationSettings)$continuation.L$1;
                $this = (KotlinMavenConfigurator)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl82:
                    // 2 sources

                    var9_16 = Unit.INSTANCE;
                    ** GOTO lbl92
                }
                catch (Throwable var10_19) {
                    var8_15 = var10_19;
                    throw var10_19;
                }
            }
            catch (Throwable var10_20) {
                throw var10_20;
            }
            {
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)var7_14, (Throwable)var8_15);
                }
lbl92:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract boolean isRelevantGoal(@NotNull String var1);

    protected abstract void createExecutions(@NotNull PomFile var1, @NotNull MavenDomPlugin var2, @NotNull Module var3);

    @NotNull
    protected abstract String getStdlibArtifactId(@NotNull Module var1, @NotNull IdeKotlinVersion var2);

    public boolean configureModule(@NotNull Module module, @NotNull PsiFile file, @NotNull IdeKotlinVersion version, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        return this.changePomFile(module, file, version, collector2);
    }

    private final boolean configureModuleSilently(Module module, PsiFile file, IdeKotlinVersion version) {
        return this.changePomFile(module, file, version, null);
    }

    private final boolean changePomFile(Module module, PsiFile file, IdeKotlinVersion version, NotificationMessageCollector collector2) {
        block6: {
            RepositoryDescription repositoryDescription;
            VirtualFile virtualFile = file.getVirtualFile();
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (virtualFile == null) {
                KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed(project2, KotlinJ2KOnboardingConfigurationError.VIRTUAL_FILE_DOESNT_EXIST_FOR_PSI_FILE);
                throw new IllegalStateException(("Virtual file should exists for psi file " + file.getName()).toString());
            }
            MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)project2, (VirtualFile)virtualFile);
            if (domModel == null) {
                KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed(project2, KotlinJ2KOnboardingConfigurationError.DOM_MODEL_DOESNT_EXIST);
                KotlinMavenConfigurator.Companion.showErrorMessage(project2, null);
                return false;
            }
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
            PomFile pom = PomFile.Companion.forFileOrNull((XmlFile)file);
            if (pom == null) {
                KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed(project2, KotlinJ2KOnboardingConfigurationError.WASNT_ABLE_TO_TRANSFORM_XML_TO_POM);
                return false;
            }
            pom.addProperty(KOTLIN_VERSION_PROPERTY, version.getArtifactVersion());
            pom.addDependency(new MavenId(GROUP_ID, this.getStdlibArtifactId(module, version), "${kotlin.version}"), MavenArtifactScope.COMPILE, null, false, null);
            if (this.testArtifactId != null) {
                pom.addDependency(new MavenId(GROUP_ID, this.testArtifactId, "${kotlin.version}"), MavenArtifactScope.TEST, null, false, null);
            }
            if (this.addJunit) {
                pom.addDependency(new MavenId("junit", "junit", "4.12"), MavenArtifactScope.TEST, null, false, null);
            }
            if ((repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(version)) != null) {
                pom.addLibraryRepository(repositoryDescription);
                pom.addPluginRepository(repositoryDescription);
            }
            MavenDomPlugin plugin = pom.addPlugin(new MavenId(GROUP_ID, MAVEN_PLUGIN_ID, "${kotlin.version}"));
            this.createExecutions(pom, plugin, module);
            this.configurePlugin(pom, plugin, module, version);
            CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)file));
            NotificationMessageCollector notificationMessageCollector = collector2;
            if (notificationMessageCollector == null) break block6;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getPath(), (String)"getPath(...)");
            notificationMessageCollector.addMessage(KotlinMavenBundle.message("file.was.modified", objectArray));
        }
        return true;
    }

    protected void configurePlugin(@NotNull PomFile pom, @NotNull MavenDomPlugin plugin, @NotNull Module module, @Nullable IdeKotlinVersion version) {
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
    }

    protected final void createExecution(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String executionId, @NotNull String goalName, @NotNull Module module, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)pomFile, (String)"pomFile");
        Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)goalName, (String)"goalName");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        pomFile.addKotlinExecution(module, kotlinPlugin, executionId, PomFile.Companion.getPhase(false, isTest), isTest, CollectionsKt.listOf((Object)goalName));
    }

    @Override
    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        boolean runtimeUpdateRequired;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        if (ideKotlinVersion != null && (ideKotlinVersion = ideKotlinVersion.getApiVersion()) != null) {
            IdeKotlinVersion runtimeVersion = ideKotlinVersion;
            boolean bl = false;
            v1 = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
        } else {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired) {
            Object[] objectArray = new Object[]{requiredStdlibVersion};
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature", objectArray), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
            return;
        }
        PsiElement element = KotlinMavenConfigurator.updateLanguageVersion$doUpdateMavenLanguageVersion(module, languageVersion, apiVersion);
        if (element == null) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
        } else {
            new OpenFileDescriptor(module.getProject(), element.getContainingFile().getVirtualFile(), element.getTextRange().getStartOffset()).navigate(true);
        }
    }

    @Override
    @Deprecated(message="Please implement/use the KotlinBuildSystemDependencyManager EP instead.", replaceWith=@ReplaceWith(expression="KotlinBuildSystemDependencyManager.findApplicableConfigurator(module)?.addDependency(module, library.withScope(scope))", imports={}))
    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element, @NotNull ExternalLibraryDescriptor library, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull DependencyScope scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        DependencyScope dependencyScope = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"suggestScopeByLocation(...)");
        DependencyScope scope2 = dependencyScope;
        JavaProjectModelModificationService.getInstance((Project)module.getProject()).addDependency(module, library, scope2);
    }

    @Override
    public void changeGeneralFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        String messageTitle = AbstractChangeFeatureSupportLevelFix.Companion.getFixText(state, feature.getPresentableName());
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.getRuntimeLibraryVersionOrDefault(module).getApiVersion().compareTo(sinceVersion) < 0) {
            Object[] objectArray = new Object[]{feature.getPresentableName(), sinceVersion};
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature.support", objectArray), (String)messageTitle);
            return;
        }
        PsiElement element = this.changeMavenFeatureConfiguration(module, feature, state, messageTitle);
        if (element != null) {
            new OpenFileDescriptor(module.getProject(), element.getContainingFile().getVirtualFile(), element.getTextRange().getStartOffset()).navigate(true);
        }
    }

    private final PsiElement changeMavenFeatureConfiguration(Module module, LanguageFeature feature, LanguageFeature.State state, @NlsContexts.DialogTitle String messageTitle) {
        PsiFile psiFile = Companion.findModulePomFile(module);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi);
        if (pomFile == null) {
            return null;
        }
        PomFile pom = pomFile;
        PsiElement element = PomFileKt.changeFeatureConfiguration(pom, feature, state);
        if (element == null) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)messageTitle);
        }
        return element;
    }

    private final boolean isMavenSyncPending(Project $this$isMavenSyncPending, Module module) {
        return KotlinProjectConfigurationService.Companion.getInstance($this$isMavenSyncPending).isSyncDesired(module);
    }

    private final boolean isMavenSyncInProgress(Project $this$isMavenSyncInProgress) {
        return KotlinProjectConfigurationService.Companion.getInstance($this$isMavenSyncInProgress).isSyncing();
    }

    private static final PsiFile getStatus$lambda$0(Module $module) {
        return Companion.findModulePomFile($module);
    }

    private static final ConfigureKotlinStatus getStatus$lambda$1(KotlinMavenConfigurator this$0, Module $module, PsiFile $psi) {
        return this$0.checkPluginConfiguration($module, (XmlFile)$psi);
    }

    private static final Unit configureAndGetConfiguredModules$lambda$0(Project $project, ConfigureDialogWithModulesAndVersion $dialog, KotlinMavenConfigurator this$0, String $kotlinVersion, Set $configuredModules) {
        NotificationMessageCollector collector2 = NotificationMessageCollector.Companion.create($project);
        for (Module module : MavenModulesRelationshipKt.excludeMavenChildrenModules($project, $dialog.getModulesToConfigure())) {
            PsiFile file = Companion.findModulePomFile(module);
            if (file != null) {
                boolean configured = this$0.configureModule(module, file, IdeKotlinVersion.Companion.get($kotlinVersion), collector2);
                if (configured) {
                    this$0.queueSyncIfNeeded($project);
                    VirtualFile virtualFile = file.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    OpenFileAction.Companion.openFile(virtualFile, $project);
                    $configuredModules.add(module);
                    continue;
                }
                KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed($project, KotlinJ2KOnboardingConfigurationError.OTHER);
                continue;
            }
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed($project, KotlinJ2KOnboardingConfigurationError.BUILD_SCRIPT_FOR_MODULE_IS_ABSENT_OR_NOT_WRITABLE);
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)module.getName(), (String)"getName(...)");
            KotlinMavenConfigurator.Companion.showErrorMessage($project, KotlinMavenBundle.message("error.cant.find.pom.for.module", objectArray));
        }
        KotlinMavenAutoConfigurationNotificationHolder notificationHolder = KotlinMavenAutoConfigurationNotificationHolder.Companion.getInstance($project);
        notificationHolder.onManualConfigurationCompleted();
        collector2.showNotification();
        this$0.addUndoConfigurationListener($project, null, false, notificationHolder);
        ConfigureKotlinNotificationManager.INSTANCE.expireOldNotifications($project);
        return Unit.INSTANCE;
    }

    private static final AutoConfigurationSettings calculateAutoConfigSettings$lambda$0(KotlinMavenConfigurator this$0, Module $module) {
        return this$0.calculateAutoConfigSettingsReadAction($module);
    }

    private static final Unit runAutoConfig$lambda$0$0$0(Module $module, SequentialProgressReporter $reporter, KotlinMavenConfigurator this$0, AutoConfigurationSettings $settings, Project $project) {
        PsiFile file = Companion.findModulePomFile($module);
        $reporter.nextStep(100, KotlinProjectConfigurationBundle.message("step.configure.kotlin.writing", new Object[0]));
        if (file != null) {
            ChangedConfiguratorFiles changedBuildFiles = new ChangedConfiguratorFiles();
            changedBuildFiles.storeOriginalFileContent(file);
            boolean configured = this$0.configureModuleSilently($module, file, $settings.getKotlinVersion());
            if (configured) {
                this$0.queueSyncIfNeeded($project);
                KotlinMavenAutoConfigurationNotificationHolder notificationHolder = KotlinMavenAutoConfigurationNotificationHolder.Companion.getInstance($project);
                this$0.addUndoConfigurationListener($project, CollectionsKt.listOf((Object)$module), true, notificationHolder);
                notificationHolder.showAutoConfiguredNotification($module.getName(), changedBuildFiles.calculateChanges());
                NotificationMessageCollector collector2 = NotificationMessageCollector.Companion.create($project);
                collector2.showNotification();
                ConfigureKotlinNotificationManager.INSTANCE.expireOldNotifications($project);
            } else {
                KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed($project, KotlinJ2KOnboardingConfigurationError.OTHER);
            }
        } else {
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtFailed($project, KotlinJ2KOnboardingConfigurationError.BUILD_SCRIPT_FOR_MODULE_IS_ABSENT_OR_NOT_WRITABLE);
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)$module.getName(), (String)"getName(...)");
            KotlinMavenConfigurator.Companion.showErrorMessage($project, KotlinMavenBundle.message("error.cant.find.pom.for.module", objectArray));
        }
        return Unit.INSTANCE;
    }

    private static final Unit runAutoConfig$lambda$0$0(Project $project, Module $module, SequentialProgressReporter $reporter, KotlinMavenConfigurator this$0, AutoConfigurationSettings $settings) {
        ApplicationUtilsKt.executeWriteCommand($project, KotlinProjectConfigurationBundle.message("command.name.configure.kotlin.automatically", new Object[0]), (Function0<Unit>)((Function0)() -> KotlinMavenConfigurator.runAutoConfig$lambda$0$0$0($module, $reporter, this$0, $settings, $project)));
        return Unit.INSTANCE;
    }

    private static final PsiElement updateLanguageVersion$doUpdateMavenLanguageVersion(Module $module, String $languageVersion, String $apiVersion) {
        PsiFile psiFile = Companion.findModulePomFile($module);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi);
        if (pomFile == null) {
            return null;
        }
        PomFile pom = pomFile;
        return PomFileKt.changeLanguageVersion(pom, $languageVersion, $apiVersion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator$Companion;", "", "<init>", "()V", "GROUP_ID", "", "MAVEN_PLUGIN_ID", "KOTLIN_VERSION_PROPERTY", "kotlinPluginId", "Lorg/jetbrains/idea/maven/model/MavenId;", "version", "findModulePomFile", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "canConfigureFile", "", "file", "showErrorMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "intellij.kotlin.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MavenId kotlinPluginId(@Nullable String version) {
            return new MavenId(KotlinMavenConfigurator.GROUP_ID, KotlinMavenConfigurator.MAVEN_PLUGIN_ID, version);
        }

        public static /* synthetic */ MavenId kotlinPluginId$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.kotlinPluginId(string);
        }

        @Nullable
        public final PsiFile findModulePomFile(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            List list2 = MavenProjectsManager.getInstance((Project)module.getProject()).getProjectsFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getProjectsFiles(...)");
            List files = list2;
            for (VirtualFile file : files) {
                PsiFile psiFile;
                Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)module.getProject());
                if (!Intrinsics.areEqual((Object)module, (Object)fileModule) || PsiManager.getInstance((Project)module.getProject()).findFile(file) == null || !MavenDomUtil.isProjectFile((PsiFile)psiFile) || !this.canConfigureFile(psiFile)) continue;
                return psiFile;
            }
            return null;
        }

        private final boolean canConfigureFile(PsiFile file) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file.getVirtualFile(), null);
        }

        private final void showErrorMessage(Project project, @NlsContexts.DialogMessage String message2) {
            String cantConfigureAutomatically = KotlinMavenBundle.message("error.cant.configure.maven.automatically", new Object[0]);
            String seeInstructions = KotlinMavenBundle.message("error.see.installation.instructions", new Object[0]);
            String string = message2;
            Messages.showErrorDialog((Project)project, (String)("<html>" + cantConfigureAutomatically + "<br/>" + (String)(string != null ? string + "</br>" : "") + seeInstructions + "</html>"), (String)KotlinMavenBundle.message("configure.title", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

