/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.presentation.KotlinDefaultNamedDeclarationPresentation;
import org.jetbrains.kotlin.idea.presentation.KotlinFunctionPresentation;
import org.jetbrains.kotlin.idea.presentation.KtJvmNameAnnotatedFilePresentation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0016\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotationPresenter;", "Lcom/intellij/navigation/ItemPresentationProvider;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "<init>", "()V", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "annotationEntry", "toItemPresentation", "Lcom/intellij/psi/PsiElement;", "getDeclarationPresentation", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "intellij.kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nAnnotationPresenters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationPresenters.kt\norg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotationPresenter\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,54:1\n66#2,2:55\n*S KotlinDebug\n*F\n+ 1 AnnotationPresenters.kt\norg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotationPresenter\n*L\n28#1:55,2\n*E\n"})
public final class KtJvmNameAnnotationPresenter
implements ItemPresentationProvider<KtAnnotationEntry> {
    @Nullable
    public ItemPresentation getPresentation(@NotNull KtAnnotationEntry annotationEntry) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
        Name name2 = annotationEntry.getShortName();
        if (!Intrinsics.areEqual((Object)(name2 != null ? name2.asString() : null), (Object)JvmFileClassUtil.INSTANCE.getJVM_NAME_SHORT())) {
            return null;
        }
        PsiElement psiElement = annotationEntry.getParent().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        return this.toItemPresentation(psiElement, annotationEntry);
    }

    private final ItemPresentation toItemPresentation(PsiElement $this$toItemPresentation, KtAnnotationEntry annotationEntry) {
        ItemPresentation itemPresentation;
        PsiElement psiElement = $this$toItemPresentation;
        if (psiElement instanceof KtFile) {
            itemPresentation = new KtJvmNameAnnotatedFilePresentation(annotationEntry);
        } else if (psiElement instanceof KtFunction) {
            itemPresentation = (ItemPresentation)new KotlinFunctionPresentation((KtFunction)$this$toItemPresentation, JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(annotationEntry));
        } else if (psiElement instanceof KtNamedDeclaration) {
            itemPresentation = this.getDeclarationPresentation((KtNamedDeclaration)$this$toItemPresentation, annotationEntry);
        } else if (psiElement instanceof KtPropertyAccessor) {
            PsiElement $this$parentOfType_u24default$iv = $this$toItemPresentation;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtProperty.class, (boolean)true);
            if (ktProperty == null) {
                return null;
            }
            KtProperty property = ktProperty;
            itemPresentation = this.getDeclarationPresentation((KtNamedDeclaration)property, annotationEntry);
        } else if (psiElement instanceof KtFileAnnotationList) {
            PsiElement psiElement2 = ((KtFileAnnotationList)$this$toItemPresentation).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
            itemPresentation = this.toItemPresentation(psiElement2, annotationEntry);
        } else {
            itemPresentation = null;
        }
        return itemPresentation;
    }

    private final ItemPresentation getDeclarationPresentation(KtNamedDeclaration declaration, KtAnnotationEntry annotationEntry) {
        return (ItemPresentation)new KotlinDefaultNamedDeclarationPresentation(declaration, annotationEntry){
            final /* synthetic */ KtAnnotationEntry $annotationEntry;
            {
                this.$annotationEntry = $annotationEntry;
                super($declaration);
            }

            public String getPresentableText() {
                return JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(this.$annotationEntry);
            }
        };
    }
}

