/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectConfiguration;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.projectConfiguration.CommonStandardLibraryDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmJsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmWasiIdePlatformKind;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017\u001a$\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u0007*\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u001a$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 \u00a8\u0006!"}, d2={"getLibraryDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "project", "Lcom/intellij/openapi/project/Project;", "platformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getJvmStdlibArtifactId", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getDefaultJvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "hasJdkLikeUpdatedRuntime", "", "hasJreSpecificRuntime", "findKotlinRuntimeLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "module", "Lcom/intellij/openapi/module/Module;", "checkUpdateRuntime", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "askUpdateRuntime", "librariesToUpdate", "", "toMavenArtifactVersion", "updateLibraries", "", "upToMavenVersion", "libraries", "", "intellij.kotlin.projectConfiguration"})
@JvmName(name="KotlinProjectConfigurationUtils")
@SourceDebugExtension(value={"SMAP\nKotlinProjectConfigurationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectConfigurationUtils.kt\norg/jetbrains/kotlin/idea/projectConfiguration/KotlinProjectConfigurationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,208:1\n1#2:209\n1#2:224\n3938#3:210\n4474#3,2:211\n13225#3,2:228\n14060#3,2:230\n1642#4,10:213\n1915#4:223\n1916#4:225\n1652#4:226\n1915#4,2:232\n73#5:227\n*S KotlinDebug\n*F\n+ 1 KotlinProjectConfigurationUtils.kt\norg/jetbrains/kotlin/idea/projectConfiguration/KotlinProjectConfigurationUtils\n*L\n117#1:224\n111#1:210\n111#1:211,2\n177#1:228,2\n198#1:230,2\n117#1:213,10\n117#1:223\n117#1:225\n117#1:226\n203#1:232,2\n127#1:227\n*E\n"})
public final class KotlinProjectConfigurationUtils {
    @Nullable
    public static final CustomLibraryDescription getLibraryDescription(@NotNull Project project, @NotNull IdePlatformKind platformKind) {
        CustomLibraryDescription customLibraryDescription;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
        IdePlatformKind idePlatformKind = platformKind;
        if (Intrinsics.areEqual((Object)idePlatformKind, (Object)CommonIdePlatformKind.INSTANCE)) {
            customLibraryDescription = new CommonStandardLibraryDescription(project);
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)JvmIdePlatformKind.INSTANCE)) {
            customLibraryDescription = new JavaRuntimeLibraryDescription(project);
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)JsIdePlatformKind.INSTANCE)) {
            customLibraryDescription = new JSLibraryStdDescription(project);
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)WasmJsIdePlatformKind.INSTANCE)) {
            customLibraryDescription = null;
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)WasmWasiIdePlatformKind.INSTANCE)) {
            customLibraryDescription = null;
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)NativeIdePlatformKind.INSTANCE)) {
            customLibraryDescription = null;
        } else {
            throw new IllegalArgumentException("Unsupported platform kind: " + platformKind);
        }
        return customLibraryDescription;
    }

    @NotNull
    public static final String getJvmStdlibArtifactId(@Nullable Sdk sdk, @NotNull IdeKotlinVersion version) {
        Sdk sdk2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                if (!KotlinProjectConfigurationUtils.hasJreSpecificRuntime(version)) {
                    return "kotlin-stdlib";
                }
                sdk2 = sdk;
                if (sdk2 == null) break block5;
                Sdk it = sdk2;
                boolean bl = false;
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(it);
                sdk2 = javaSdkVersion;
                if (javaSdkVersion != null) break block6;
            }
            return "kotlin-stdlib";
        }
        Sdk jdkVersion = sdk2;
        if (KotlinProjectConfigurationUtils.hasJdkLikeUpdatedRuntime(version)) {
            return jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8) ? "kotlin-stdlib-jdk8" : (jdkVersion == JavaSdkVersion.JDK_1_7 ? "kotlin-stdlib-jdk7" : "kotlin-stdlib");
        }
        return jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8) ? "kotlin-stdlib-jre8" : (jdkVersion == JavaSdkVersion.JDK_1_7 ? "kotlin-stdlib-jre7" : "kotlin-stdlib");
    }

    @Nullable
    public static final JvmTarget getDefaultJvmTarget(@Nullable Sdk sdk, @NotNull IdeKotlinVersion version) {
        Sdk sdk2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                if (!KotlinProjectConfigurationUtils.hasJreSpecificRuntime(version)) {
                    return null;
                }
                sdk2 = sdk;
                if (sdk2 == null) break block4;
                Sdk it = sdk2;
                boolean bl = false;
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(it);
                sdk2 = javaSdkVersion;
                if (javaSdkVersion != null) break block5;
            }
            return null;
        }
        Sdk jdkVersion = sdk2;
        return jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8) ? JvmTarget.JVM_1_8 : (jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6) ? JvmTarget.JVM_1_6 : null);
    }

    @ApiStatus.Internal
    public static final boolean hasJdkLikeUpdatedRuntime(@NotNull IdeKotlinVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return version.compare("1.2.0-rc-39") >= 0 || version.isSnapshot();
    }

    @ApiStatus.Internal
    public static final boolean hasJreSpecificRuntime(@NotNull IdeKotlinVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return version.compare("1.1.0") >= 0 || version.isSnapshot();
    }

    @Nullable
    public static final Library findKotlinRuntimeLibrary(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return ProjectStructureUtils.findLibrary(module, (Function1<? super Library, Boolean>)((Function1)arg_0 -> KotlinProjectConfigurationUtils.findKotlinRuntimeLibrary$lambda$0(project2, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkUpdateRuntime(@NotNull Project project, @NotNull ApiVersion requiredVersion) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Module[] $this$filter$iv = ProjectUtil.getModules((Project)project);
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Iterable<void> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void module = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion((Module)module);
            Object parsedModuleRuntimeVersion = ideKotlinVersion != null ? ideKotlinVersion.getApiVersion() : null;
            if (!(parsedModuleRuntimeVersion != null && parsedModuleRuntimeVersion.compareTo(requiredVersion) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modulesWithOutdatedRuntime = (List)destination$iv$iv;
        if (!((Collection)modulesWithOutdatedRuntime).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = modulesWithOutdatedRuntime;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Library it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Module it = (Module)element$iv$iv;
                boolean bl2 = false;
                if (KotlinProjectConfigurationUtils.findKotlinRuntimeLibrary(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List librariesToUpdate = (List)destination$iv$iv2;
            if (!KotlinProjectConfigurationUtils.askUpdateRuntime(project, requiredVersion, librariesToUpdate)) {
                return false;
            }
        }
        return true;
    }

    public static final boolean askUpdateRuntime(@NotNull Project project, @NotNull ApiVersion requiredVersion, @NotNull List<? extends Library> librariesToUpdate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Intrinsics.checkNotNullParameter(librariesToUpdate, (String)"librariesToUpdate");
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] objectArray = new Object[]{requiredVersion};
            int rc = Messages.showOkCancelDialog((Project)project, (String)KotlinProjectConfigurationBundle.message("this.language.feature.requires.version.0.or.later.of.the.kotlin.runtime.library.would.you.like.to.update.the.runtime.library.in.your.project", objectArray), (String)KotlinProjectConfigurationBundle.message("update.runtime.library", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc != 0) {
                return false;
            }
        }
        String string = KotlinProjectConfigurationUtils.toMavenArtifactVersion(requiredVersion, project);
        if (string == null) {
            boolean bl = false;
            Messages.showErrorDialog((String)KotlinProjectConfigurationBundle.message("cant.fetch.available.maven.versions", new Object[0]), (String)KotlinProjectConfigurationBundle.message("cant.fetch.available.maven.versions.title", new Object[0]));
            return false;
        }
        String upToMavenVersion = string;
        KotlinProjectConfigurationUtils.updateLibraries(project, upToMavenVersion, (Collection<? extends Library>)librariesToUpdate);
        return true;
    }

    private static final String toMavenArtifactVersion(ApiVersion $this$toMavenArtifactVersion, Project project) {
        ApiVersion apiVersion = $this$toMavenArtifactVersion;
        Ref.ObjectRef mavenVersion = new Ref.ObjectRef();
        String string = KotlinProjectConfigurationBundle.message("fetching.available.maven.versions.title", new Object[0]);
        new Task.Modal(project, apiVersion, (Ref.ObjectRef<String>)mavenVersion, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ ApiVersion $apiVersion;
            final /* synthetic */ Ref.ObjectRef<String> $mavenVersion;
            {
                this.$project = $project;
                this.$apiVersion = $apiVersion;
                this.$mavenVersion = $mavenVersion;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Version version;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RepositoryLibraryProperties repositoryLibraryProperties = LibraryJarDescriptor.RUNTIME_JDK8_JAR.getRepositoryLibraryProperties();
                List list2 = new ArtifactRepositoryManager(JarRepositoryManager.getJPSLocalMavenRepositoryForIdeaProject((Project)this.$project).toFile()).getAvailableVersions(repositoryLibraryProperties.getGroupId(), repositoryLibraryProperties.getArtifactId(), "[" + this.$apiVersion.getVersionString() + ",)", ArtifactKind.ARTIFACT);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAvailableVersions(...)");
                Version version2 = version = (Version)CollectionsKt.firstOrNull((List)list2);
                this.$mavenVersion.element = version2 != null ? version2.toString() : null;
            }
        }.queue();
        return (String)mavenVersion.element;
    }

    public static final boolean askUpdateRuntime(@NotNull Module module, @NotNull ApiVersion requiredVersion) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Library library = KotlinProjectConfigurationUtils.findKotlinRuntimeLibrary(module);
        if (library == null) {
            return true;
        }
        Library library2 = library;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return KotlinProjectConfigurationUtils.askUpdateRuntime(project, requiredVersion, CollectionsKt.listOf((Object)library2));
    }

    public static final void updateLibraries(@NotNull Project project, @NotNull String upToMavenVersion, @NotNull Collection<? extends Library> libraries) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)upToMavenVersion, (String)"upToMavenVersion");
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            Module[] $this$any$iv = ProjectUtil.getModules((Project)project);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                Module element$iv;
                Module module = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!(BuildSystemTypeKt.getBuildSystemType(module) != BuildSystemType.JPS)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            String message2 = KotlinProjectConfigurationBundle.message("automatic.library.version.update.for.maven.and.gradle.projects.is.currently.unsupported.please.update.your.build.scripts.manually", new Object[0]);
            String title = KotlinProjectConfigurationBundle.message("update.kotlin.runtime.library", new Object[0]);
            Messages.showMessageDialog((Project)project, (String)message2, (String)title, (Icon)Messages.getErrorIcon());
            return;
        }
        Sequence librariesToUpdate = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)libraries), KotlinProjectConfigurationUtils::updateLibraries$lambda$1), KotlinProjectConfigurationUtils::updateLibraries$lambda$2), KotlinProjectConfigurationUtils::updateLibraries$lambda$3);
        for (Pair pair : librariesToUpdate) {
            LibraryEx library = (LibraryEx)pair.component1();
            RepositoryLibraryProperties properties = (RepositoryLibraryProperties)pair.component2();
            ProjectStructureUtils.updateEx(library, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)((Function1)arg_0 -> KotlinProjectConfigurationUtils.updateLibraries$lambda$4(properties, upToMavenVersion, project, arg_0)));
        }
    }

    private static final boolean findKotlinRuntimeLibrary$lambda$0(Project $project, Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return StdlibDetectorFacility.isStdlib$default(KotlinJvmStdlibDetectorFacility.INSTANCE, $project, library, false, 4, null) || StdlibDetectorFacility.isStdlib$default(KotlinJavaScriptStdlibDetectorFacility.INSTANCE, $project, library, false, 4, null);
    }

    private static final LibraryEx updateLibraries$lambda$1(Library it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof LibraryEx ? (LibraryEx)it : null;
    }

    private static final Pair updateLibraries$lambda$2(LibraryEx library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        LibraryProperties libraryProperties = library.getProperties();
        RepositoryLibraryProperties repositoryLibraryProperties = libraryProperties instanceof RepositoryLibraryProperties ? (RepositoryLibraryProperties)libraryProperties : null;
        if (repositoryLibraryProperties == null) {
            return null;
        }
        RepositoryLibraryProperties properties = repositoryLibraryProperties;
        return TuplesKt.to((Object)library, (Object)properties);
    }

    private static final boolean updateLibraries$lambda$3(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)pair.component2();
        return Intrinsics.areEqual((Object)properties.getGroupId(), (Object)"org.jetbrains.kotlin");
    }

    private static final Unit updateLibraries$lambda$4(RepositoryLibraryProperties $properties, String $upToMavenVersion, Project $project, LibraryEx.ModifiableModelEx modifiableModel) {
        Intrinsics.checkNotNullParameter((Object)modifiableModel, (String)"modifiableModel");
        modifiableModel.setProperties((LibraryProperties)new RepositoryLibraryProperties($properties.getGroupId(), $properties.getMavenId(), $upToMavenVersion));
        Object[] objectArray = new OrderRootType[]{OrderRootType.SOURCES, OrderRootType.CLASSES, OrderRootType.DOCUMENTATION};
        for (OrderRootType orderRootType : CollectionsKt.listOf((Object[])objectArray)) {
            String[] stringArray = modifiableModel.getUrls(orderRootType);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
            Object[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                modifiableModel.removeRoot(it, orderRootType);
            }
        }
        Collection collection = JarRepositoryManager.loadDependenciesModal((Project)$project, (RepositoryLibraryProperties)$properties, (boolean)true, (boolean)true, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"loadDependenciesModal(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrderRoot it = (OrderRoot)element$iv;
            boolean bl = false;
            modifiableModel.addRoot(it.getFile(), it.getType());
        }
        return Unit.INSTANCE;
    }
}

