/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.FileNodeWithNestedFileNodes;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.base.util.KotlinSingleClassFileAnalyzer;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtInternalFileTreeNode;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J<\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00072\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/projectView/KotlinExpandNodeProjectViewProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "asKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "intellij.kotlin.base.projectStructure"})
public final class KotlinExpandNodeProjectViewProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<? extends Object>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<? extends AbstractTreeNode<?>> children, @NotNull ViewSettings settings2) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (AbstractTreeNode<?> child : children) {
            boolean bl;
            Object nestedFileNodes;
            Object value;
            Object object = value = child.getValue();
            KtFile ktFile2 = object != null ? this.asKtFile(object) : null;
            Object object2 = child instanceof FileNodeWithNestedFileNodes ? (FileNodeWithNestedFileNodes)child : null;
            if (object2 == null || (object2 = object2.getNestedFileNodes()) == null) {
                object2 = nestedFileNodes = (Collection)CollectionsKt.emptyList();
            }
            if (ktFile2 != null) {
                KtClassOrObject mainClass = KotlinSingleClassFileAnalyzer.getSingleClass(ktFile2);
                if (mainClass != null && mainClass.getContainingKtFile().getDeclarations().size() == 1) {
                    bl = result2.add((Object)new KtClassOrObjectTreeNode(ktFile2.getProject(), mainClass, settings2, (Collection<? extends AbstractTreeNode<?>>)nestedFileNodes));
                    continue;
                }
                bl = result2.add((Object)new KtFileTreeNode(ktFile2.getProject(), ktFile2, settings2, (Collection<? extends AbstractTreeNode<?>>)nestedFileNodes));
                continue;
            }
            bl = value instanceof KtLightClass ? result2.add((Object)new KtInternalFileTreeNode(((KtLightClass)value).getProject(), (KtLightClass)value, settings2, (Collection<? extends AbstractTreeNode<?>>)nestedFileNodes)) : result2.add(child);
        }
        return result2;
    }

    private final KtFile asKtFile(Object $this$asKtFile) {
        Object object;
        Object object2 = $this$asKtFile;
        if (object2 instanceof KtFile) {
            object = (KtFile)$this$asKtFile;
        } else if (object2 instanceof KtLightClassForFacade) {
            object = (KtFile)CollectionsKt.singleOrNull((Iterable)((KtLightClassForFacade)$this$asKtFile).getFiles());
        } else if (object2 instanceof KtLightClass) {
            PsiFile psiFile;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)((KtLightClass)$this$asKtFile).getKotlinOrigin();
            Object object3 = psiFile = ktClassOrObject != null ? ktClassOrObject.getContainingFile() : null;
            object = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        } else {
            object = null;
        }
        return object;
    }
}

