/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.RemoveAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.CopyAnnotationFromExpectToActualFix;
import org.jetbrains.kotlin.idea.quickfix.ReplaceAnnotationArgumentsInExpectActualFix;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualAnnotationsIncompatibilityType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJN\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015J,\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001a\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ActualAnnotationsNotMatchExpectFixFactoryCommon;", "", "<init>", "()V", "supportedAnnotationTargetsClasses", "", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "createRemoveAnnotationFromExpectFix", "Lcom/intellij/modcommand/ModCommandAction;", "expectAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "createCopyAndReplaceAnnotationFixes", "expectDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "actualDeclaration", "actualAnnotationTargetElement", "Lcom/intellij/psi/PsiElement;", "incompatibilityType", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualAnnotationsIncompatibilityType;", "annotationClassIdProvider", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/name/ClassId;", "createCopyFromExpectToActualFix", "skipFakeOverrideAndTypealias", "", "skipComplexScenario", "actualTarget", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nActualAnnotationsNotMatchExpectFixFactoryCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActualAnnotationsNotMatchExpectFixFactoryCommon.kt\norg/jetbrains/kotlin/idea/quickfix/ActualAnnotationsNotMatchExpectFixFactoryCommon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n2792#2,3:131\n1#3:134\n*S KotlinDebug\n*F\n+ 1 ActualAnnotationsNotMatchExpectFixFactoryCommon.kt\norg/jetbrains/kotlin/idea/quickfix/ActualAnnotationsNotMatchExpectFixFactoryCommon\n*L\n127#1:131,3\n*E\n"})
public final class ActualAnnotationsNotMatchExpectFixFactoryCommon {
    @NotNull
    public static final ActualAnnotationsNotMatchExpectFixFactoryCommon INSTANCE = new ActualAnnotationsNotMatchExpectFixFactoryCommon();
    @NotNull
    private static final List<KClass<? extends KtModifierListOwner>> supportedAnnotationTargetsClasses;

    private ActualAnnotationsNotMatchExpectFixFactoryCommon() {
    }

    @Nullable
    public final ModCommandAction createRemoveAnnotationFromExpectFix(@NotNull KtAnnotationEntry expectAnnotationEntry) {
        Intrinsics.checkNotNullParameter((Object)expectAnnotationEntry, (String)"expectAnnotationEntry");
        Name name2 = expectAnnotationEntry.getShortName();
        if (name2 == null) {
            return null;
        }
        Name annotationName = name2;
        Object[] objectArray = new Object[]{annotationName};
        return (ModCommandAction)new RemoveAnnotationFix(KotlinBundle.message((String)"fix.remove.mismatched.annotation.from.expect.declaration.may.change.semantics", (Object[])objectArray), expectAnnotationEntry);
    }

    @NotNull
    public final List<ModCommandAction> createCopyAndReplaceAnnotationFixes(@NotNull KtNamedDeclaration expectDeclaration, @NotNull KtNamedDeclaration actualDeclaration, @NotNull KtAnnotationEntry expectAnnotationEntry, @Nullable PsiElement actualAnnotationTargetElement, @NotNull ExpectActualAnnotationsIncompatibilityType<? extends KtAnnotationEntry> incompatibilityType, @NotNull Function0<ClassId> annotationClassIdProvider) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter((Object)expectDeclaration, (String)"expectDeclaration");
        Intrinsics.checkNotNullParameter((Object)actualDeclaration, (String)"actualDeclaration");
        Intrinsics.checkNotNullParameter((Object)expectAnnotationEntry, (String)"expectAnnotationEntry");
        Intrinsics.checkNotNullParameter(incompatibilityType, (String)"incompatibilityType");
        Intrinsics.checkNotNullParameter(annotationClassIdProvider, (String)"annotationClassIdProvider");
        if (this.skipFakeOverrideAndTypealias(expectDeclaration, actualDeclaration)) {
            return CollectionsKt.emptyList();
        }
        ExpectActualAnnotationsIncompatibilityType<? extends KtAnnotationEntry> expectActualAnnotationsIncompatibilityType = incompatibilityType;
        if (expectActualAnnotationsIncompatibilityType instanceof ExpectActualAnnotationsIncompatibilityType.MissingOnActual) {
            ktAnnotationEntry = null;
        } else if (expectActualAnnotationsIncompatibilityType instanceof ExpectActualAnnotationsIncompatibilityType.DifferentOnActual) {
            ktAnnotationEntry = (KtAnnotationEntry)((ExpectActualAnnotationsIncompatibilityType.DifferentOnActual)incompatibilityType).getActualAnnotation();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KtAnnotationEntry actualAnnotationEntry = ktAnnotationEntry;
        if (this.skipComplexScenario(expectAnnotationEntry, actualAnnotationTargetElement)) {
            return CollectionsKt.emptyList();
        }
        if (actualAnnotationEntry == null) {
            ModCommandAction copyFromExpect = this.createCopyFromExpectToActualFix(expectAnnotationEntry, actualAnnotationTargetElement, annotationClassIdProvider);
            return CollectionsKt.listOfNotNull((Object)copyFromExpect);
        }
        Name name2 = expectAnnotationEntry.getShortName();
        if (name2 == null) {
            return CollectionsKt.emptyList();
        }
        Name annotationName = name2;
        Object[] objectArray = new Object[]{annotationName};
        ReplaceAnnotationArgumentsInExpectActualFix fixOnActual = new ReplaceAnnotationArgumentsInExpectActualFix(KotlinBundle.message((String)"fix.replace.mismatched.annotation.args.on.actual.declaration.may.change.semantics", (Object[])objectArray), expectAnnotationEntry, actualAnnotationEntry);
        Object[] objectArray2 = new Object[]{annotationName};
        ReplaceAnnotationArgumentsInExpectActualFix fixOnExpect = new ReplaceAnnotationArgumentsInExpectActualFix(KotlinBundle.message((String)"fix.replace.mismatched.annotation.args.on.expect.declaration.may.change.semantics", (Object[])objectArray2), actualAnnotationEntry, expectAnnotationEntry);
        objectArray2 = new ReplaceAnnotationArgumentsInExpectActualFix[]{fixOnActual, fixOnExpect};
        return CollectionsKt.listOf((Object[])objectArray2);
    }

    private final ModCommandAction createCopyFromExpectToActualFix(KtAnnotationEntry expectAnnotationEntry, PsiElement actualAnnotationTargetElement, Function0<ClassId> annotationClassIdProvider) {
        if (!(actualAnnotationTargetElement instanceof KtModifierListOwner)) {
            return null;
        }
        ClassId classId = (ClassId)annotationClassIdProvider.invoke();
        if (classId == null) {
            return null;
        }
        ClassId annotationClassId = classId;
        return (ModCommandAction)new CopyAnnotationFromExpectToActualFix((KtModifierListOwner)actualAnnotationTargetElement, expectAnnotationEntry, annotationClassId);
    }

    private final boolean skipFakeOverrideAndTypealias(KtNamedDeclaration expectDeclaration, KtNamedDeclaration actualDeclaration) {
        return expectDeclaration instanceof KtClassOrObject && actualDeclaration instanceof KtClassOrObject ? ActualAnnotationsNotMatchExpectFixFactoryCommon.skipFakeOverrideAndTypealias$notEqual(KotlinPsiUtils.getClassIdIfNonLocal((KtClassOrObject)expectDeclaration), KotlinPsiUtils.getClassIdIfNonLocal((KtClassOrObject)actualDeclaration)) : (expectDeclaration instanceof KtCallableDeclaration && actualDeclaration instanceof KtCallableDeclaration ? ActualAnnotationsNotMatchExpectFixFactoryCommon.skipFakeOverrideAndTypealias$notEqual(KotlinPsiUtils.getCallableIdIfNotLocal((KtCallableDeclaration)expectDeclaration), KotlinPsiUtils.getCallableIdIfNotLocal((KtCallableDeclaration)actualDeclaration)) : false);
    }

    private final boolean skipComplexScenario(KtAnnotationEntry expectAnnotationEntry, PsiElement actualTarget) {
        boolean bl;
        block5: {
            if (expectAnnotationEntry.getUseSiteTarget() != null) {
                return true;
            }
            PsiElement psiElement = expectAnnotationEntry.getParent();
            KtModifierList ktModifierList = psiElement instanceof KtModifierList ? (KtModifierList)psiElement : null;
            if (ktModifierList == null || (ktModifierList = ktModifierList.getParent()) == null) {
                return true;
            }
            KtModifierList expectTarget = ktModifierList;
            Iterable $this$none$iv = supportedAnnotationTargetsClasses;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KClass it = (KClass)element$iv;
                    boolean bl2 = false;
                    if (!(it.isInstance((Object)expectTarget) && it.isInstance((Object)actualTarget))) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean skipFakeOverrideAndTypealias$notEqual(Object a, Object b) {
        if (!(a != null && b != null)) {
            boolean bl = false;
            String string = "expect and actual cannot be local, so must always have non-null ClassId";
            throw new IllegalStateException(string.toString());
        }
        return !Intrinsics.areEqual((Object)a, (Object)b);
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtClassLikeDeclaration.class), Reflection.getOrCreateKotlinClass(KtFunction.class), Reflection.getOrCreateKotlinClass(KtProperty.class), Reflection.getOrCreateKotlinClass(KtPropertyAccessor.class), Reflection.getOrCreateKotlinClass(KtTypeParameter.class), Reflection.getOrCreateKotlinClass(KtParameter.class), Reflection.getOrCreateKotlinClass(KtTypeReference.class)};
        supportedAnnotationTargetsClasses = CollectionsKt.listOf((Object[])objectArray);
    }
}

