/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationTargetFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.TypedArrayValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "<init>", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getText", "", "getFamilyName", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddAnnotationTargetFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddAnnotationTargetFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,232:1\n137#2:233\n*S KotlinDebug\n*F\n+ 1 AddAnnotationTargetFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix\n*L\n55#1:233\n*E\n"})
public final class AddAnnotationTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddAnnotationTargetFix(@NotNull KtAnnotationEntry annotationEntry) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
        super((PsiElement)annotationEntry);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"fix.add.annotation.target", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        ClassDescriptor annotationClassDescriptor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        Pair pair = AddAnnotationTargetFix.Companion.toAnnotationClass(annotationEntry);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        KtClass annotationClass = (KtClass)pair2.component1();
        List requiredAnnotationTargets = AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(annotationEntry, annotationClass, annotationClassDescriptor = (ClassDescriptor)pair2.component2(), project);
        if (requiredAnnotationTargets.isEmpty()) {
            return;
        }
        ExpectActualUtilKt.runOnExpectAndAllActuals$default((KtDeclaration)annotationClass, false, true, arg_0 -> AddAnnotationTargetFix.invoke$lambda$0(project, requiredAnnotationTargets, arg_0), 1, null);
    }

    private static final Unit invoke$lambda$0$0(Project $project, KtClass $ktClass, List $requiredAnnotationTargets) {
        KtPsiFactory psiFactory = new KtPsiFactory($project, false, 2, null);
        AddAnnotationTargetFixKt.access$addAnnotationTargets($ktClass, $requiredAnnotationTargets, psiFactory);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$0(Project $project, List $requiredAnnotationTargets, KtDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtDeclaration $this$safeAs$iv = it;
        boolean $i$f$safeAs = false;
        KtDeclaration ktDeclaration = $this$safeAs$iv;
        if (!(ktDeclaration instanceof KtClass)) {
            ktDeclaration = null;
        }
        KtClass ktClass = (KtClass)ktDeclaration;
        if (ktClass == null) {
            return Unit.INSTANCE;
        }
        KtClass ktClass2 = ktClass;
        ActionsKt.runWriteAction(() -> AddAnnotationTargetFix.invoke$lambda$0$0($project, ktClass2, $requiredAnnotationTargets));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005*\u00020\bH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "toAnnotationClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getExistingAnnotationTargets", "", "", "annotationClassDescriptor", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddAnnotationTargetFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddAnnotationTargetFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n296#2,2:233\n1642#2,10:236\n1915#2:246\n1916#2:249\n1652#2:250\n137#3:235\n137#3:247\n1#4:248\n*S KotlinDebug\n*F\n+ 1 AddAnnotationTargetFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion\n*L\n78#1:233,2\n82#1:236,10\n82#1:246\n82#1:249\n82#1:250\n80#1:235\n82#1:247\n82#1:248\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        private final Pair<KtClass, ClassDescriptor> toAnnotationClass(KtAnnotationEntry $this$toAnnotationClass) {
            Object object;
            ClassDescriptor annotationTypeDescriptor;
            block6: {
                block5: {
                    KtClass ktClass;
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$toAnnotationClass, BodyResolveMode.PARTIAL);
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$toAnnotationClass);
                    if (annotationDescriptor == null) {
                        return null;
                    }
                    AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                    ClassifierDescriptor classifierDescriptor = annotationDescriptor2.getType().getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        return null;
                    }
                    annotationTypeDescriptor = classDescriptor;
                    PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)annotationTypeDescriptor));
                    object = psiElement instanceof KtClass ? (KtClass)psiElement : null;
                    if (object == null) break block5;
                    KtClass it = ktClass = object;
                    boolean bl = false;
                    object = it.isAnnotation() && it.isWritable() ? ktClass : null;
                    if (object != null) break block6;
                }
                return null;
            }
            KtClass annotationClass = object;
            return TuplesKt.to((Object)annotationClass, (Object)annotationTypeDescriptor);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getExistingAnnotationTargets(@NotNull ClassDescriptor annotationClassDescriptor) {
            Set set;
            Set set2;
            TypedArrayValue typedArrayValue;
            Object v0;
            block7: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)annotationClassDescriptor, (String)"annotationClassDescriptor");
                Iterable iterable = (Iterable)annotationClassDescriptor.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)StandardNames.FqNames.target)) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            Object object = v0;
            ConstantValue $this$safeAs$iv = object != null ? DescriptorUtilsKt.firstArgument((AnnotationDescriptor)object) : null;
            boolean $i$f$safeAs = false;
            ConstantValue constantValue = $this$safeAs$iv;
            if (!(constantValue instanceof TypedArrayValue)) {
                constantValue = null;
            }
            if ((typedArrayValue = (TypedArrayValue)constantValue) != null && (object = (List)typedArrayValue.getValue()) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object element$iv;
                Iterable $i$f$firstOrNull = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                element$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    EnumValue enumValue;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ConstantValue it = (ConstantValue)element$iv$iv;
                    boolean bl2 = false;
                    ConstantValue $this$safeAs$iv2 = it;
                    boolean $i$f$safeAs2 = false;
                    ConstantValue constantValue2 = $this$safeAs$iv2;
                    if (!(constantValue2 instanceof EnumValue)) {
                        constantValue2 = null;
                    }
                    if (((enumValue = (EnumValue)constantValue2) != null && (enumValue = enumValue.getEnumEntryName()) != null ? enumValue.asString() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            } else {
                set2 = set = null;
            }
            if (set2 == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET) && !Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET)) {
                return null;
            }
            PsiElement psiElement = diagnostic.getPsiElement();
            KtAnnotationEntry ktAnnotationEntry = psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            Pair<KtClass, ClassDescriptor> pair = this.toAnnotationClass(entry);
            if (pair == null) {
                return null;
            }
            Pair<KtClass, ClassDescriptor> pair2 = pair;
            KtClass annotationClass = (KtClass)pair2.component1();
            ClassDescriptor annotationClassDescriptor = (ClassDescriptor)pair2.component2();
            Project project = entry.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(entry, annotationClass, annotationClassDescriptor, project).isEmpty()) {
                return null;
            }
            return new AddAnnotationTargetFix(entry);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

