/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.AddAnnotationUseSiteTargetUtils;
import org.jetbrains.kotlin.idea.intentions.AddAnnotationUseSiteTargetIntentionKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationUseSiteTargetFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "useSiteTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Ljava/util/List;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddAnnotationUseSiteTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final List<AnnotationUseSiteTarget> useSiteTargets;

    public AddAnnotationUseSiteTargetFix(@NotNull KtAnnotationEntry annotationEntry, @NotNull List<? extends AnnotationUseSiteTarget> useSiteTargets) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
        Intrinsics.checkNotNullParameter(useSiteTargets, (String)"useSiteTargets");
        super((PsiElement)annotationEntry);
        this.useSiteTargets = useSiteTargets;
    }

    @NotNull
    public String getText() {
        String string;
        if (this.useSiteTargets.size() == 1) {
            Object[] objectArray = new Object[]{((AnnotationUseSiteTarget)CollectionsKt.first(this.useSiteTargets)).getRenderName()};
            string = KotlinBundle.message((String)"text.add.use.site.target.0", (Object[])objectArray);
        } else {
            string = KotlinBundle.message((String)"add.use.site.target", (Object[])new Object[0]);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
            if (ktAnnotationEntry == null) break block0;
            AddAnnotationUseSiteTargetUtils.INSTANCE.addOrChooseUseSiteTarget(ktAnnotationEntry, this.useSiteTargets, editor);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationUseSiteTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtAnnotationEntry ktAnnotationEntry = psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            List<AnnotationUseSiteTarget> applicableUseSiteTargets = AddAnnotationUseSiteTargetIntentionKt.getApplicableUseSiteTargets(entry);
            if (applicableUseSiteTargets.isEmpty()) {
                return null;
            }
            return new AddAnnotationUseSiteTargetFix(entry, applicableUseSiteTargets);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

