/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddConstructorParameterFromSuperTypeCallFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "element", "parameterName", "", "parameterTypeSourceCode", "<init>", "(Lorg/jetbrains/kotlin/psi/KtValueArgumentList;Ljava/lang/String;Ljava/lang/String;)V", "getFamilyName", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.fir.frontend-independent"})
public final class AddConstructorParameterFromSuperTypeCallFix
extends PsiUpdateModCommandAction<KtValueArgumentList> {
    @NotNull
    private final String parameterName;
    @NotNull
    private final String parameterTypeSourceCode;

    public AddConstructorParameterFromSuperTypeCallFix(@NotNull KtValueArgumentList element, @NotNull String parameterName2, @NotNull String parameterTypeSourceCode) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
        Intrinsics.checkNotNullParameter((Object)parameterTypeSourceCode, (String)"parameterTypeSourceCode");
        super((PsiElement)element);
        this.parameterName = parameterName2;
        this.parameterTypeSourceCode = parameterTypeSourceCode;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.parameterName};
        return KotlinBundle.message((String)"fix.add.constructor.parameter", (Object[])objectArray);
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull KtValueArgumentList element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
        if (ktClass == null || (ktClass = KtClassKt.createPrimaryConstructorIfAbsent((KtClass)ktClass)) == null || (ktClass = ktClass.getValueParameterList()) == null) {
            return;
        }
        KtClass constructorParamList = ktClass;
        Project project = context2.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtParameter ktParameter = constructorParamList.addParameter(psiFactory.createParameter(this.parameterName + ": " + this.parameterTypeSourceCode));
        Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"addParameter(...)");
        KtParameter constructorParam = ktParameter;
        KtValueArgument ktValueArgument = element.addArgument(psiFactory.createArgument(this.parameterName));
        Intrinsics.checkNotNullExpressionValue((Object)ktValueArgument, (String)"addArgument(...)");
        KtValueArgument superTypeCallArg = ktValueArgument;
        ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)constructorParam);
        updater2.moveCaretTo(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)superTypeCallArg)));
    }
}

