/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddExceptionToThrowsFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "element", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lorg/jetbrains/kotlin/name/FqName;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddExceptionToThrowsFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName argumentClassFqName;

    public AddExceptionToThrowsFix(@NotNull KtAnnotationEntry element, @NotNull FqName argumentClassFqName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
        super((PsiElement)element);
        this.argumentClassFqName = argumentClassFqName;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.argumentClassFqName.shortName().asString() + "::class"};
        return KotlinBundle.message((String)"fix.add.exception.to.throws", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        KtValueArgument added;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        String argumentText = this.argumentClassFqName.asString() + "::class";
        KtValueArgumentList ktValueArgumentList = annotationEntry.getValueArgumentList();
        KtValueArgument ktValueArgument = added = ktValueArgumentList != null ? ktValueArgumentList.addArgument(psiFactory.createArgument(argumentText)) : null;
        if (added != null) {
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)added, null, 2, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddExceptionToThrowsFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtAnnotationEntry ktAnnotationEntry = psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            KtValueArgumentList ktValueArgumentList = annotationEntry.getValueArgumentList();
            if (ktValueArgumentList == null) {
                return null;
            }
            KtValueArgumentList valueArgumentsList = ktValueArgumentList;
            List list2 = valueArgumentsList.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getArguments(...)");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list2);
            if ((ktValueArgument != null ? ktValueArgument.getArgumentName() : null) != null) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)ErrorsNative.MISSING_EXCEPTION_IN_THROWS_ON_SUSPEND)) {
                return null;
            }
            FqName fqName2 = (FqName)((DiagnosticWithParameters1)ErrorsNative.MISSING_EXCEPTION_IN_THROWS_ON_SUSPEND.cast((UnboundDiagnostic)diagnostic)).getA();
            Intrinsics.checkNotNull((Object)fqName2);
            FqName missingExceptionFqName = fqName2;
            return new AddExceptionToThrowsFix(annotationEntry, missingExceptionFqName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

