/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0094\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtFile;", "element", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "argumentClassFqName", "annotationFinder", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lkotlin/jvm/functions/Function2;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "getFamilyName", "", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "addArgumentToExistingAnnotation", "annotationEntry", "argumentText", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAddFileAnnotationFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFileAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public class AddFileAnnotationFix
extends PsiUpdateModCommandAction<KtFile> {
    @NotNull
    private final FqName annotationFqName;
    @Nullable
    private final FqName argumentClassFqName;
    @NotNull
    private final Function2<KtFile, FqName, KtAnnotationEntry> annotationFinder;

    public AddFileAnnotationFix(@NotNull KtFile element, @NotNull FqName annotationFqName, @Nullable FqName argumentClassFqName, @NotNull Function2<? super KtFile, ? super FqName, ? extends KtAnnotationEntry> annotationFinder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        Intrinsics.checkNotNullParameter(annotationFinder, (String)"annotationFinder");
        super((PsiElement)element);
        this.annotationFqName = annotationFqName;
        this.argumentClassFqName = argumentClassFqName;
        this.annotationFinder = annotationFinder;
    }

    public /* synthetic */ AddFileAnnotationFix(KtFile ktFile2, FqName fqName2, FqName fqName3, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fqName3 = null;
        }
        if ((n & 8) != 0) {
            function2 = AddFileAnnotationFix::_init_$lambda$0;
        }
        this(ktFile2, fqName2, fqName3, (Function2<? super KtFile, ? super FqName, ? extends KtAnnotationEntry>)function2);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtFile element) {
        Object object;
        String annotationName;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String string = this.annotationFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                annotationName = string;
                object = this.argumentClassFqName;
                if (object == null || (object = object.shortName()) == null || (object = object.asString()) == null) break block2;
                Object it = object;
                boolean bl = false;
                String string2 = (String)it + "::class";
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        Object innerText = object;
        String annotationText = annotationName + "(" + (String)innerText + ")";
        Object[] objectArray = new Object[2];
        objectArray[0] = annotationText;
        Intrinsics.checkNotNullExpressionValue((Object)element.getName(), (String)"getName(...)");
        String actionName = KotlinBundle.message((String)"fix.add.annotation.text.containing.file", (Object[])objectArray);
        Presentation presentation = Presentation.of((String)actionName);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.add.annotation.family", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull KtFile element, @NotNull ModPsiUpdater updater2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Object object = this.argumentClassFqName;
        if (object != null && (object = RenderingUtilsKt.render((FqName)object)) != null) {
            Object it = object;
            boolean bl = false;
            string = (String)it + "::class";
        } else {
            string = null;
        }
        String innerText = string;
        String annotationText = innerText == null ? RenderingUtilsKt.render((FqName)this.annotationFqName) : RenderingUtilsKt.render((FqName)this.annotationFqName) + "(" + innerText + ")";
        Project project = context2.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtFileAnnotationList annotationList = element.getFileAnnotationList();
        if (annotationList == null) {
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(annotationText);
            KtFileAnnotationList createdAnnotationList = PsiUtilsKt.replaceFileAnnotationList((KtFile)element, (KtFileAnnotationList)newAnnotationList);
            element.addAfter(psiFactory.createWhiteSpace("\n"), (PsiElement)createdAnnotationList);
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)createdAnnotationList);
        } else {
            KtAnnotationEntry existingAnnotationEntry = (KtAnnotationEntry)this.annotationFinder.invoke((Object)element, (Object)this.annotationFqName);
            if (existingAnnotationEntry == null) {
                KtAnnotationEntry newAnnotation = psiFactory.createFileAnnotation(annotationText);
                annotationList.add(psiFactory.createWhiteSpace("\n"));
                annotationList.add((PsiElement)newAnnotation);
                ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)annotationList);
            } else if (innerText != null) {
                this.addArgumentToExistingAnnotation(existingAnnotationEntry, innerText);
            }
        }
    }

    private final void addArgumentToExistingAnnotation(KtAnnotationEntry annotationEntry, String argumentText) {
        KtValueArgumentList existingArgumentList = annotationEntry.getValueArgumentList();
        Project project = annotationEntry.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtValueArgumentList newArgumentList = psiFactory.createCallArguments("(" + argumentText + ")");
        PsiElement psiElement = existingArgumentList == null ? annotationEntry.addAfter((PsiElement)newArgumentList, annotationEntry.getLastChild()) : (existingArgumentList.getArguments().isEmpty() ? existingArgumentList.replace((PsiElement)newArgumentList) : (PsiElement)existingArgumentList.addArgument((KtValueArgument)newArgumentList.getArguments().get(0)));
        ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)annotationEntry);
    }

    private static final KtAnnotationEntry _init_$lambda$0(KtFile ktFile2, FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"<unused var>");
        return null;
    }
}

