/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.AddInterpolationPrefixFixKt;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInterpolationPrefixFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "element", "prefixLength", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;I)V", "getPrefixLength", "()I", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "kotlin.fir.frontend-independent"})
public final class AddInterpolationPrefixFix
extends PsiUpdateModCommandAction<KtStringTemplateExpression> {
    private final int prefixLength;

    public AddInterpolationPrefixFix(@NotNull KtStringTemplateExpression element, int prefixLength) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.prefixLength = prefixLength;
    }

    public final int getPrefixLength() {
        return this.prefixLength;
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull KtStringTemplateExpression element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        if (element.getInterpolationPrefix() != null) {
            AddInterpolationPrefixFixKt.access$getLOG$p().error(StringsKt.trimMargin$default((String)("The string template already has an interpolation prefix:\n                |" + element.getText() + "\n            "), null, (int)1, null));
            return;
        }
        if (this.prefixLength < 2) {
            AddInterpolationPrefixFixKt.access$getLOG$p().error("Prefix length should be at least 2, but it is " + this.prefixLength + ".");
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtStringTemplateExpression prefixedString = new KtPsiFactory(project, false, 2, null).createMultiDollarStringTemplate(KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)element), this.prefixLength, !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element));
        element.replace((PsiElement)prefixedString);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"add.interpolation.prefix", (Object[])new Object[0]);
    }
}

