/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AddNameToArgumentFix$calculatePossibleArgumentNames$;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J#\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u0007H\u0002J&\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "argument", "<init>", "(Lorg/jetbrains/kotlin/psi/KtValueArgument;)V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "invoke", "", "getText", "", "getFamilyName", "calculatePossibleArgumentNames", "", "Lorg/jetbrains/kotlin/name/Name;", "addName", "name", "createArgumentWithName", "reformat", "chooseNameAndAdd", "names", "getNamePopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddNameToArgumentFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddNameToArgumentFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,120:1\n1#2:121\n232#3:122\n479#4:123\n*S KotlinDebug\n*F\n+ 1 AddNameToArgumentFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix\n*L\n59#1:122\n69#1:123\n*E\n"})
public final class AddNameToArgumentFix
extends KotlinQuickFixAction<KtValueArgument> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddNameToArgumentFix(@NotNull KtValueArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        super((PsiElement)argument2);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtValueArgument ktValueArgument = (KtValueArgument)this.getElement();
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument element = ktValueArgument;
        if (element.getArgumentExpression() == null) {
            return false;
        }
        return !((Collection)this.calculatePossibleArgumentNames()).isEmpty();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtValueArgument ktValueArgument = (KtValueArgument)this.getElement();
        if (ktValueArgument == null) {
            return;
        }
        KtValueArgument element = ktValueArgument;
        List<Name> possibleNames = this.calculatePossibleArgumentNames();
        boolean bl2 = bl = !((Collection)possibleNames).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "isAvailable() should be checked before invoke()";
            throw new AssertionError((Object)string);
        }
        if (possibleNames.size() == 1 || editor == null || !editor.getComponent().isShowing()) {
            this.addName(project, element, (Name)CollectionsKt.first(possibleNames));
        } else {
            this.chooseNameAndAdd(project, editor, possibleNames);
        }
    }

    @NotNull
    public String getText() {
        Name argumentName2 = (Name)CollectionsKt.singleOrNull(this.calculatePossibleArgumentNames());
        if (argumentName2 != null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.createArgumentWithName(argumentName2, false).getText(), (String)"getText(...)");
            return KotlinBundle.message((String)"fix.add.argument.name.text", (Object[])objectArray);
        }
        return KotlinBundle.message((String)"fix.add.argument.name.text.generic", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.add.argument.name.family", (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Name> calculatePossibleArgumentNames() {
        void $this$filterIsInstance$iv;
        KotlinType kotlinType;
        void $this$getParentOfType$iv;
        Object t = this.getElement();
        Intrinsics.checkNotNull(t);
        Object t2 = t;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtCallElement ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtCallElement.class, (boolean)strict$iv);
        if (ktCallElement == null) {
            return CollectionsKt.emptyList();
        }
        KtCallElement callElement = ktCallElement;
        Object t3 = this.getElement();
        Intrinsics.checkNotNull(t3);
        BindingContext context2 = ResolutionUtils.analyze((KtElement)t3, BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)callElement), (BindingContext)context2);
        if (resolvedCall == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Object t4 = this.getElement();
        Intrinsics.checkNotNull(t4);
        KtExpression ktExpression = ((KtValueArgument)t4).getArgumentExpression();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            kotlinType = context2.getType(it);
        } else {
            kotlinType = null;
        }
        KotlinType argumentType = kotlinType;
        List list2 = resolvedCall2.getCall().getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), arg_0 -> AddNameToArgumentFix.calculatePossibleArgumentNames$lambda$1(resolvedCall2, arg_0));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)calculatePossibleArgumentNames$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Set usedParameters = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence2, arg_0 -> AddNameToArgumentFix.calculatePossibleArgumentNames$lambda$2(argumentType, arg_0)), AddNameToArgumentFix::calculatePossibleArgumentNames$lambda$3));
        List list3 = resolvedCall2.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list3), arg_0 -> AddNameToArgumentFix.calculatePossibleArgumentNames$lambda$4(usedParameters, arg_0)), AddNameToArgumentFix::calculatePossibleArgumentNames$lambda$5), AddNameToArgumentFix::calculatePossibleArgumentNames$lambda$6));
    }

    private final void addName(Project project, KtValueArgument argument2, Name name2) {
        ApplicationUtilsKt.executeWriteCommand(project, KotlinBundle.message((String)"fix.add.argument.name.family", (Object[])new Object[0]), (Function0<Unit>)((Function0)() -> AddNameToArgumentFix.addName$lambda$0(argument2, this, name2)));
    }

    private final KtValueArgument createArgumentWithName(Name name2, boolean reformat) {
        Object t = this.getElement();
        Intrinsics.checkNotNull(t);
        KtValueArgument element = (KtValueArgument)t;
        KtExpression ktExpression = element.getArgumentExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression argumentExpression = ktExpression;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new KtPsiFactory(project, false, 2, null).createArgument(argumentExpression, name2, element.getSpreadElement() != null, reformat);
    }

    static /* synthetic */ KtValueArgument createArgumentWithName$default(AddNameToArgumentFix addNameToArgumentFix, Name name2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return addNameToArgumentFix.createArgumentWithName(name2, bl);
    }

    private final void chooseNameAndAdd(Project project, Editor editor, List<Name> names) {
        JBPopupFactory.getInstance().createListPopup(this.getNamePopup(project, names)).showInBestPositionFor(editor);
    }

    private final ListPopupStep<Name> getNamePopup(Project project, List<Name> names) {
        String string = KotlinBundle.message((String)"fix.add.argument.name.step.choose.parameter.title", (Object[])new Object[0]);
        return (ListPopupStep)new BaseListPopupStep<Name>(names, this, project, string){
            final /* synthetic */ AddNameToArgumentFix this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super($super_call_param$1, $names);
            }

            public PopupStep<?> onChosen(Name selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                T t = this.this$0.getElement();
                Intrinsics.checkNotNull(t);
                AddNameToArgumentFix.access$addName(this.this$0, this.$project, (KtValueArgument)t, selectedValue);
                return PopupStep.FINAL_CHOICE;
            }

            public Icon getIconFor(Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return KotlinIcons.PARAMETER;
            }

            public String getTextFor(Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return AddNameToArgumentFix.createArgumentWithName$default(this.this$0, name2, false, 2, null).getText();
            }
        };
    }

    private static final ArgumentMapping calculatePossibleArgumentNames$lambda$1(ResolvedCall $resolvedCall, ValueArgument it) {
        return $resolvedCall.getArgumentMapping(it);
    }

    private static final boolean calculatePossibleArgumentNames$lambda$2(KotlinType $argumentType, ArgumentMatch argumentMatch) {
        Intrinsics.checkNotNullParameter((Object)argumentMatch, (String)"argumentMatch");
        return $argumentType == null || KotlinTypeKt.isError((KotlinType)$argumentType) || !argumentMatch.isError();
    }

    private static final ValueParameterDescriptor calculatePossibleArgumentNames$lambda$3(ArgumentMatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValueParameter();
    }

    private static final boolean calculatePossibleArgumentNames$lambda$4(Set $usedParameters, ValueParameterDescriptor it) {
        return !$usedParameters.contains(it);
    }

    private static final Name calculatePossibleArgumentNames$lambda$5(ValueParameterDescriptor it) {
        return it.getName();
    }

    private static final boolean calculatePossibleArgumentNames$lambda$6(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isSpecial();
    }

    private static final Unit addName$lambda$0(KtValueArgument $argument, AddNameToArgumentFix this$0, Name $name) {
        $argument.replace((PsiElement)AddNameToArgumentFix.createArgumentWithName$default(this$0, $name, false, 2, null));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$addName(AddNameToArgumentFix $this, Project project, KtValueArgument argument2, Name name2) {
        $this.addName(project, argument2, name2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddNameToArgumentFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddNameToArgumentFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix$Companion\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,120:1\n232#2:121\n*S KotlinDebug\n*F\n+ 1 AddNameToArgumentFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix$Companion\n*L\n114#1:121\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv);
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument argument2 = ktValueArgument;
            return new AddNameToArgumentFix(argument2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

