/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.idea.quickfix.OrdinaryImportFixBase;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OrdinaryImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "element", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;Ljava/util/Collection;)V", "getImportNames", "()Ljava/util/Collection;", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$OPERATOR;", "MyFactory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,973:1\n1#2:974\n*E\n"})
public class ArrayAccessorImportFix
extends OrdinaryImportFixBase<KtArrayAccessExpression> {
    @NotNull
    public static final MyFactory MyFactory = new MyFactory(null);
    @NotNull
    private final Collection<Name> importNames;

    public ArrayAccessorImportFix(@NotNull KtArrayAccessExpression element, @NotNull Collection<Name> importNames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(importNames, (String)"importNames");
        super((KtExpression)element, MyFactory);
        this.importNames = importNames;
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    @Nullable
    protected CallTypeAndReceiver.OPERATOR getCallTypeAndReceiver() {
        CallTypeAndReceiver.OPERATOR oPERATOR;
        KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)this.getElement();
        if (ktArrayAccessExpression != null) {
            KtArrayAccessExpression it = ktArrayAccessExpression;
            boolean bl = false;
            KtExpression ktExpression = it.getArrayExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            oPERATOR = new CallTypeAndReceiver.OPERATOR(ktExpression);
        } else {
            oPERATOR = null;
        }
        return oPERATOR;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix$MyFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$FactoryWithUnresolvedReferenceQuickFix;", "<init>", "()V", "importName", "Lorg/jetbrains/kotlin/name/Name;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix;", "kotlin.idea"})
    public static final class MyFactory
    extends ImportFixBase.FactoryWithUnresolvedReferenceQuickFix {
        private MyFactory() {
        }

        private final Name importName(Diagnostic diagnostic) {
            Name name2;
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.NO_GET_METHOD)) {
                name2 = OperatorNameConventions.GET;
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.NO_SET_METHOD)) {
                name2 = OperatorNameConventions.SET;
            } else {
                throw new IllegalStateException("Shouldn't be called for other diagnostics");
            }
            return name2;
        }

        @Nullable
        public ArrayAccessorImportFix createImportAction(@NotNull Diagnostic diagnostic) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory factory2 = diagnostic.getFactory();
            boolean bl2 = bl = Intrinsics.areEqual((Object)factory2, (Object)Errors.NO_GET_METHOD) || Intrinsics.areEqual((Object)factory2, (Object)Errors.NO_SET_METHOD);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            PsiElement element = diagnostic.getPsiElement();
            if (element instanceof KtArrayAccessExpression && ((KtArrayAccessExpression)element).getArrayExpression() != null) {
                return new ArrayAccessorImportFix((KtArrayAccessExpression)element, CollectionsKt.listOf((Object)this.importName(diagnostic)));
            }
            return null;
        }

        public /* synthetic */ MyFactory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

