/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAnnotationNamesKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.VisibilityUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "element", "signatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Signature", "Companion", "ParameterChooser", "MyAction", "kotlin.idea"})
public final class ChangeMemberFunctionSignatureFix
extends KotlinQuickFixAction<KtNamedFunction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Signature> signatures;

    private ChangeMemberFunctionSignatureFix(KtNamedFunction element, List<Signature> signatures) {
        super((PsiElement)element);
        boolean bl;
        this.signatures = signatures;
        boolean bl2 = bl = !((Collection)this.signatures).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public String getText() {
        String string;
        Signature single = (Signature)CollectionsKt.singleOrNull(this.signatures);
        if (single != null) {
            Object[] objectArray = new Object[]{single.getPreview()};
            string = KotlinBundle.message((String)"fix.change.signature.function.text", (Object[])objectArray);
        } else {
            string = KotlinBundle.message((String)"fix.change.signature.function.text.generic", (Object[])new Object[0]);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.change.signature.function.family", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtNamedFunction ktNamedFunction = (KtNamedFunction)this.getElement();
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction element = ktNamedFunction;
        CommandProcessor.getInstance().runUndoTransparentAction(() -> ChangeMemberFunctionSignatureFix.invoke$lambda$0(project, editor, element, this));
    }

    private static final void invoke$lambda$0(Project $project, Editor $editor, KtNamedFunction $element, ChangeMemberFunctionSignatureFix this$0) {
        new MyAction($project, $editor, $element, this$0.signatures).execute();
    }

    public /* synthetic */ ChangeMemberFunctionSignatureFix(KtNamedFunction element, List signatures, DefaultConstructorMarker $constructor_marker) {
        this(element, signatures);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002JJ\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u001e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\tH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "computePossibleSignatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "functionElement", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "signatureToMatch", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "superFunction", "matchParameters", "", "parameterChooser", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "superParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameters", "newParameters", "", "matched", "Ljava/util/BitSet;", "used", "getPossibleSuperFunctionsDescriptors", "functionDescriptor", "replaceFunctionParameters", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeMemberFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n614#2:361\n1391#3:362\n1480#3,5:363\n777#3:368\n873#3,2:369\n1586#3:371\n1661#3,3:372\n*S KotlinDebug\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Companion\n*L\n97#1:361\n177#1:362\n177#1:363,5\n178#1:368\n178#1:369,2\n207#1:371\n207#1:372,3\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function = ktNamedFunction;
            List<Signature> signatures = this.computePossibleSignatures(function);
            if (signatures.isEmpty()) {
                return null;
            }
            return new ChangeMemberFunctionSignatureFix(function, signatures, null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Signature> computePossibleSignatures(KtNamedFunction functionElement) {
            void $this$sortedBy$iv;
            if (functionElement.getValueParameterList() == null) {
                return CollectionsKt.emptyList();
            }
            FunctionDescriptor functionDescriptor = ResolutionUtils.resolveToDescriptorIfAny(functionElement, BodyResolveMode.FULL);
            if (functionDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            List<FunctionDescriptor> superFunctions = this.getPossibleSuperFunctionsDescriptors(functionDescriptor2);
            Sequence sequence = SequencesKt.distinctBy((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)superFunctions), Companion::computePossibleSignatures$lambda$0), arg_0 -> Companion.computePossibleSignatures$lambda$1(functionDescriptor2, arg_0)), Companion::computePossibleSignatures$lambda$2);
            boolean $i$f$sortedBy = false;
            return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Signature it = (Signature)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPreview());
                    it = (Signature)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPreview())));
                }
            }));
        }

        private final Signature signatureToMatch(FunctionDescriptor function, FunctionDescriptor superFunction) {
            List list2 = superFunction.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            List superParameters = list2;
            List list3 = function.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
            List parameters2 = list3;
            List newParameters2 = CollectionsKt.toMutableList((Collection)superParameters);
            BitSet matched = new BitSet(superParameters.size());
            BitSet used = new BitSet(superParameters.size());
            this.matchParameters(ParameterChooser.MatchNames.INSTANCE, superParameters, parameters2, newParameters2, matched, used);
            this.matchParameters(ParameterChooser.MatchTypes.INSTANCE, superParameters, parameters2, newParameters2, matched, used);
            Object[] objectArray = new FunctionDescriptor[]{superFunction, function};
            FunctionDescriptor functionDescriptor = superFunction.copy(function.getContainingDeclaration(), Modality.OPEN, VisibilityUtilKt.findMemberWithMaxVisibility((Collection)CollectionsKt.listOf((Object[])objectArray)).getVisibility(), CallableMemberDescriptor.Kind.DELEGATION, true);
            Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"copy(...)");
            FunctionDescriptor newFunction = this.replaceFunctionParameters(functionDescriptor, newParameters2);
            DescriptorUtilsKt.setSingleOverridden((CallableMemberDescriptor)((CallableMemberDescriptor)newFunction), (CallableMemberDescriptor)((CallableMemberDescriptor)superFunction));
            return new Signature(newFunction);
        }

        private final void matchParameters(ParameterChooser parameterChooser, List<? extends ValueParameterDescriptor> superParameters, List<? extends ValueParameterDescriptor> parameters2, List<ValueParameterDescriptor> newParameters2, BitSet matched, BitSet used) {
            block0: for (ValueParameterDescriptor valueParameterDescriptor : superParameters) {
                if (matched.get(valueParameterDescriptor.getIndex())) continue;
                for (ValueParameterDescriptor valueParameterDescriptor2 : parameters2) {
                    ValueParameterDescriptor choice = parameterChooser.choose(valueParameterDescriptor2, valueParameterDescriptor);
                    if (choice == null || used.get(valueParameterDescriptor2.getIndex())) continue;
                    used.set(valueParameterDescriptor2.getIndex(), true);
                    matched.set(valueParameterDescriptor.getIndex(), true);
                    newParameters2.set(valueParameterDescriptor.getIndex(), choice);
                    continue block0;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<FunctionDescriptor> getPossibleSuperFunctionsDescriptors(FunctionDescriptor functionDescriptor) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object = functionDescriptor.getContainingDeclaration();
            ClassDescriptor classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (classDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ClassDescriptor containingClass = classDescriptor;
            Name name2 = functionDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            Name name3 = name2;
            SimpleType simpleType = containingClass.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
            object = TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType));
            boolean $i$f$flatMap = false;
            void var6_6 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinType supertype = (KotlinType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = supertype.getMemberScope().getContributedFunctions(name3, (LookupLocation)NoLookupLocation.FROM_IDE);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(it.getKind().isReal() && ModalityUtilsKt.isOverridable((CallableMemberDescriptor)((CallableMemberDescriptor)it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final FunctionDescriptor replaceFunctionParameters(FunctionDescriptor function, List<? extends ValueParameterDescriptor> newParameters2) {
            Collection<ReceiverParameterDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl2 = SimpleFunctionDescriptorImpl.create((DeclarationDescriptor)function.getContainingDeclaration(), (Annotations)function.getAnnotations(), (Name)function.getName(), (CallableMemberDescriptor.Kind)function.getKind(), (SourceElement)SourceElement.NO_SOURCE);
            Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl2, (String)"create(...)");
            SimpleFunctionDescriptorImpl descriptor2 = simpleFunctionDescriptorImpl2;
            List parameters2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.withIndex((Sequence)CollectionsKt.asSequence((Iterable)newParameters2)), arg_0 -> Companion.replaceFunctionParameters$lambda$0(descriptor2, arg_0)));
            SimpleFunctionDescriptorImpl $this$replaceFunctionParameters_u24lambda_u241 = simpleFunctionDescriptorImpl = descriptor2;
            boolean bl = false;
            ReceiverParameterDescriptor receiverParameterDescriptor = function.getExtensionReceiverParameter();
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.copy((DeclarationDescriptor)$this$replaceFunctionParameters_u24lambda_u241) : null;
            ReceiverParameterDescriptor receiverParameterDescriptor3 = function.getDispatchReceiverParameter();
            List list2 = function.getContextReceiverParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContextReceiverParameters(...)");
            Iterable iterable = list2;
            ReceiverParameterDescriptor receiverParameterDescriptor4 = receiverParameterDescriptor3;
            ReceiverParameterDescriptor receiverParameterDescriptor5 = receiverParameterDescriptor2;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl3 = $this$replaceFunctionParameters_u24lambda_u241;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReceiverParameterDescriptor receiverParameterDescriptor6 = (ReceiverParameterDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.copy((DeclarationDescriptor)$this$replaceFunctionParameters_u24lambda_u241));
            }
            collection = (List)destination$iv$iv;
            simpleFunctionDescriptorImpl3.initialize(receiverParameterDescriptor5, receiverParameterDescriptor4, collection, function.getTypeParameters(), parameters2, function.getReturnType(), function.getModality(), function.getVisibility());
            $this$replaceFunctionParameters_u24lambda_u241.setOperator(function.isOperator());
            $this$replaceFunctionParameters_u24lambda_u241.setInfix(function.isInfix());
            $this$replaceFunctionParameters_u24lambda_u241.setExternal(function.isExternal());
            $this$replaceFunctionParameters_u24lambda_u241.setInline(function.isInline());
            $this$replaceFunctionParameters_u24lambda_u241.setTailrec(function.isTailrec());
            $this$replaceFunctionParameters_u24lambda_u241.setSuspend(function.isSuspend());
            return (FunctionDescriptor)simpleFunctionDescriptorImpl;
        }

        private static final boolean computePossibleSignatures$lambda$0(FunctionDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getKind().isReal();
        }

        private static final Signature computePossibleSignatures$lambda$1(FunctionDescriptor $functionDescriptor, FunctionDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.signatureToMatch($functionDescriptor, it);
        }

        private static final String computePossibleSignatures$lambda$2(Signature it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getSourceCode();
        }

        private static final ValueParameterDescriptorImpl replaceFunctionParameters$lambda$0(SimpleFunctionDescriptorImpl $descriptor, IndexedValue indexedValue) {
            Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
            int index2 = indexedValue.component1();
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)indexedValue.component2();
            CallableDescriptor callableDescriptor = (CallableDescriptor)$descriptor;
            Annotations annotations2 = parameter.getAnnotations();
            Name name2 = parameter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            KotlinType kotlinType = parameter.getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType);
            boolean bl = parameter.declaresDefaultValue();
            boolean bl2 = parameter.isCrossinline();
            boolean bl3 = parameter.isNoinline();
            KotlinType kotlinType2 = parameter.getVarargElementType();
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            return new ValueParameterDescriptorImpl(callableDescriptor, null, index2, annotations2, name2, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "signatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "execute", "", "signaturePopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "getSignaturePopup", "()Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "changeSignature", "signature", "chooseSignatureAndChange", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeMemberFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n1915#2:361\n1915#2,2:362\n1916#2:364\n*S KotlinDebug\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction\n*L\n320#1:361\n321#1:362,2\n320#1:364\n*E\n"})
    private static final class MyAction {
        @NotNull
        private final Project project;
        @Nullable
        private final Editor editor;
        @NotNull
        private final KtNamedFunction function;
        @NotNull
        private final List<Signature> signatures;

        public MyAction(@NotNull Project project, @Nullable Editor editor, @NotNull KtNamedFunction function, @NotNull List<Signature> signatures) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
            this.project = project;
            this.editor = editor;
            this.function = function;
            this.signatures = signatures;
        }

        public final void execute() {
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            if (!this.function.isValid() || this.signatures.isEmpty()) {
                return;
            }
            if (this.signatures.size() == 1 || this.editor == null || !this.editor.getComponent().isShowing()) {
                this.changeSignature((Signature)CollectionsKt.first(this.signatures));
            } else {
                this.chooseSignatureAndChange();
            }
        }

        private final BaseListPopupStep<Signature> getSignaturePopup() {
            String string = KotlinBundle.message((String)"fix.change.signature.function.popup.title", (Object[])new Object[0]);
            List<Signature> list2 = this.signatures;
            return (BaseListPopupStep)new BaseListPopupStep<Signature>(this, string, list2){
                final /* synthetic */ MyAction this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2);
                }

                public boolean isAutoSelectionEnabled() {
                    return false;
                }

                public PopupStep<?> onChosen(Signature selectedValue, boolean finalChoice) {
                    Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                    if (finalChoice) {
                        MyAction.access$changeSignature(this.this$0, selectedValue);
                    }
                    return PopupStep.FINAL_CHOICE;
                }

                public Icon getIconFor(Signature aValue) {
                    Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
                    return IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Function);
                }

                public String getTextFor(Signature aValue) {
                    Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
                    return aValue.getPreview();
                }
            };
        }

        private final void changeSignature(Signature signature) {
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            ApplicationUtilsKt.executeWriteCommand(this.project, KotlinBundle.message((String)"fix.change.signature.function.family", (Object[])new Object[0]), (Function0<Unit>)((Function0)() -> MyAction.changeSignature$lambda$0(this, signature)));
        }

        private final void chooseSignatureAndChange() {
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)this.getSignaturePopup());
            Editor editor = this.editor;
            Intrinsics.checkNotNull((Object)editor);
            listPopup.showInBestPositionFor(editor);
        }

        private static final Unit changeSignature$lambda$0(MyAction this$0, Signature $signature) {
            block13: {
                block12: {
                    PsiElement psiElement;
                    KtTypeParameterList patternTypeParameterList;
                    PsiElement psiElement2;
                    KtParameterList it;
                    KtTypeReference newTypeRef;
                    KtNamedFunction patternFunction = new KtPsiFactory(this$0.project, false, 2, null).createFunction($signature.getSourceCode());
                    if (patternFunction.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                        this$0.function.addModifier(KtTokens.SUSPEND_KEYWORD);
                    }
                    if ((newTypeRef = this$0.function.setTypeReference(patternFunction.getTypeReference())) != null) {
                        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)newTypeRef, null, 2, null);
                    }
                    Iterable $this$forEach$iv = patternFunction.getValueParameters();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtParameter param = (KtParameter)element$iv;
                        boolean bl = false;
                        List list2 = param.getAnnotationEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
                        Iterable $this$forEach$iv2 = list2;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            KtTypeReference $this$changeSignature_u24lambda_u240_u240_u240_u240;
                            KtAnnotationEntry a = (KtAnnotationEntry)element$iv2;
                            boolean bl2 = false;
                            if (a.getTypeReference() == null) continue;
                            boolean bl3 = false;
                            String string = $this$changeSignature_u24lambda_u240_u240_u240_u240.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            FqName fqName2 = new FqName(string);
                            if (!SetsKt.plus((Set)JvmAnnotationNamesKt.getNULLABLE_ANNOTATIONS(), (Iterable)JvmAnnotationNamesKt.getNOT_NULL_ANNOTATIONS()).contains(fqName2)) continue;
                            a.delete();
                        }
                    }
                    KtParameterList ktParameterList = patternFunction.getValueParameterList();
                    if (ktParameterList != null) {
                        it = ktParameterList;
                        boolean bl = false;
                        KtParameterList ktParameterList2 = this$0.function.getValueParameterList();
                        psiElement2 = ktParameterList2 != null ? ktParameterList2.replace((PsiElement)it) : null;
                    } else {
                        psiElement2 = null;
                    }
                    Intrinsics.checkNotNull(psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameterList");
                    KtParameterList newParameterList = (KtParameterList)psiElement2;
                    ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)newParameterList, null, 2, null);
                    KtTypeReference patternFunctionReceiver = patternFunction.getReceiverTypeReference();
                    if (patternFunctionReceiver == null) {
                        if (this$0.function.getReceiverTypeReference() != null) {
                            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)this$0.function), null);
                        }
                    } else {
                        KtTypeReference ktTypeReference = TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)this$0.function), (KtTypeReference)patternFunction.getReceiverTypeReference());
                        if (ktTypeReference != null) {
                            it = ktTypeReference;
                            boolean bl = false;
                            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)it, null, 2, null);
                        }
                    }
                    if ((patternTypeParameterList = patternFunction.getTypeParameterList()) == null) break block12;
                    if (this$0.function.getTypeParameterList() != null) {
                        KtTypeParameterList ktTypeParameterList = this$0.function.getTypeParameterList();
                        psiElement = ktTypeParameterList != null ? ktTypeParameterList.replace((PsiElement)patternTypeParameterList) : null;
                    } else {
                        psiElement = this$0.function.addAfter((PsiElement)patternTypeParameterList, this$0.function.getFunKeyword());
                    }
                    PsiElement psiElement3 = psiElement;
                    Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterList");
                    ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)((KtTypeParameterList)psiElement3), null, 2, null);
                    break block13;
                }
                KtTypeParameterList ktTypeParameterList = this$0.function.getTypeParameterList();
                if (ktTypeParameterList == null) break block13;
                ktTypeParameterList.delete();
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$changeSignature(MyAction $this, Signature signature) {
            $this.changeSignature(signature);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bb\u0018\u00002\u00020\u0001:\u0002\u0006\u0007J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "MatchNames", "MatchTypes", "kotlin.idea"})
    private static interface ParameterChooser {
        @Nullable
        public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor var1, @NotNull ValueParameterDescriptor var2);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchNames;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "<init>", "()V", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "kotlin.idea"})
        @SourceDebugExtension(value={"SMAP\nChangeMemberFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchNames\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1#2:361\n*E\n"})
        public static final class MatchNames
        implements ParameterChooser {
            @NotNull
            public static final MatchNames INSTANCE = new MatchNames();

            private MatchNames() {
            }

            @Override
            @Nullable
            public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter, @NotNull ValueParameterDescriptor superParameter) {
                ValueParameterDescriptor valueParameterDescriptor;
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)superParameter, (String)"superParameter");
                ValueParameterDescriptor it = valueParameterDescriptor = superParameter;
                boolean bl = false;
                return Intrinsics.areEqual((Object)parameter.getName(), (Object)superParameter.getName()) ? valueParameterDescriptor : null;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchTypes;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "<init>", "()V", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "kotlin.idea"})
        public static final class MatchTypes
        implements ParameterChooser {
            @NotNull
            public static final MatchTypes INSTANCE = new MatchTypes();

            private MatchTypes() {
            }

            @Override
            @Nullable
            public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter, @NotNull ValueParameterDescriptor superParameter) {
                ValueParameterDescriptor valueParameterDescriptor;
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)superParameter, (String)"superParameter");
                if (KotlinTypeChecker.DEFAULT.equalTypes(parameter.getType(), superParameter.getType())) {
                    CallableDescriptor callableDescriptor = parameter.getContainingDeclaration();
                    Name name2 = parameter.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    valueParameterDescriptor = superParameter.copy(callableDescriptor, name2, parameter.getIndex());
                } else {
                    valueParameterDescriptor = null;
                }
                return valueParameterDescriptor;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "sourceCode", "", "getSourceCode", "()Ljava/lang/String;", "preview", "getPreview", "Companion", "kotlin.idea"})
    private static final class Signature {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String sourceCode;
        @NotNull
        private final String preview;
        @NotNull
        private static final DescriptorRenderer SIGNATURE_SOURCE_RENDERER = IdeDescriptorRenderers.SOURCE_CODE.withOptions(Signature::SIGNATURE_SOURCE_RENDERER$lambda$0);
        @NotNull
        private static final DescriptorRenderer SIGNATURE_PREVIEW_RENDERER = DescriptorRenderer.Companion.withOptions(Signature::SIGNATURE_PREVIEW_RENDERER$lambda$0);

        public Signature(@NotNull FunctionDescriptor function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this.sourceCode = SIGNATURE_SOURCE_RENDERER.render((DeclarationDescriptor)function);
            this.preview = SIGNATURE_PREVIEW_RENDERER.render((DeclarationDescriptor)function);
        }

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final String getPreview() {
            return this.preview;
        }

        private static final Unit SIGNATURE_SOURCE_RENDERER$lambda$0(DescriptorRendererOptions $this$withOptions) {
            Intrinsics.checkNotNullParameter((Object)$this$withOptions, (String)"$this$withOptions");
            $this$withOptions.setDefaultParameterValueRenderer(null);
            return Unit.INSTANCE;
        }

        private static final Unit SIGNATURE_PREVIEW_RENDERER$lambda$0(DescriptorRendererOptions $this$withOptions) {
            Intrinsics.checkNotNullParameter((Object)$this$withOptions, (String)"$this$withOptions");
            $this$withOptions.setTypeNormalizer(IdeDescriptorRenderers.APPROXIMATE_FLEXIBLE_TYPES);
            $this$withOptions.setWithDefinedIn(false);
            $this$withOptions.setModifiers(SetsKt.emptySet());
            $this$withOptions.setClassifierNamePolicy((ClassifierNamePolicy)ClassifierNamePolicy.SHORT.INSTANCE);
            $this$withOptions.setUnitReturnType(false);
            $this$withOptions.setDefaultParameterValueRenderer(null);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature$Companion;", "", "<init>", "()V", "SIGNATURE_SOURCE_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "SIGNATURE_PREVIEW_RENDERER", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

