/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.ConvertExtensionToFunctionTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertExtensionToFunctionTypeFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "<init>", "()V", "renderType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class ConvertExtensionToFunctionTypeFixFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final ConvertExtensionToFunctionTypeFixFactory INSTANCE = new ConvertExtensionToFunctionTypeFixFactory();

    private ConvertExtensionToFunctionTypeFixFactory() {
    }

    private final String renderType(KotlinType $this$renderType, DescriptorRenderer renderer2) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderType_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderType_u24lambda_u240.append('(');
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.dropLast((List)$this$renderType.getArguments(), (int)1), (Appendable)$this$renderType_u24lambda_u240, (CharSequence)", ", null, null, (int)0, null, arg_0 -> ConvertExtensionToFunctionTypeFixFactory.renderType$lambda$0$0(renderer2, arg_0), (int)60, null);
        $this$renderType_u24lambda_u240.append(") -> ");
        $this$renderType_u24lambda_u240.append(renderer2.renderType(FunctionTypesKt.getReturnTypeFromFunctionType((KotlinType)$this$renderType)));
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        SimpleDiagnostic casted = (SimpleDiagnostic)Errors.SUPERTYPE_IS_EXTENSION_FUNCTION_TYPE.cast((UnboundDiagnostic)diagnostic);
        PsiElement psiElement = casted.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"<get-psiElement>(...)");
        KtTypeReference element = (KtTypeReference)psiElement;
        KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)element);
        if (kotlinType == null) {
            return CollectionsKt.emptyList();
        }
        KotlinType type2 = kotlinType;
        if (!FunctionTypesKt.isExtensionFunctionType((KotlinType)type2)) {
            return CollectionsKt.emptyList();
        }
        String targetTypeStringShort = this.renderType(type2, IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS);
        String targetTypeStringLong = this.renderType(type2, IdeDescriptorRenderers.SOURCE_CODE);
        return CollectionsKt.listOf((Object)new ConvertExtensionToFunctionTypeFix(element, targetTypeStringShort, targetTypeStringLong).asIntention());
    }

    private static final CharSequence renderType$lambda$0$0(DescriptorRenderer $renderer, TypeProjection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinType kotlinType = it.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        return $renderer.renderType(kotlinType);
    }
}

