/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.ConvertClassToKClassFixFactoryKt;
import org.jetbrains.kotlin.idea.quickfix.ConvertKClassToClassFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertKClassToClassFixFactory;", "", "<init>", "()V", "create", "Lcom/intellij/codeInsight/intention/IntentionAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionType", "diagnosticElement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
public final class ConvertKClassToClassFixFactory {
    @NotNull
    public static final ConvertKClassToClassFixFactory INSTANCE = new ConvertKClassToClassFixFactory();

    private ConvertKClassToClassFixFactory() {
    }

    @Nullable
    public final IntentionAction create(@NotNull KtFile file, @NotNull KotlinType expectedType, @NotNull KotlinType expressionType, @NotNull KtExpression diagnosticElement) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)diagnosticElement, (String)"diagnosticElement");
        ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor expressionClassDescriptor = classDescriptor;
        if (!KotlinBuiltIns.isKClass((ClassDescriptor)expressionClassDescriptor) || !ConvertClassToKClassFixFactoryKt.isJClass(expectedType)) {
            return null;
        }
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull((List)expressionType.getArguments());
        if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
            return null;
        }
        TypeProjection expressionTypeArgument = typeProjection;
        Object object = CollectionsKt.singleOrNull((Iterable)ResolutionUtils.resolveImportReference(file, ConvertClassToKClassFixFactoryKt.getJAVA_LANG_CLASS_FQ_NAME()));
        ClassDescriptor classDescriptor2 = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor javaLangClassDescriptor = classDescriptor2;
        SimpleType javaLangClassType = KotlinTypeFactory.simpleNotNullType((TypeAttributes)TypeAttributes.Companion.getEmpty(), (ClassDescriptor)javaLangClassDescriptor, (List)CollectionsKt.listOf((Object)new TypeProjectionImpl((KotlinType)expressionTypeArgument)));
        if (TypeUtilsKt.isSubtypeOf((KotlinType)((KotlinType)javaLangClassType), (KotlinType)expectedType)) {
            return new ConvertKClassToClassFix(diagnosticElement).asIntention();
        }
        return null;
    }
}

