/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.idea.quickfix.OrdinaryImportFixBase;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OrdinaryImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "solveSeveralProblems", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/util/Collection;Z)V", "getImportNames", "()Ljava/util/Collection;", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$DELEGATE;", "createAction", "Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "suggestions", "Lorg/jetbrains/kotlin/name/FqName;", "calculateReceiverTypeFromDiagnostic", "Lorg/jetbrains/kotlin/types/KotlinType;", "diagnostics", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "MyFactory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,973:1\n296#2,2:974\n*S KotlinDebug\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix\n*L\n713#1:974,2\n*E\n"})
public final class DelegateAccessorsImportFix
extends OrdinaryImportFixBase<KtExpression> {
    @NotNull
    public static final MyFactory MyFactory = new MyFactory(null);
    @NotNull
    private final Collection<Name> importNames;
    private final boolean solveSeveralProblems;

    public DelegateAccessorsImportFix(@NotNull KtExpression element, @NotNull Collection<Name> importNames, boolean solveSeveralProblems) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(importNames, (String)"importNames");
        super(element, MyFactory);
        this.importNames = importNames;
        this.solveSeveralProblems = solveSeveralProblems;
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    @NotNull
    protected CallTypeAndReceiver.DELEGATE getCallTypeAndReceiver() {
        return new CallTypeAndReceiver.DELEGATE((KtExpression)this.getElement());
    }

    @Override
    @NotNull
    protected KotlinAddImportAction createAction(@NotNull Editor editor, @NotNull KtExpression element, @NotNull Collection<FqName> suggestions) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (this.solveSeveralProblems) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return KotlinAddImportActionKt.createGroupedImportsAction(project, editor, (KtElement)element, KotlinBundle.message((String)"fix.import.kind.delegate.accessors", (Object[])new Object[0]), suggestions);
        }
        return super.createAction(editor, element, suggestions);
    }

    @Override
    @Nullable
    protected KotlinType calculateReceiverTypeFromDiagnostic(@NotNull Collection<? extends Diagnostic> diagnostics) {
        KotlinType kotlinType;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            Iterable $this$firstOrNull$iv = diagnostics;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!(it.getFactory() == Errors.DELEGATE_SPECIAL_FUNCTION_MISSING)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Diagnostic diagnostic = v0;
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            kotlinType = (KotlinType)((DiagnosticWithParameters3)Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.cast((UnboundDiagnostic)it)).getB();
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix$MyFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$FactoryWithUnresolvedReferenceQuickFix;", "<init>", "()V", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "diagnostics", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix;", "diagnostic", "createImportActionsForAllProblems", "", "sameTypeDiagnostics", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix$MyFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,973:1\n1586#2:974\n1661#2,3:975\n*S KotlinDebug\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/DelegateAccessorsImportFix$MyFactory\n*L\n720#1:974\n720#1:975,3\n*E\n"})
    public static final class MyFactory
    extends ImportFixBase.FactoryWithUnresolvedReferenceQuickFix {
        private MyFactory() {
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<Name> importNames(Collection<? extends Diagnostic> diagnostics) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = diagnostics;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Diagnostic diagnostic = (Diagnostic)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getFactory() == Errors.DELEGATE_SPECIAL_FUNCTION_MISSING ? (String)((DiagnosticWithParameters3)Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.cast((UnboundDiagnostic)it)).getA() : (String)((DiagnosticWithParameters2)Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE.cast((UnboundDiagnostic)it)).getA();
                Intrinsics.checkNotNull((Object)string);
                String missingMethodSignature = string;
                String string2 = OperatorNameConventions.GET_VALUE.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
                collection.add(StringsKt.startsWith$default((String)missingMethodSignature, (String)string2, (boolean)false, (int)2, null) ? OperatorNameConventions.GET_VALUE : OperatorNameConventions.SET_VALUE);
            }
            return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)OperatorNameConventions.PROVIDE_DELEGATE));
        }

        @Nullable
        public DelegateAccessorsImportFix createImportAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression = ktExpression;
            Collection<Name> importNames = this.importNames(CollectionsKt.listOf((Object)diagnostic));
            return new DelegateAccessorsImportFix(expression, importNames, false);
        }

        @NotNull
        public List<DelegateAccessorsImportFix> createImportActionsForAllProblems(@NotNull Collection<? extends Diagnostic> sameTypeDiagnostics) {
            Intrinsics.checkNotNullParameter(sameTypeDiagnostics, (String)"sameTypeDiagnostics");
            Diagnostic diagnostic = (Diagnostic)CollectionsKt.first((Iterable)sameTypeDiagnostics);
            PsiElement element = diagnostic.getPsiElement();
            KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtExpression expression = ktExpression;
            Collection<Name> names = this.importNames(sameTypeDiagnostics);
            return CollectionsKt.listOf((Object)new DelegateAccessorsImportFix(expression, names, true));
        }

        public /* synthetic */ MyFactory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

