/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.idea.actions.ExpressionWeigher;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinImportQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.UnresolvedReferenceQuickFixFactory;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.core.util.ScopeUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AbstractImportFixInfo;
import org.jetbrains.kotlin.idea.quickfix.ImportFixHelper;
import org.jetbrains.kotlin.idea.quickfix.ImportPrioritizer;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.QuickFixes;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@IntellijInternalApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00020\u0005:\u0002\\]B)\b\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\rB!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\r\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0012\u0010+\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010,H$J\u0018\u0010-\u001a\u0004\u0018\u00010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0018H\u0014J\n\u00101\u001a\u0004\u0018\u00010.H\u0004J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0016\u00106\u001a\u00020\u001f2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0018H\u0003J\b\u00109\u001a\u00020\u001fH\u0016J\b\u0010:\u001a\u00020\u001fH\u0016J\"\u0010;\u001a\u0002032\u0006\u0010\u0010\u001a\u00020\u00112\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010<\u001a\u00020=H\u0014J#\u0010>\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010<\u001a\u00020=H\u0094\u0002J\b\u0010?\u001a\u000203H\u0016J\b\u0010@\u001a\u000203H\u0002J&\u0010A\u001a\u00020B2\u0006\u00104\u001a\u0002052\u0006\u0010C\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u00104\u001a\u0002052\u0006\u0010<\u001a\u00020=H\u0016J:\u0010F\u001a\u0004\u0018\u00010E2\u0006\u00104\u001a\u0002052\u0006\u0010<\u001a\u00020=2\u001e\u0010G\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180HH\u0016J\u0010\u0010I\u001a\u0002032\u0006\u0010J\u001a\u000208H\u0002J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u0002080\u0018H\u0002J\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0018H\u0002J&\u0010M\u001a\b\u0012\u0004\u0012\u0002080\u00182\u0006\u0010N\u001a\u00020)2\u000e\u0010O\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030,H\u0002J\u0010\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u00020RH\u0002J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u0018H\u0014J6\u0010U\u001a\b\u0012\u0004\u0012\u0002080V2\u0006\u0010N\u001a\u00020\u001f2\u000e\u0010O\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030,2\u0006\u0010Q\u001a\u00020R2\u0006\u0010W\u001a\u00020XH&J$\u0010Y\u001a\b\u0012\u0004\u0012\u0002080\u00182\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002080\u00182\u0006\u0010<\u001a\u00020[H\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00028DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0$X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0018X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001b\u00a8\u0006^"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase;", "T", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinImportQuickFixAction;", "Lcom/intellij/codeInspection/HintAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "expression", "expressionToAnalyzePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "factory", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/psi/SmartPsiElementPointer;Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;)V", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;)V", "expressionToAnalyze", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "modificationCountOnCreate", "", "getExpressionToAnalyze", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "suggestions", "", "Lorg/jetbrains/kotlin/name/FqName;", "getSuggestions", "()Ljava/util/Collection;", "setSuggestions", "(Ljava/util/Collection;)V", "text", "", "computeSuggestions", "", "computeSuggestions$kotlin_idea", "supportedErrors", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getSupportedErrors", "()Ljava/util/Set;", "importNames", "Lorg/jetbrains/kotlin/name/Name;", "getImportNames", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver;", "calculateReceiverTypeFromDiagnostic", "Lorg/jetbrains/kotlin/types/KotlinType;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getReceiverTypeFromDiagnostic", "showHint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "calculateText", "suggestionDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getText", "getFamilyName", "isAvailable", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "invoke", "startInWriteAction", "isOutdated", "createAction", "Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "element", "createImportAction", "Lcom/intellij/codeInsight/hint/QuestionAction;", "createAutoImportAction", "filterSuggestions", "Lkotlin/Function1;", "isNestedClassifier", "declaration", "collectSuggestionDescriptors", "collectSuggestions", "collectSuggestionsForName", "name", "callTypeAndReceiver", "checkErrorStillPresent", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "elementsToCheckDiagnostics", "Lcom/intellij/psi/PsiElement;", "fillCandidates", "", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "reduceCandidatesBasedOnDependencyRuleViolation", "candidates", "Lcom/intellij/psi/PsiFile;", "Factory", "FactoryWithUnresolvedReferenceQuickFix", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,973:1\n1#2:974\n1#2:991\n1661#3,3:975\n1642#3,10:978\n1915#3:988\n1916#3:992\n1652#3:993\n1807#3,3:994\n1391#3:997\n1480#3,5:998\n777#3:1003\n873#3,2:1004\n777#3:1006\n873#3,2:1007\n1807#3,3:1009\n777#3:1012\n873#3,2:1013\n137#4:989\n137#4:990\n137#4:1015\n*S KotlinDebug\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixBase\n*L\n153#1:991\n147#1:975,3\n153#1:978,10\n153#1:988\n153#1:992\n153#1:993\n233#1:994,3\n247#1:997\n247#1:998,5\n283#1:1003\n283#1:1004,2\n287#1:1006\n287#1:1007,2\n299#1:1009,3\n318#1:1012\n318#1:1013,2\n176#1:989\n180#1:990\n272#1:1015\n*E\n"})
public abstract class ImportFixBase<T extends KtExpression>
extends KotlinImportQuickFixAction<T>
implements HintAction,
HighPriorityAction {
    @Nullable
    private final SmartPsiElementPointer<KtExpression> expressionToAnalyzePointer;
    @NotNull
    private final Project project;
    private final long modificationCountOnCreate;
    protected Collection<FqName> suggestions;
    @IntentionName
    private String text;
    @NotNull
    private final Set<DiagnosticFactory<?>> supportedErrors;

    protected ImportFixBase(@NotNull T expression, @Nullable SmartPsiElementPointer<KtExpression> expressionToAnalyzePointer, @NotNull Factory factory2) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        super((KtElement)expression);
        this.expressionToAnalyzePointer = expressionToAnalyzePointer;
        Project project = ((PsiElement)expression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.modificationCountOnCreate = PsiModificationTracker.getInstance((Project)this.project).getModificationCount();
        this.supportedErrors = CollectionsKt.toSet((Iterable)factory2.getSupportedErrors());
    }

    public ImportFixBase(@NotNull T expression, @NotNull Factory factory2) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        this(expression, (SmartPsiElementPointer<KtExpression>)null, factory2);
    }

    public ImportFixBase(@NotNull T expression, @NotNull KtExpression expressionToAnalyze, @NotNull Factory factory2) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionToAnalyze, (String)"expressionToAnalyze");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        this(expression, (SmartPsiElementPointer<KtExpression>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)expressionToAnalyze)), factory2);
    }

    @Nullable
    protected final KtExpression getExpressionToAnalyze() {
        KtExpression ktExpression = this.expressionToAnalyzePointer;
        if (ktExpression == null || (ktExpression = (KtExpression)ktExpression.getElement()) == null) {
            ktExpression = (KtExpression)this.getElement();
        }
        return ktExpression;
    }

    @NotNull
    protected final Collection<FqName> getSuggestions() {
        Collection<FqName> collection = this.suggestions;
        if (collection != null) {
            return collection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"suggestions");
        return null;
    }

    protected final void setSuggestions(@NotNull Collection<FqName> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.suggestions = collection;
    }

    public final void computeSuggestions$kotlin_idea() {
        Collection<DeclarationDescriptor> suggestionDescriptors = this.collectSuggestionDescriptors();
        this.setSuggestions(this.collectSuggestions(suggestionDescriptors));
        this.text = this.calculateText(suggestionDescriptors);
    }

    @NotNull
    protected Set<DiagnosticFactory<?>> getSupportedErrors() {
        return this.supportedErrors;
    }

    @NotNull
    protected abstract Collection<Name> getImportNames();

    @Nullable
    protected abstract CallTypeAndReceiver<?, ?> getCallTypeAndReceiver();

    @Nullable
    protected KotlinType calculateReceiverTypeFromDiagnostic(@NotNull Collection<? extends Diagnostic> diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        return null;
    }

    @Nullable
    protected final KotlinType getReceiverTypeFromDiagnostic() {
        KtExpression expression = this.getExpressionToAnalyze();
        KtExpression ktExpression = expression;
        if (ktExpression == null || (ktExpression = ResolutionUtils.analyze((KtElement)ktExpression, BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS)) == null) {
            return null;
        }
        KtExpression bindingContext = ktExpression;
        Collection diagnostics = bindingContext.getDiagnostics().forElement((PsiElement)expression);
        return this.calculateReceiverTypeFromDiagnostic(diagnostics);
    }

    public boolean showHint(@NotNull Editor editor) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                object = (KtExpression)this.getElement();
                if (object == null) break block6;
                KtExpression ktExpression = object;
                PsiElement p0 = (PsiElement)ktExpression;
                boolean bl = false;
                object = p0.isValid() ? ktExpression : null;
                if (object != null) break block7;
            }
            return false;
        }
        KtExpression element = object;
        if (this.isOutdated()) {
            return false;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled() || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        if (this.getSuggestions().isEmpty()) {
            return false;
        }
        return this.createAction(editor, element, this.getSuggestions()).showHint();
    }

    /*
     * WARNING - void declaration
     */
    @IntentionName
    private final String calculateText(Collection<? extends DeclarationDescriptor> suggestionDescriptors) {
        void $this$mapNotNullTo$iv$iv;
        Iterable it;
        Collection $this$mapTo$iv;
        Iterable iterable = suggestionDescriptors;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getOriginal());
        }
        $this$mapTo$iv = destination$iv;
        HashSet it2 = (HashSet)$this$mapTo$iv;
        boolean bl = false;
        HashSet hashSet = (HashSet)(!((Collection)it2).isEmpty() ? $this$mapTo$iv : null);
        if (hashSet == null) {
            return "";
        }
        HashSet descriptors = hashSet;
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null || (ktExpression = ((KtPureElement)ktExpression).getContainingKtFile()) == null) {
            return KotlinBundle.message((String)"fix.import", (Object[])new Object[0]);
        }
        KtExpression ktFile2 = ktExpression;
        ImportPrioritizer prioritizer = KotlinAddImportActionKt.createPrioritizerForFile$default((KtFile)ktFile2, false, 2, null);
        ExpressionWeigher expressionWeigher = ExpressionWeigher.Companion.createWeigher((PsiElement)this.getElement());
        Iterable $this$mapNotNull$iv = descriptors;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImportFixHelper.ImportInfo<Comparable> importInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            DeclarationDescriptor descriptor2 = (DeclarationDescriptor)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)descriptor2);
            if ((DescriptorUtilsKt.isExtensionProperty((DeclarationDescriptor)descriptor2) ? ImportFixHelper.ImportKind.EXTENSION_PROPERTY : (descriptor2 instanceof PropertyDescriptor ? ImportFixHelper.ImportKind.PROPERTY : (descriptor2 instanceof ClassConstructorDescriptor ? ImportFixHelper.ImportKind.CLASS : (descriptor2 instanceof TypeAliasConstructorDescriptor ? ImportFixHelper.ImportKind.TYPE_ALIAS : (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isOperator() ? ImportFixHelper.ImportKind.OPERATOR : (descriptor2 instanceof FunctionDescriptor && DescriptorUtilsKt.isExtension((DeclarationDescriptor)descriptor2) ? ImportFixHelper.ImportKind.EXTENSION_FUNCTION : (descriptor2 instanceof FunctionDescriptor ? ImportFixHelper.ImportKind.FUNCTION : (DescriptorUtils.isObject((DeclarationDescriptor)descriptor2) ? ImportFixHelper.ImportKind.OBJECT : (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY ? ImportFixHelper.ImportKind.ENUM_ENTRY : (descriptor2 instanceof ClassDescriptor ? ImportFixHelper.ImportKind.CLASS : (descriptor2 instanceof TypeAliasDescriptor ? ImportFixHelper.ImportKind.TYPE_ALIAS : null))))))))))) == null) {
                importInfo = null;
            } else {
                Name name2;
                StringBuilder stringBuilder;
                ImportFixHelper.ImportKind kind2;
                kind2 = kind2;
                StringBuilder $this$calculateText_u24lambda_u242_u240 = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                if (descriptor2 instanceof CallableDescriptor || descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                    ReceiverParameterDescriptor extensionReceiverParameter;
                    CallableDescriptor callableDescriptor = descriptor2 instanceof CallableDescriptor ? (CallableDescriptor)descriptor2 : null;
                    Object object = extensionReceiverParameter = callableDescriptor != null ? callableDescriptor.getExtensionReceiverParameter() : null;
                    if (extensionReceiverParameter != null) {
                        ClassDescriptor classDescriptor;
                        $this$safeAs$iv = extensionReceiverParameter.getType().getConstructor().getDeclarationDescriptor();
                        $i$f$safeAs = false;
                        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
                        if (!(declarationDescriptor instanceof ClassDescriptor)) {
                            declarationDescriptor = null;
                        }
                        if ((classDescriptor = (ClassDescriptor)declarationDescriptor) != null && (classDescriptor = classDescriptor.getName()) != null) {
                            it = classDescriptor;
                            boolean bl5 = false;
                            $this$calculateText_u24lambda_u242_u240.append(it.asString());
                        }
                    } else {
                        ClassifierDescriptor classifierDescriptor;
                        $this$safeAs$iv = ((DeclarationDescriptorNonRoot)descriptor2).getContainingDeclaration();
                        $i$f$safeAs = false;
                        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
                        if (!(declarationDescriptor instanceof ClassifierDescriptor)) {
                            declarationDescriptor = null;
                        }
                        if ((classifierDescriptor = (ClassifierDescriptor)declarationDescriptor) != null && (classifierDescriptor = classifierDescriptor.getName()) != null) {
                            it = classifierDescriptor;
                            boolean bl6 = false;
                            $this$calculateText_u24lambda_u242_u240.append(it.asString());
                        }
                    }
                }
                Name it3 = name2 = descriptor2.getName();
                boolean bl7 = false;
                Object object = !it3.isSpecial() ? name2 : null;
                if (object != null) {
                    it3 = object;
                    boolean bl8 = false;
                    if (((CharSequence)$this$calculateText_u24lambda_u242_u240).length() > 0) {
                        $this$calculateText_u24lambda_u242_u240.append('.');
                    }
                    $this$calculateText_u24lambda_u242_u240.append(it3.asString());
                }
                String name3 = stringBuilder.toString();
                ImportPrioritizer.Priority priority = KotlinAddImportActionKt.createDescriptorPriority(prioritizer, expressionWeigher, descriptor2);
                importInfo = new ImportFixHelper.ImportInfo<Comparable>(kind2, name3, priority);
            }
            if (importInfo == null) continue;
            ImportFixHelper.ImportInfo<Comparable> it$iv$iv = importInfo;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List importInfos = (List)destination$iv$iv;
        return ImportFixHelper.INSTANCE.calculateTextForFix(importInfos, (Iterable<FqName>)this.getSuggestions());
    }

    @NotNull
    public String getText() {
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            string = null;
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.import", (Object[])new Object[0]);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getElement() != null && !this.getSuggestions().isEmpty();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression element = ktExpression;
        CommandProcessor.getInstance().runUndoTransparentAction(() -> ImportFixBase.invoke$lambda$0(this, editor, element));
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private final boolean isOutdated() {
        return this.modificationCountOnCreate != PsiModificationTracker.getInstance((Project)this.project).getModificationCount();
    }

    @NotNull
    protected KotlinAddImportAction createAction(@NotNull Editor editor, @NotNull KtExpression element, @NotNull Collection<FqName> suggestions) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return KotlinAddImportActionKt.createSingleImportAction(project, editor, (KtElement)element, suggestions);
    }

    @Override
    @Nullable
    public QuestionAction createImportAction(@NotNull Editor editor, @NotNull KtFile file) {
        KotlinAddImportAction kotlinAddImportAction;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            kotlinAddImportAction = this.createAction(editor, it, this.getSuggestions());
        } else {
            kotlinAddImportAction = null;
        }
        return kotlinAddImportAction;
    }

    @Override
    @Nullable
    public QuestionAction createAutoImportAction(@NotNull Editor editor, @NotNull KtFile file, @NotNull Function1<? super Collection<FqName>, ? extends Collection<FqName>> filterSuggestions) {
        KotlinAddImportAction kotlinAddImportAction;
        boolean bl;
        Collection suggestions;
        block11: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(filterSuggestions, (String)"filterSuggestions");
            suggestions = (Collection)filterSuggestions.invoke(this.getSuggestions());
            if (suggestions.isEmpty() || !ImportFixHelper.INSTANCE.suggestionsAreFromSameParent(suggestions)) {
                return null;
            }
            Iterable $this$any$iv = suggestions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block10: {
                        FqName suggestion = (FqName)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = ResolutionUtils.resolveImportReference(file, suggestion);
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv2;
                                boolean bl4 = false;
                                if (!this.isNestedClassifier(p0)) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl5 = false;
            kotlinAddImportAction = this.createAction(editor, it, suggestions);
        } else {
            kotlinAddImportAction = null;
        }
        return kotlinAddImportAction;
    }

    private final boolean isNestedClassifier(DeclarationDescriptor declaration) {
        return declaration instanceof ClassifierDescriptor && ((ClassifierDescriptor)declaration).getContainingDeclaration() instanceof ClassifierDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> collectSuggestionDescriptors() {
        void $this$flatMapTo$iv$iv;
        Object p0;
        block7: {
            block6: {
                Object object = (KtExpression)this.getElement();
                if (object == null) break block6;
                KtExpression ktExpression = object;
                p0 = (PsiElement)ktExpression;
                boolean bl = false;
                object = p0.isValid() ? ktExpression : null;
                if (object == null) break block6;
                PsiElement it = p0 = object;
                boolean bl2 = false;
                object = it.getContainingFile() instanceof KtFile ? p0 : null;
                if (object != null) break block7;
            }
            return CollectionsKt.emptyList();
        }
        CallTypeAndReceiver<?, ?> callTypeAndReceiver = this.getCallTypeAndReceiver();
        if (callTypeAndReceiver == null) {
            return CollectionsKt.emptyList();
        }
        CallTypeAndReceiver<?, ?> callTypeAndReceiver2 = callTypeAndReceiver;
        if (callTypeAndReceiver2 instanceof CallTypeAndReceiver.UNKNOWN) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = this.getImportNames();
        boolean $i$f$flatMap = false;
        p0 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Name it = (Name)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectSuggestionsForName(it, callTypeAndReceiver2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<FqName> collectSuggestions(Collection<? extends DeclarationDescriptor> suggestionDescriptors) {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)suggestionDescriptors), ImportFixBase::collectSuggestions$lambda$0)));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> collectSuggestionsForName(Name name2, CallTypeAndReceiver<?, ?> callTypeAndReceiver) {
        void $this$filterTo$iv$iv;
        boolean isCall;
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression element = ktExpression;
        KtExpression ktExpression2 = this.getExpressionToAnalyze();
        if (ktExpression2 == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression expressionToAnalyze = ktExpression2;
        String string = name2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String nameStr = string;
        if (((CharSequence)nameStr).length() == 0) {
            return CollectionsKt.emptyList();
        }
        KtFile ktFile2 = ((KtPureElement)element).getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)expressionToAnalyze, BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
        if (!this.checkErrorStillPresent(bindingContext)) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope searchScope = ScopeUtilsKt.getResolveScope(file);
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)file);
        KotlinIndicesHelper indicesHelper2 = new KotlinIndicesHelper(resolutionFacade, searchScope, (Function1)new Function1<DeclarationDescriptor, Boolean>(element, callTypeAndReceiver, bindingContext, resolutionFacade){
            final /* synthetic */ T $element;
            final /* synthetic */ CallTypeAndReceiver<?, ?> $callTypeAndReceiver;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            {
                this.$element = $element;
                this.$callTypeAndReceiver = $callTypeAndReceiver;
                this.$bindingContext = $bindingContext;
                this.$resolutionFacade = $resolutionFacade;
                super(1, Intrinsics.Kotlin.class, "isVisible", "collectSuggestionsForName$isVisible(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", 0);
            }

            public final Boolean invoke(DeclarationDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ImportFixBase.access$collectSuggestionsForName$isVisible(this.$element, this.$callTypeAndReceiver, this.$bindingContext, this.$resolutionFacade, p0);
            }
        }, null, null, false, false, file, 120, null);
        List result2 = this.fillCandidates(nameStr, callTypeAndReceiver, bindingContext, indicesHelper2);
        if (callTypeAndReceiver instanceof CallTypeAndReceiver.DEFAULT && !(isCall = ((KtElement)element).getParent() instanceof KtCallExpression)) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = result2;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof FunctionDescriptor))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            result2 = (List)destination$iv$iv;
        }
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        Iterable $i$f$filter2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!ImportFilter.shouldImport((PsiFile)((PsiFile)file), (String)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it).asString())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        result2 = (List)destination$iv$iv;
        return result2.size() > 1 ? this.reduceCandidatesBasedOnDependencyRuleViolation(result2, (PsiFile)file) : (Collection<DeclarationDescriptor>)result2;
    }

    private final boolean checkErrorStillPresent(BindingContext bindingContext) {
        Set<DiagnosticFactory<?>> errors = this.getSupportedErrors();
        Collection<PsiElement> elementsToCheckDiagnostics = this.elementsToCheckDiagnostics();
        for (PsiElement psiElement : elementsToCheckDiagnostics) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = bindingContext.getDiagnostics().forElement(psiElement);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        if (!errors.contains(it.getFactory())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Collection<PsiElement> elementsToCheckDiagnostics() {
        return CollectionsKt.listOfNotNull(this.getElement());
    }

    @NotNull
    public abstract List<DeclarationDescriptor> fillCandidates(@NotNull String var1, @NotNull CallTypeAndReceiver<?, ?> var2, @NotNull BindingContext var3, @NotNull KotlinIndicesHelper var4);

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> reduceCandidatesBasedOnDependencyRuleViolation(Collection<? extends DeclarationDescriptor> candidates2, PsiFile file) {
        void $this$filterTo$iv$iv;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyValidationManager, (String)"getInstance(...)");
        DependencyValidationManager validationManager = dependencyValidationManager;
        Iterable $this$filter$iv = candidates2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, it);
            if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
                bl = true;
            } else {
                PsiElement targetFile = psiElement;
                DependencyRule[] dependencyRuleArray = validationManager.getViolatorDependencyRules(file, (PsiFile)targetFile);
                Intrinsics.checkNotNullExpressionValue((Object)dependencyRuleArray, (String)"getViolatorDependencyRules(...)");
                bl = ((Object[])dependencyRuleArray).length == 0;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void invoke$lambda$0(ImportFixBase this$0, Editor $editor, KtExpression $element) {
        Editor editor = $editor;
        Intrinsics.checkNotNull((Object)editor);
        this$0.createAction(editor, $element, this$0.getSuggestions()).execute();
    }

    private static final FqName collectSuggestions$lambda$0(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it);
    }

    private static final <T extends KtExpression> boolean collectSuggestionsForName$isVisible(T element, CallTypeAndReceiver<?, ?> $callTypeAndReceiver, BindingContext bindingContext, ResolutionFacade resolutionFacade, DeclarationDescriptor descriptor2) {
        Object obj;
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility;
        DeclarationDescriptor $this$safeAs$iv = descriptor2;
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof DeclarationDescriptorWithVisibility)) {
            declarationDescriptor = null;
        }
        return (declarationDescriptorWithVisibility = (DeclarationDescriptorWithVisibility)declarationDescriptor) != null ? org.jetbrains.kotlin.idea.core.DescriptorUtilsKt.isVisible(declarationDescriptorWithVisibility, (PsiElement)element, (obj = $callTypeAndReceiver.getReceiver()) instanceof KtExpression ? (KtExpression)obj : null, bindingContext, resolutionFacade) : true;
    }

    public static final /* synthetic */ boolean access$collectSuggestionsForName$isVisible(KtExpression element, CallTypeAndReceiver $callTypeAndReceiver, BindingContext bindingContext, ResolutionFacade resolutionFacade, DeclarationDescriptor descriptor2) {
        return ImportFixBase.collectSuggestionsForName$isVisible(element, $callTypeAndReceiver, bindingContext, resolutionFacade, descriptor2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0014R%\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "supportedErrors", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getSupportedErrors", "()Ljava/util/Collection;", "supportedErrors$delegate", "Lkotlin/Lazy;", "isApplicableForCodeFragment", "", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "areActionsAvailable", "createImportActionsForAllProblems", "", "sameTypeDiagnostics", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "doCreateActionsForAllProblems", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,973:1\n1#2:974\n1#2:976\n2802#3:975\n*S KotlinDebug\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory\n*L\n353#1:976\n353#1:975\n*E\n"})
    public static abstract class Factory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        private final Lazy supportedErrors$delegate = LazyKt.lazy(() -> Factory.supportedErrors_delegate$lambda$0(this));

        @NotNull
        public final Collection<DiagnosticFactory<?>> getSupportedErrors() {
            Lazy lazy = this.supportedErrors$delegate;
            return (Collection)lazy.getValue();
        }

        @Override
        protected boolean isApplicableForCodeFragment() {
            return true;
        }

        @Nullable
        public abstract ImportFixBase<?> createImportAction(@NotNull Diagnostic var1);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean areActionsAvailable(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement element = diagnostic.getPsiElement();
            if (!(element instanceof KtExpression)) return false;
            PsiReference[] psiReferenceArray = ((KtExpression)element).getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            if (((Object[])psiReferenceArray).length != 0) return true;
            return false;
        }

        @NotNull
        public List<ImportFixBase<?>> createImportActionsForAllProblems(@NotNull Collection<? extends Diagnostic> sameTypeDiagnostics) {
            Intrinsics.checkNotNullParameter(sameTypeDiagnostics, (String)"sameTypeDiagnostics");
            return CollectionsKt.emptyList();
        }

        @Override
        @Nullable
        protected final IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            IntentionAction intentionAction;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            try {
                ImportFixBase<?> importFixBase;
                ImportFixBase<?> importFixBase2 = this.createImportAction(diagnostic);
                if (importFixBase2 != null) {
                    ImportFixBase<?> importFixBase3;
                    ImportFixBase<?> it = importFixBase3 = importFixBase2;
                    boolean bl = false;
                    it.computeSuggestions$kotlin_idea();
                    importFixBase = importFixBase3;
                } else {
                    importFixBase = null;
                }
                intentionAction = importFixBase;
            }
            catch (KotlinExceptionWithAttachments ex) {
                block8: {
                    block7: {
                        if (!AbstractImportFixInfo.INSTANCE.getIGNORE_MODULE_ERROR()) break block7;
                        String string = ex.getMessage();
                        if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"<production sources for module light_idea_test_case>", (boolean)false, (int)2, null) : false) break block8;
                    }
                    throw ex;
                }
                intentionAction = null;
            }
            return intentionAction;
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActionsForAllProblems(@NotNull Collection<? extends Diagnostic> sameTypeDiagnostics) {
            Iterable iterable;
            Intrinsics.checkNotNullParameter(sameTypeDiagnostics, (String)"sameTypeDiagnostics");
            Iterable $this$onEach$iv = this.createImportActionsForAllProblems(sameTypeDiagnostics);
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u240$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u240$iv) {
                ImportFixBase it = (ImportFixBase)element$iv;
                boolean bl2 = false;
                it.computeSuggestions$kotlin_idea();
            }
            return (List)iterable;
        }

        private static final Collection supportedErrors_delegate$lambda$0(Factory this$0) {
            return QuickFixes.Companion.getInstance().getDiagnostics(this$0);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$FactoryWithUnresolvedReferenceQuickFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/UnresolvedReferenceQuickFixFactory;", "<init>", "()V", "kotlin.idea"})
    public static abstract class FactoryWithUnresolvedReferenceQuickFix
    extends Factory
    implements UnresolvedReferenceQuickFixFactory {
    }
}

