/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.WeighingComparable;
import com.intellij.psi.WeighingService;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.base.util.ImportableFqNameClassifier;
import org.jetbrains.kotlin.idea.quickfix.ImportComparablePriority;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isImportedByDefault", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "compareNames", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Z)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "classifier", "Lorg/jetbrains/kotlin/idea/base/util/ImportableFqNameClassifier;", "statsManager", "Lcom/intellij/psi/statistics/StatisticsManager;", "kotlin.jvm.PlatformType", "proximityLocation", "Lcom/intellij/psi/util/ProximityLocation;", "Priority", "GroupPriority", "kotlin.fir.frontend-independent"})
public final class ImportPrioritizer {
    @NotNull
    private final KtFile file;
    private final boolean compareNames;
    @NotNull
    private final ImportableFqNameClassifier classifier;
    private final StatisticsManager statsManager;
    @NotNull
    private final ProximityLocation proximityLocation;

    public ImportPrioritizer(@NotNull KtFile file, @NotNull Function1<? super FqName, Boolean> isImportedByDefault, boolean compareNames) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(isImportedByDefault, (String)"isImportedByDefault");
        this.file = file;
        this.compareNames = compareNames;
        this.classifier = new ImportableFqNameClassifier(this.file, isImportedByDefault);
        this.statsManager = StatisticsManager.getInstance();
        this.proximityLocation = new ProximityLocation((PsiElement)this.file, GenericPsiUtils.getModule((PsiElement)this.file));
    }

    public /* synthetic */ ImportPrioritizer(KtFile ktFile2, Function1 function1, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(ktFile2, (Function1<? super FqName, Boolean>)function1, bl);
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004R\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0096\u0082\u0004R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004R\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0004R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer$GroupPriority;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportComparablePriority;", "priorities", "", "Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer$Priority;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer;", "<init>", "(Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer;Ljava/util/List;)V", "groupPriority", "compareTo", "", "other", "kotlin.fir.frontend-independent"})
    public final class GroupPriority
    implements ImportComparablePriority {
        @NotNull
        private final List<Priority> priorities;
        @NotNull
        private final Priority groupPriority;

        public GroupPriority(List<Priority> priorities) {
            Intrinsics.checkNotNullParameter(priorities, (String)"priorities");
            this.priorities = priorities;
            this.groupPriority = (Priority)CollectionsKt.maxOrThrow((Iterable)this.priorities);
        }

        @Override
        public int compareTo(@NotNull ImportComparablePriority other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            GroupPriority cfr_ignored_0 = (GroupPriority)other;
            int c1 = this.groupPriority.compareTo(((GroupPriority)other).groupPriority);
            if (c1 != 0) {
                return c1;
            }
            return ((GroupPriority)other).priorities.size() - this.priorities.size();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0001H\u0096\u0082\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer$Priority;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportComparablePriority;", "declaration", "Lcom/intellij/psi/PsiElement;", "statisticsInfo", "Lcom/intellij/psi/statistics/StatisticsInfo;", "isDeprecated", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "expressionWeight", "", "<init>", "(Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/statistics/StatisticsInfo;ZLorg/jetbrains/kotlin/name/FqName;I)V", "getStatisticsInfo", "()Lcom/intellij/psi/statistics/StatisticsInfo;", "classification", "Lorg/jetbrains/kotlin/idea/base/util/ImportableFqNameClassifier$Classification;", "lastUseRecency", "proximityWeight", "Lcom/intellij/psi/WeighingComparable;", "Lcom/intellij/psi/util/ProximityLocation;", "compareTo", "other", "kotlin.fir.frontend-independent"})
    public final class Priority
    implements ImportComparablePriority {
        @NotNull
        private final StatisticsInfo statisticsInfo;
        private final boolean isDeprecated;
        @NotNull
        private final FqName fqName;
        private final int expressionWeight;
        @NotNull
        private final ImportableFqNameClassifier.Classification classification;
        private final int lastUseRecency;
        @NotNull
        private final WeighingComparable<PsiElement, ProximityLocation> proximityWeight;

        public Priority(@NotNull PsiElement declaration, StatisticsInfo statisticsInfo, @NotNull boolean isDeprecated, FqName fqName2, int expressionWeight) {
            Intrinsics.checkNotNullParameter((Object)statisticsInfo, (String)"statisticsInfo");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            this.statisticsInfo = statisticsInfo;
            this.isDeprecated = isDeprecated;
            this.fqName = fqName2;
            this.expressionWeight = expressionWeight;
            this.classification = ImportPrioritizer.this.classifier.classify(this.fqName, false);
            this.lastUseRecency = ImportPrioritizer.this.statsManager.getLastUseRecency(this.statisticsInfo);
            WeighingComparable weighingComparable = WeighingService.weigh((Key)PsiProximityComparator.WEIGHER_KEY, (Object)declaration, (Object)ImportPrioritizer.this.proximityLocation);
            Intrinsics.checkNotNullExpressionValue((Object)weighingComparable, (String)"weigh(...)");
            this.proximityWeight = weighingComparable;
        }

        @NotNull
        public final StatisticsInfo getStatisticsInfo() {
            return this.statisticsInfo;
        }

        @Override
        public int compareTo(@NotNull ImportComparablePriority other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Priority cfr_ignored_0 = (Priority)other;
            if (this.isDeprecated != ((Priority)other).isDeprecated) {
                return this.isDeprecated ? 1 : -1;
            }
            int c1 = Intrinsics.compare((int)this.expressionWeight, (int)((Priority)other).expressionWeight);
            if (c1 != 0) {
                return -c1;
            }
            int c2 = this.classification.compareTo((Enum)((Priority)other).classification);
            if (c2 != 0) {
                return c2;
            }
            int c3 = Intrinsics.compare((int)this.lastUseRecency, (int)((Priority)other).lastUseRecency);
            if (c3 != 0) {
                return c3;
            }
            int c4 = this.proximityWeight.compareTo(((Priority)other).proximityWeight);
            if (c4 != 0) {
                return -c4;
            }
            return ImportPrioritizer.this.compareNames ? this.fqName.asString().compareTo(((Priority)other).fqName.asString()) : 0;
        }
    }
}

